module AR::Game::DefenseBehavior
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save

  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :defense_techniques do |techs, kase|
      case kase
      when :load
        techs.map.map{|t| Object.const_get(t.to_s).new}
      when :unload
        techs.map(&:class)
      end
    end
    ar_object.defense_techniques=[]
  end

  def self.extended ar_object
    self.init ar_object
    #add to object's event subscriptions and resolutions here...
  end 

  def self.defend_option_on_attack_began
    AR::Events::Resolution.new when: AR::Events::AttackBegan, as: "target" do |e|
      t = e.target
      if t.is_performing? or t.action_points <= 0
        nil
      else
        #should return an action began event
        DefenseMenu.new(t).present
      end
    end
  end



end
