require_relative "../classes.rb"

class TestLootableContainer < BaseBehaviorTestCase

  def setup
    super
    @subject = Chest.new
    @looter = Traveller.new
  end

  def test_release_items_added_to_looter_inventory_released_on_loot
    i1 = SomeItem.new
    i2 = SomeItem.new
    @subject.add_inventory_item i1 
    @subject.add_inventory_item i2 
    e = AR::Events::Loot.new looter: @looter, container: @subject   
    results = e.resolve!

    assert_equal 4, results.size

    added = results.select{|ev| ev.class == AR::Events::ItemAddedToInventory }

    assert_equal 2, added.size

    assert_equal @looter, added[0].inventory_owner
    assert_equal @looter, added[1].inventory_owner
  end

  def test_release_items_removed_from_lootable_inventory_released_on_loot
    i1 = SomeItem.new
    i2 = SomeItem.new
    @subject.add_inventory_item i1 
    @subject.add_inventory_item i2 
    e = AR::Events::Loot.new looter: @looter, container: @subject   
    results = e.resolve!

    assert_equal 4, results.size

    removed  = results.select{|ev| ev.class == AR::Events::ItemRemovedFromInventory }

    assert_equal 2, removed .size

    assert_equal @subject, removed [0].inventory_owner
    assert_equal @subject, removed [1].inventory_owner
   
  end



end

