module AR
  module Game
    class Player < Character 
      def initialize id=nil
        super id 
        add_behavior Narrator
        add_behavior PlayerControl
        add_behavior HungerBehavior 
        add_behavior PaperDoll 

        add_story_implement StoryImplement.new

        after_gauges_init do 
          str = self.gauge("strength")
          dex = self.gauge("dexterity")
          perc = self.gauge("perception")

          str.change_current_and_max 3
          dex.change_current_and_max 3 
          perc.change_current_and_max 3 
          [str, dex, perc].map(&:manual_child_sync) 
        end

        hostility_check do |other_obj|
          other_obj.is_a? AR::Game::Monster
        end

        self.noun = "player"
        self.ownership = "your"
      end  

      class Story < AR::Game::StoryBehavior::Story
      end
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::ActionPerformedEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::DefendAction"
              att = a.attacker
              tech = a.parameter("technique").argument
              case tech.class.to_s 
              when "AR::Game::DodgeTech"
                "Anticipating the incoming blow, you attempt to maneuver out of the way."
              else
                ""
              end
            when "AR::Game::AttackAction"
              tech = a.parameter("technique").argument
              case tech.class.to_s
              when "AR::Game::Punch"
                "Your punch flies toward #{t.name}."
              else
              end
            when "AR::Game::InspectAction"
              target = a.parameter("target").argument

              if target == a.performer.parent
                "You check out your surroundings."
              else
                "You inspect #{target.name}."
              end
            when "AR::Game::GrabAction"
              target = a.parameter("item").argument
              "You pick up #{target.name} and put it in your bag."
            when "AR::Game::LootAction"
              target = a.parameter("target").argument
              "You rummage around #{target.name} to see if you can find anything useful."
            end#case action class

          end#story proc
          add_story s

          s = Story.new when: AR::Events::DamageReceived, as: "damaged" do |e|
            p  = e.damaged
            am = e.actual_amount
            dmger = e.damager
            ret  = ""
            if am > 7
              ret += "#{p.name.capitalize} take a huge amount of damage (#{am}) from #{dmger.name}, and stumble back reeling in pain."
            elsif am > 4
              ret += "#{p.name.capitalize} take a mediocere amount of damage (#{am}) from #{dmger.name}."
            elsif am > 2
              ret += "#{p.name.capitalize} take a small amount of damage (#{am}) from #{dmger.name}."
            else 
              ret += "#{p.name.capitalize} take a tiny amount of damage (#{am}) from #{dmger.name}."
            end

            ret += " "
            percent = p.gauge("health").percent_capacity
            if percent >= 75 
              ret += "However, #{p.name.capitalize} still feel very healthy."
            elsif percent >= 50
              ret += "#{p.ownership.capitalize} wounds are becoming a distraction."
            elsif percent >= 25
              ret += "#{p.name.capitalize} are quite faint from #{p.ownership} wounds."
            elsif percent <= 0
              ret += "#{p.ownership.capitalize} wounds are too much to bear; #{p.name} stumble off #{p.ownership} feet in shock."
            else
              ret += "#{p.name.capitalize} wounds are dire; is this the end?"
            end


            ret
          end
          add_story s


          s = Story.new when: AR::Events::ActionBeganEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              tech = a.parameter("technique").argument
              case tech.class.to_s
              when "AR::Game::Punch"
                "You leap forward, winding up to swing at #{t.name} with your fist."
              else
              end
            else
              ""
            end
          end
          add_story s


          #TODO case the tech that was used
          s = Story.new when: AR::Events::HitSuccess, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "Your fist bludgeons into a tender spot."
          end
          add_story s

          #TODO case the tech that was used
          s = Story.new when: AR::Events::HitFailure, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "Your attack didn't connect."
          end
          add_story s


        end
      end


    end 
  end 
end
