class AR::Events::ActionPerformedEvent < AR::Events::Event
  attr_accessor :action
  attr_participant :performer
  attr_participant :primary_target

  def initialize params
    self.action = params[:action]
    params[:performer] = params[:action].performer

    t_param = self.action.parameter("target")
    unless t_param.nil?
      params[:primary_target] = t_param.argument
    else
      params[:primary_target] = @action.primary_target
    end

    super params
  end 


  def default_story
    action_verb = (performer == engine.world.player) ? action.name : action.name + "s"
    #AR.log("#{self.class}: getting default for #{self.action.name}")
    case self.action.name
    when "wait"
      ""
    when "grab"
      "#{performer.name} #{action_verb} #{action.parameter("item").argument.name}." 
    when "give"
      "#{performer.name} #{action_verb} #{action.parameter("item").argument.name} to #{action.parameter("receiver").argument.name}." 
    when "attack"
      "#{performer.name} #{action_verb} #{action.parameter("target").argument.name} with #{performer.ownership} #{action.parameter("technique").argument.name} technique." 
    when "put"
      "#{performer.name} #{action_verb} #{action.parameter("item").argument.name} down on the ground." 
    when "travel"
      "#{performer.name} #{action_verb} via #{action.parameter("gateway").argument.name}." 
    when "talk"
      action_verb = (performer == engine.world.player) ? "approach" : "approaches"
      "#{performer.name} #{action_verb} #{action.parameter("npc").argument.name} to talk." 
    when "defend"
      "#{performer.name} #{action_verb} against an attack." 
    when "consume"
      ""
    when "equip"
      "#{performer.name} #{action_verb} #{action.parameter("item").argument.name}." 
    else
    end
  end

  def resolve! 
    results = super
    results.push action.perform
    results
  end 

end
