module AR::Game::DropsLoot 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save

  attr_accessor :death_drop_proc
  #...initialize them here
  def self.init ar_object 
    #add attr_serializeable properties here... 
    #if you do need them serialized on save
    #ar_object.attr_serializeable :prop1, :prop2, &block
    
    #should be a type of corpse?
    ar_object.class.attr_serializeable :on_death_drop_type
    
  end

  def self.extended ar_object
    self.init ar_object
    
    ar_object.resolutions << drop_stuff_when_death_occurs

    #add to object's event subscriptions and resolutions here...

  end 

  def self.drop_stuff_when_death_occurs 

    AR::Events::Resolution.new event_class: AR::Events::ARObjectDied, as: "ar_object" do |e|
      obj = e.ar_object
      inh = obj.parent
      if inh.nil? and !e.killer.nil?
        AR.log("thing that died has no parent? just going to try getting it from killer")
        inh = e.killer.parent
      end
      raise "No parent on object that died?  Needed for death drops" if inh.nil?
      type = nil
      if obj.on_death_drop_type.class == String
         type = Object.const_get(obj.on_death_drop_type)
      else
        type = obj.on_death_drop_type
      end
      corpse = type.new
      corpse.inventory_item_ids = obj.get_item_drops(e).compact.map(&:id)

      AR::Events::ARObjectEnteredInhabitableEvent.new enterer: corpse, inhabitable: obj.parent, placement: "on the ground", dont_narrate: true
    end
  end

  def on_death_item_drop_proc &bl
    self.death_drop_proc = bl
  end

  def get_item_drops death_evt
    self.death_drop_proc.call(death_evt) unless death_drop_proc.nil?
  end

end
