module AR
  module Game

    class Forest04 < Scene
      def initialize id=nil
        super 
        self.noun = "forest"
        self.add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "Serenity fills you, as you brush aside vines and branches, leading to a forest glade."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "All around are patches of brightly colored flowers, being kissed by butterflies.  Soft cobblestones begin to define the path."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end

    end



  end
end
