require "./lib/apocrodentia"
require "test/unit"


#TODO:
#set event class engine in test lib
#set world global up 
#set AR::Object world to world global

class TestPlayerMemory < Test::Unit::TestCase 
  attr_accessor :world
  include TestTypes

  class TestObject < AR::Game::ARObject
    def initialize id
      super id
      self.add_behavior AR::Game::PlayerMemory
    end
  end

  def setup
    self.world = World.new
    AR::Game::Behavior.set_world self.world

    @player = AR::Game::Player.new 
    @some_obj = SomeItem.new
     
    @test_data = {remembered_object_ids: [41,31,23], remembered_object_names_ids: ["jos", "ephe", "yoyo"]}
  end

  def test_memory_of_objects_works_on_discovered_event
    e = @player.create AR::Events::DiscoveryMadeEvent, {perceiver: @player, discovered: @some_obj}
    results = e.resolve!
    remembered_e = results.select{|evt| evt.class == AR::Events::DiscoverableRememberedEvent}.last
    assert_not_nil remembered_e, "No remembered event on discovered?"
    remembered_e.resolve!
    assert @player.remembered_object_ids.include? @some_obj.id
  end


  def test_x_happens_when_y_happens
  end
end
