module AR
  
  module Game

    class CaveSpider < Monster 
      def initialize id=nil
        super 

        self.noun = "cave spider"
        add_story_implement StoryImplement.new

        after_gauges_init do |spidey|
          dex = spidey.gauge("dexterity")
          str = spidey.gauge("strength")
          per = spidey.gauge("perception")
          dex.change_current_and_max 5
          str.change_current_and_max 1
          per.change_current_and_max 10
          [str, dex, per].map(&:manual_child_sync) 
        end

        add_behavior AR::Game::DropsLoot
        self.on_death_drop_type = AR::Game::CaveSpiderCorpse
        self.on_death_item_drop_proc do |death_evt|
          items = [] 
          items.push(AR::Game::BeetleMeat.new)
          roll = rand(1..100)
          chance = 75
          if roll <= chance
            items.push(AR::Game::GreenMushroom.new)
          end
          items
        end



        r = AR::Events::Resolution.new event_class: AR::Events::HitSuccess, as: "hitter" do |e|
          c = e.hitee
          all_poison_buffs = c.world.all_ar_objects.select{|o| o.class == AR::Game::PoisonBuff}
          on_this_char = all_poison_buffs.select{|pb| pb.character_id == c.id}
          chance = 25
          roll = rand(1..100)
          poisoned = roll <= chance

          if on_this_char.empty? and poisoned
            buff = PoisonBuff.new.subscribe!
            str = rand(1..4) 
            str *= 2 if e.is_critical
            buff.strength = str
            buff.character = c
            AR::Events::BuffApplied.new buff: buff, subject: c
          end
        end
        self.resolutions << r


      end#init

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::DiscoveryMadeEvent, as: "perceiver" do |e|
            p = e.perceiver
            d = e.discovered
            if d.is_a? AR::Game::Character and d != p
              "You freeze in your tracks.  #{p.name.capitalize} lurks in front of you.   All 8 eyes black, and nestled into it's greasy looking carapace.  #{p.ownership.capitalize} two frontal legs lift toward #{d.name}; it looks aggressive."
            end
          end
          add_story s

          s = Story.new when: AR::Events::ActionBeganEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "#{p.name.capitalize} gnaws with it's dagger-like fangs and it scurries within pouncing range.  Venom drips from the tips of them like big, ugly syringes."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::ARObjectDied, as: "ar_object" do |e|
            "The spider flops upside down, and it's legs begin to twitch. Within a few seconds, the legs curl up in rigamortis."
          end
          add_story s



          s = Story.new when: AR::Events::ActionPerformedEvent, as: "performer" do |e|
            p = e.performer
            a = e.action
            t = e.primary_target
            case a.class.to_s
            when "AR::Game::AttackAction"
              "#{p.name.capitalize} launches itself at #{t.name} fang first."
            when "AR::Game::DefendAction"
              "#{p.name.capitalize} shoots backward to dodge #{a.attacker.ownership} attack."
            else
              ""
            end
          end
          add_story s


          s = Story.new when: AR::Events::HitSuccess, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s fangs work their way into #{he.name}. #{he} can feel the venom being injected."
          end
          add_story s

          s = Story.new when: AR::Events::HitSuccess, as: "hitee" do |e|
            h = e.hitter
            he = e.hitee
            "#{he.name.capitalize} takes it's blow and hisses, seemingly yearning for revenge."

          end
          add_story s


          s = Story.new when: AR::Events::HitFailure, as: "hitter" do |e|
            h = e.hitter
            he = e.hitee
            "#{h.name.capitalize}'s fangs are deflected by #{he.name}."
          end
          add_story s

        end

      end


    end#spidey
  end#Game
end#AR
