module AR
  module Game

    class Cave04 < Scene
      def initialize id=nil
        super 

        self.noun = "scene"

        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "Entering this chamber is quite difficult, as it is completely covered with a film of web.  Every step causes your feet to stick to the ground."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "Your torch reveals the heart of this cavern: A terrible nest of a spiders."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end




  end
end
