require_relative "./classes.rb"

class TestHealth < BaseBehaviorTestCase

  def setup
    super
    @subject = Traveller.new.subscribe!
    @damager = Traveller.new.subscribe!
    test_init_gauges
  end

  def test_we_get_a_object_died_event_when_lethal_damage_taken
    life_left = @subject.hit_points 
    e = AR::Events::DamageReceived.new damaged: @subject, damager: @damager, subject: @subject, damage_amount: life_left
    results = e.resolve!
    death_event = results.first
    assert_equal AR::Events::ARObjectDied, death_event.class
    assert_equal @subject, death_event.ar_object 
    assert_equal e, death_event.cause
  end

  def test_objects_subscriptions_removed_on_death
    e = AR::Events::ARObjectDied.new ar_object: @subject
    assert !(e.engine.subscriptions & @subject.subscriptions).empty?
    e.resolve!
    assert_empty(e.engine.subscriptions & @subject.subscriptions)
  end

  def test_game_over_released_when_player_dies
    p = Player.new.subscribe!
    e = AR::Events::ARObjectDied.new ar_object: p 
    game_over = e.resolve!.first
    assert_equal AR::Events::GameOverEvent, game_over.class
  end


end

