module AR::Game::Health 
  

  #...initialize them here
  def self.init ar_object 
    #add attr_serializeable properties here... 
    #
    ar_object.register_gauge "health"
    #if you do need them serialized on save
    #ar_object.attr_serializeable :prop1, :prop2, &block | ar_object, load_or_unload | 
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions << receive_damage_on_damage_received
    ar_object.resolutions << remove_subscriptions_on_death 
    #add to object's event subscriptions and resolutions here...
  end 

  def self.receive_damage_on_damage_received
    AR::Events::Resolution.new event_class: AR::Events::DamageReceived, as: "damaged" do |e|

      damaged = e.damaged
      damage_amount = e.damage_amount
      damaged.take_damage damage_amount 

      if damaged.dead?
        #return a new object died event
        AR::Events::ARObjectDied.new ar_object: damaged, cause: e
      end
    end
  end

  def self.remove_subscriptions_on_death
    AR::Events::Resolution.new event_class: AR::Events::ARObjectDied, as: "ar_object" do |e|
      ar_object = e.ar_object
      engine = ar_object.world.events_engine
      engine.remove_subscriptions_for ar_object
      ar_object.parent.remove_inhabitant ar_object unless ar_object.parent.nil?
      if ar_object == e.engine.world.player
        AR::Events::GameOverEvent.new
      else
        nil
      end
    end
  end


  def hit_points
    gauge("health").modified_value
  end

  def dead?
    self.hit_points <= 0
  end

  def take_damage amount
    gauge("health").change_current -amount
  end
end
