﻿# You can place the script of your game in this file.

# Declare images below this line, using the image statement.

##############Background and Cutscene images
image cutscene ending2 = "images/scene/ending2.jpg"
image cutscene wedding = "images/scene/wedding.jpg"
image cutscene ending6 = "images/scene/ending6.jpg"
image cutscene apocalypse = "images/scene/apocalypse.jpg"

image cutscene king sleep = "images/scene/k_sleep_small.jpg"
image cutscene king wake = "images/scene/k_wake_small.jpg"
image cutscene queen sleep = "images/scene/q_sleep_small.jpg"
image cutscene queen wake = "images/scene/q_wake_small.jpg"
image cutscene princess sleep = "images/scene/p_sleep_small.jpg"
image cutscene princess wake = "images/scene/p_wake_small.jpg"

#http://www.renpy.org/doc/html/displayables.html#im-matrixcolor
image grey king sleep = im.MatrixColor("images/scene/k_sleep_small.jpg", im.matrix.desaturate())
image grey king wake = im.MatrixColor("images/scene/k_wake_small.jpg", im.matrix.desaturate())
image grey queen wake = im.MatrixColor("images/scene/q_wake_small.jpg", im.matrix.desaturate())
image grey queen sleep = im.MatrixColor("images/scene/q_sleep_small.jpg", im.matrix.desaturate())
image grey princess sleep = im.MatrixColor("images/scene/p_sleep_small.jpg", im.matrix.desaturate())
image grey princess wake = im.MatrixColor("images/scene/p_wake_small.jpg", im.matrix.desaturate())

image bg highway = "images/bg/highway.jpg"
image bg forest = "images/bg/forest.jpg"
image bg town = "images/bg/town.jpg"
image bg hangman = "images/bg/hangman.jpg"
image bg hell = "images/bg/hell.jpg"
image bg cave = "images/bg/cave.jpg"

#Condition Switch
init:    
    image father = ConditionSwitch(
        "father_looking == 'thinking'", "images/character/father_thinking.png",
        "father_looking == 'left'", "images/character/father_thinking_left.png",
        "father_looking == 'right'", "images/character/father_thinking_right.png",
        "father_looking == 'up'", "images/character/father_thinking_up.png",
        )
    
    image pointing_skin = ConditionSwitch(
        "pointed_by == 'g'", "images/character/god_pointing.png",
        "pointed_by == 'v'", "images/character/devil_pointing.png",
        "pointed_by == 'd'", "images/character/death_pointing.png",
        )

##############Character Images
image physician = "images/character/pose2.png"
image physician thinking = "images/character/physican_thinking2.png"
image physician scared = "images/character/physican_scared2.png"
image physician sad = "images/character/physican_shake022.png"
image physician heart attack = "images/character/physican_heart_attack2.png"
image physician fierce = "images/character/physican_fierce2.png"
image physician hangman = "images/character/physican_hangman011.png"
image physician hangman2 = "images/character/physican_hangman022.png"
image shake1 = "images/character/physican_shake011.png"
image shake2 = "images/character/physican_shake022.png"

image god = "images/character/god.png"
image devil = "images/character/devil.png"
image death = "images/character/death.png"
image death holding flame = "images/character/death_holding_flame.png"
image death holding flame none = "images/character/death_holding_flame_none.png"

image god headshot = "images/character/god_hs.png"
image devil headshot = "images/character/devil_hs.png"
image death headshot = "images/character/death_hs.png"

image queen = "images/character/queen.png"
image king cry = "images/character/king_cry.png"

###############Other Assets Images
image herbs = "images/asset/herbs.png"
image potion heal = "images/asset/potion_heal.png"
image potion poison = "images/asset/potion_poison.png"

# Declare characters used by this game.
define n = Character('Narrator', color="#ffffff")
define p = Character('Physician', color="#c4693c")
define f = Character('Father', color="#727f94")
define d = Character('Death', color="#d3d9e2")
define g = Character('God', color="#f0f0f0")
define v = Character('Devil', color="#cc2525")
define ppl = Character('People', color="#D0D0D0")
define k = Character ('King', color="e7884e")
define q = Character('Queen', color="db8483")

#flip
init:
    image devil flip = im.Flip("images/character/devil.png", horizontal=True)

#Effects
init:
    $ flash = Fade(.25, 0, .75, color="#fff")
    $ redflash = Fade(.25, 0, .75, color="#f00")
    
#animation
image sad animated:
    "shake1"
    #"images/character/physican_shake011.png"
    pause 0.5
    "shake2"
    #"images/character/physican_shake022.png"
    pause 0.5
    repeat
    
#Custom position
init:
    $ center2 = Position(xpos=0.5, xanchor=0.5, ypos=0.05, yanchor=0.0)
    $ centerfather = Position(xpos=0.5, xanchor=0.5, ypos=0.35, yanchor=0.0)
    $ left2 = Position(xpos=0.18, xanchor=0.5, ypos=0.05, yanchor=0.0)
    $ leftscared = Position(xpos=0.22, xanchor=0.5, ypos=0.10, yanchor=0.0)
    $ leftfierce = Position(xpos = -0.20, xanchor=0.0, ypos=0.10, yanchor=0.0)
    $ right2 = Position(xpos=0.80, xanchor=0.5, ypos=0.05, yanchor=0.0)
    $ pointing = Position(xpos = 0.90, xanchor=0.5, ypos=0.03, yanchor=0.0)
    
# The game starts here.
label start:
    
    # Store variable
    $ warning = 0
    $ king_die = False
    $ queen_die = False
    $ princess_die = False
    
    scene black
    with fade
    
    n "A poor man had twelve children and had to work day and night in order just to feed them."
    n "thus when the thirteenth came into the world, not knowing what to do in his need."
    
    scene bg highway
    with fade
    
    show father at centerfather
    $ father_looking = "thinking"
    with dissolve
    n "He ran out into the highway" 
    n "intending to ask the first person whom he met to be the godfather."
    n "The first person who came his way was our dear God" 
    n "who already knew what was in his heart."
    hide father
    with dissolve

    
    show god at Position(xpos=0.15, xanchor=0.5, ypos=0.05, yanchor=0.0)
    with dissolve
    g "Poor man, I pity you. I am God. I will hold your child at his baptism, and care for him, and make him happy on earth."
    n "Then the devil came to him."
    
    show devil at Position(xpos=0.45, xanchor=0.5, ypos=0.0, yanchor=0.0) behind god
    with dissolve
    v "I am the Devil. If you will take me as your child's godfather, I will give him an abundance of gold and all the joys of the world as well."
    n "And then Death, on his withered legs, came walking toward him."
    show death at Position(xpos=0.95, xanchor=0.5, ypos=0.05, yanchor=0.0)
    with dissolve
    
    d "I am Death, who makes everyone equal. Take me as your child's godfather."
    
    hide god
    hide devil
    hide death
    with dissolve
    show father at centerfather
    $ father_looking = "thinking"
    with dissolve
    f "hmmm..."
    
    show god headshot at Position(xpos = 0.18, xanchor=0.5, ypos=0.5, yanchor=0.5):
        zoom 0.45
    with dissolve
    $ father_looking = "left"
    f "If I take God as the Godfather, He gives to the rich, and let the poor starve. I did not know how wisely God divides out wealth and poverty."
    show devil headshot at Position(xpos = 0.5, xanchor=0.5, ypos=0.03, yanchor=0.0):
        zoom 0.35
    with dissolve
    $ father_looking = "up"
    f "If I take Devil as the Godfather, The Devil deceive mankind and led them astray."
    show death headshot at Position(xpos = 0.81, xanchor=0.5, ypos=0.5, yanchor=0.5):
        zoom 0.35
    with dissolve
    $ father_looking = "right"
    f "Or if I take Death, Death take away the rich as well as the poor, without distinction"
    $ father_looking = "thinking"
    #http://renpyhandbook.tumblr.com/post/89454865700/imagemap-tutorial-part-2-the-main-menu
    screen example_imagemap:
        imagemap:
            ground "images/choice_ground.png"
            hover "images/choice_hover.png"

            hotspot (68, 193, 151, 210) clicked Return("god")
            hotspot (310, 10, 179, 212) clicked Return("devil")
            hotspot (565, 171, 164, 252) clicked Return("death")
            #anchor is top left, half the x or y and minus or add the screen size 
        
    label choose_path:
        
        call screen example_imagemap
        
        $ result = _return
        
        if result == "god":
            hide devil headshot
            hide death headshot
            n "You have chose God."
            hide god headshot
            hide father up
            jump god_path
        elif result == "devil":
            hide god headshot
            hide death headshot
            n "You have chose Devil."
            hide devil headshot
            hide father up
            jump devil_path
        elif result == "death":
            hide god headshot
            hide devil headshot
            n "You have chose Death."
            hide death headshot
            hide father up
            jump death_path

            
# GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE

label god_path:
    show god
    with fade
    g "I will make your child rich and famous, for he who has me for a friend cannot fail."
    n "God appeared as he had promised, and served as godfather in manner of aristocratic."
    scene black
    with fade
    n "After the boy came of age his godfather appeared to him one day and asked him to go with him. He took him out into the woods and showed him an herb that grew there."
    scene bg forest:
        zoom 1.0
        yalign 0.3
        linear 3.0 xalign 1.0
        pause 0.2
        linear 3.0 zoom 0.45
    with fade
    $ renpy.pause(5, hard=True)
    
    show physician at left2
    with dissolve
    show herbs at truecenter
    with dissolve
    $ renpy.pause(1.0)
    hide herbs
    with dissolve
    show god at right2
    with dissolve
    g "Now you shall receive your godfather's present. I will turn you a famous physician. "
    g "Whenever you are called to a sick person I will appear to you and judging you in every way. You shall only recover a wealthy person."
    g "But if you use choose to let them die, something very bad will happen to you and the people around you."
    scene bg town
    with fade
    n "It was not long before the young man had become the greatest and most famous physician in the whole world."
    ppl "He only needs to look at the sick in order to immediately know their condition, whether they will regain their health, or are doomed to die."
    ppl "It a shame that he only save the wealthy people."
    n "People came to him from far and wide, taking him to their sick, and giving him so much money that he soon became a wealthy man."
    scene cutscene king sleep
    with fade
    n "Now it came to pass that the king became ill. The physician was summoned and was told to say if a recovery were possible."
    n "Physician thought."
    show physician thinking at left2
    with moveinleft
    p "If I let the king die, then I let the privilege suffer along with the poverty."
    p "God will be angry, but because I am his godson he will shut one eye. Should I risk it?"
    
    menu:
        n "Should the Physician save the king" 
        
        "Deceive God and Let the king die":
            jump god_king_die
            
        "Let the king live":
            jump god_king_live
        
label god_king_die:
    $ king_die = True
    hide physician thinking
    show sad animated at left2
    n "He let the sick man alone, and shake his head has he cannot cure the king."
    n "The crowd is frown upon that the king is dead."
    hide sad animated
    scene grey king sleep
    show physician scared at leftscared
    with None
    show pointing_skin at pointing
    $ pointed_by = "g"
    with flash
    #n "God came to the physician, made a dark and angry face, threatened him with his finger."
    g "You have betrayed me. I will overlook it this time because you are my godson, but if you dare to do it again, it will cost you your neck, for I will take you yourself away with me."
    $ warning += 1
    scene cutscene princess sleep
    with fade
    n "Soon afterward the king's daughter became seriously ill."
    show queen at center2
    with dissolve
    n "The Queen proclaimed that whosoever rescued her from death should become her husband and inherit the crown."
    hide queen
    with dissolve
    show physician at left2
    with dissolve
    n "He should have remembered his godfather's warning."
    n "He did not see that God was looking at him angrily, lifting his hand into the air, and threatening him with his withered fist."
    n "Physician thought."
    show physician thinking at left2
    with dissolve
    p "I let the king die. If I let the princess die, I’m sure that the kingdom will fall, and the people will be independent."
    p "But if I let her live I might become the king."
    jump god_princess_decision
    
label god_king_live:
    show physician at left2
    with dissolve
    n "He gave the king some of the herb, and he recovered and became healthy again."
    scene cutscene king wake
    show physician at left2
    with dissolve
    show god at right2
    with moveinright
    g "You have done well my son"
    scene cutscene princess sleep
    with fade
    n "Soon afterward the king's daughter became seriously ill."
    show king cry at center2
    with dissolve
    n "She was his only child, and he cried day and night until his eyes were going blind."
    n "Then he proclaimed that whosoever rescued her from death should become her husband and inherit the crown."
    hide king cry
    with dissolve
    n "Physician thought."
    show physician thinking at left2
    with dissolve
    p "I have now save the king, but if I let the his daughter die, then I let the privilege suffer with the poverty."
    p "He will be angry, of course, but because I am his godson he will shut one eye. I will risk it."
    jump god_princess_decision
    
    
    
# GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE GOD CHOICE
# PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2
    
label god_princess_decision:
    
    if king_die == True:
        menu:
            n "Should the Physician save the princess?"
            
            "Deceive God again and Let the princess die":
                jump god_princess_die
                
            "Let the princess live":
                jump god_princess_live
    
    else:
        menu:
            n "Should the Physician save the princess?"
            "Deceive God and Let the princess die":
                jump god_princess_die
                
            "Let the princess live":
                jump god_princess_live
                
label god_queen_die:
    $ queen_die = True
    jump ending_7
        
label god_princess_die:
    
    if warning == 1:
        jump ending_7
    else:
        jump god_queen_decision
    
label god_princess_live:
    show physician at left2
    with dissolve
    n "He gave her some of the herb"
    scene cutscene princess wake
    show physician at left2
    with dissolve
    n "And her cheeks immediately turned red, and life stirred in her once again."
    if king_die == False: 
        n "King was so happy that his daughter was all better."
    n "God approach to him."
    show god at right2
    with dissolve
    g "I have seen you have done well in your life. You may choose continue as a Physician, or you can become a king."
    g "However I will no long be your godfather."
    show physician thinking at left2
    with dissolve
    menu:
        n "Physician thought for a moment what he wants in his life."
        "Physician should save more people":
            jump ending_6
            
        "Physician become a king":
            jump ending_5
        
        
label god_queen_decision:
    hide physician thinking
    show sad animated at left2
    n "He let the princess alone, and shake his head has he cannot cure her."
    n "The kingdom is frown and the physician is feeling guilty."
    hide sad animated
    scene grey princess sleep
    show physician scared at leftscared
    with None
    show pointing_skin at pointing
    $ pointed_by = "g"
    with flash
    #n "God came to the physician, made a dark and angry face, threatened him with his finger."
    g "You have betrayed me. I will overlook it this time because you are my godson, but if you dare to do it again, it will cost you your neck, for I will take you yourself away with me."
    $ warning += 1
    scene cutscene queen sleep
    with fade
    n "Soon afterward the queen became seriously ill."
    show physician at left2
    with moveinleft
    n "He should have remembered his godfather's warning."
    n "He did not see that God was looking at him angrily, lifting his hand into the air, and threatening him with his withered fist."
    n "Physician thought."
    show physician thinking at left2
    with dissolve
    p "I let the princess die, but if I let the queen die, then I let the privilege suffer with the poverty."
    p "He will be angry, of course, but because I am his godson he will shut one eye. I will risk it."
    menu:
        n "Should the Physician save the queen?"
        
        "Deceive God again and Let the Queen die":
            jump god_queen_die
            
        "Let the Queen live":
            jump god_queen_live
            
label god_queen_live:
    scene cutscene queen wake
    show physician at left2
    with dissolve
    n "He grab the herbs and made her well again"
    n "God approach to him"
    show god at right2
    with moveinright
    g "Come now, we must move on and save more people."
    jump ending_6
        
# DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE

label devil_path:
    show devil
    with fade
    v "I will make your child rich and famous, for he who has me for a friend cannot fail."
    n "Devil appeared as he broken his promised, and served as godfather in as bad influence."
    scene black
    with fade
    n "After the boy came of age his godfather appeared to him one day and asked him to go with him. He took him out into the woods and showed him an herb that grew there."
    scene bg forest:
        zoom 1.0
        yalign 0.3
        linear 3.0 xalign 1.0
        pause 0.2
        linear 3.0 zoom 0.45
    with fade
    $ renpy.pause(5, hard=True)
    
    show physician at left2
    with dissolve
    show potion heal at Position(xpos = 0.50, xanchor=0.5, ypos=0.5, yanchor=0.5)
    with dissolve
    n "He then make into potions which can be remedy..."
    hide potion heal
    show potion poison at Position(xpos = 0.50, xanchor=0.5, ypos=0.5, yanchor=0.5)
    with dissolve
    n "or poison."
    hide potion poison
    with dissolve
    show devil at right
    with dissolve
    v "Now you shall receive your godfather's present. I will turn you into an assassin under cover as a famous physician."
    v "I will make sure that you secret will not be blown and execute people one by one."
    v "But be aware if you disobey my order, something very bad will happen to you."
    scene bg town
    with fade
    n "It was not long before the young man had become the assassin, under cover as the most famous physician in the whole world."
    ppl "He only needs to look at the sick in order to immediately know their condition, whether they will regain their health, or are doomed to die."
    n "People came to him from far and wide, taking him to their sick, and giving him so much money that he soon became a wealthy man."
    n "Devil make sure that not all the people are killed so that the crowd would not get suspicious."
    scene cutscene king sleep
    with fade
    show physician at left2
    with moveinleft
    n "Now it came to pass that the king became ill. The physician was summoned and was told to say if a recovery were possible."
    show devil at right
    with moveinright
    n "However, when he approached the bed, Devil was standing next to the king and making a gesture of throat cutting."
    n "Physician thought."
    show physician thinking at left2
    with dissolve
    p "I do not feel this is a right thing to do."
    p "If I could only deceive death for once..."
    p "He will be angry, of course, but because I am his godson he will shut one eye. I might risk it"
    menu:
        n "Should the Physician save the king?" 
        
        "Let the king die":
            jump devil_king_die
            
        "Deceive Devil and let the king live":
            jump devil_king_live
            
label devil_king_die:
    $ king_die = True
    show physician at left2
    n "He slowly pour the poison into king’s mouth and watch him as his respiration is slowing down and lay peacefully."
    n "Knowing that the poison does not have a big reaction."
    v "You have done well my son."
    show devil at right
    with dissolve
    hide devil
    with dissolve
    n "The crowd became aware that the Physician dispatch people more than he save them. And suspect that he may not be a Physician after all."
    n "They watch him closely."
    scene black
    with fade
    n "Soon afterward the king's daughter became seriously ill."
    scene cutscene princess sleep
    with fade
    show physician at left2
    with moveinleft
    show devil at right
    with moveinright
    n "When the physician came to the sick girl's bed he saw Devil at her feet."
    n "Physician thought."
    show physician thinking at left2
    with dissolve
    p "The crowd is on to me."
    p "If I could only deceive death for once again..."
    p "He will be angry, of course, but because I am his godson he will shut one eye. I might risk it"
    jump devil_princess_decision
    
label devil_king_live:
    show physician at left2
    with dissolve
    n "He took hold of the sick man and switch from poison to remedy potion."
    scene cutscene king wake
    show physician at left2
    with dissolve
    n "The king became healthy again."
    scene grey king wake
    show physician scared at leftscared
    show pointing_skin at pointing
    $ pointed_by = "v"
    with redflash
    #n "However, Devil came to the physician, made a dark and angry face, threatened him with his finger."
    v "You have betrayed me. I will overlook it this time because you are my godson, but if you dare to do it again, it will cost you your neck, for I will take you yourself away with me."
    $ warning += 1
    scene black
    with fade
    n "Soon afterward the king's daughter became seriously ill."
    scene cutscene princess sleep
    with fade
    show king cry at center2
    with dissolve
    n "She was his only child, and he cried day and night until his eyes were going blind."
    k "If anything happen to my daughter, there will be consequences."
    hide king cry
    with dissolve
    show physician at left2
    with moveinleft
    show devil at right
    with moveinright
    n "When the physician came to the sick girl's bed he saw Devil standing next to her."
    show physician thinking at left2
    with dissolve
    n "He should have remembered his godfather's warning."
    n "He did not see that Devil was looking at him angrily, lifting his hand into the air, and threatening him with his withered fist."
    n "Nor does the king."
    jump devil_princess_decision
    
    
# DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE DEVIL CHOICE
# PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2 PART 2

label devil_princess_decision:
    if king_die == True and warning == 0:
        menu:
            n "Should the Physician save the princess?" 
            "Let the princess die":
                jump devil_princess_die
            
            "Deceive Death and let the princess live":
                jump devil_princess_live
    elif warning == 1:
        menu:
            n "Should the Physician save the princess?" 
            "Let the princess die":
                jump devil_princess_die
            
            "Deceive Death again and let the princess live":
                jump devil_princess_live
                

            
label devil_princess_die:
        jump ending_4
    
label devil_princess_live:
    if warning == 1:
        jump ending_3
    else:
        scene cutscene princess wake
        show physician at left2
        with dissolve
        n "He deceive Devil. He switch the potion to remedy and cure the princess."
        scene grey princess wake
        show physician scared at left2
        show pointing_skin at pointing
        $ pointed_by = "v"
        with redflash
        v "You have betrayed me. I will overlook it this time because you are my godson, but if you dare to do it again, it will cost you your neck, for I will take you yourself away with me."
        $ warning += 1
        scene black
        with fade
        n "That day, the Devil made the princess ill again."
        scene cutscene princess sleep
        with fade
        show physician at left2
        with moveinleft
        n "He should have remembered his godfather's warning."
        n "He did not see that Devil was looking at him angrily."
        jump devil_princess_decision
        
        
        
# DEATH CHOICE DEATH CHOICE DEATH CHOICE DEATH CHOICE DEATH CHOICE DEATH CHOICE DEATH CHOICE

label death_path:
    show death
    with fade
    d "I will make your child rich and famous, for he who has me for a friend cannot fail."
    n "Death appeared as he had promised, and served as godfather in an orderly manner."
    scene black
    with fade
    n "After the boy came of age his godfather appeared to him one day and asked him to go with him. He took him out into the woods and showed him an herb that grew there."
    scene bg forest:
        zoom 1.0
        yalign 0.3
        linear 3.0 xalign 1.0
        pause 0.2
        linear 3.0 zoom 0.45
    with fade
    $ renpy.pause(5, hard=True)
    show physician at left2
    with dissolve
    show herbs at truecenter:
    with dissolve
    $ renpy.pause(1.0)
    hide herbs
    with dissolve
    show death at right2
    d "Whenever you are called to a sick person I will appear to you."
    d "If I stand at the sick person's head, you may say with confidence that you can make him well again; then give him some of this herb, and he will recover."
    d "But if I stand at the sick person's feet..."
    d "He is mine, and you must say that he is beyond help, and that no physician in the world could save him."
    d "But beware of using this herb against my will, or something very bad will happen to you."
    scene bg town
    with fade
    n "It was not long before the young man had become the most famous physician in the whole world. Thanks to his godfather."
    ppl "He only needs to look at the sick in order to immediately know their condition, whether they will regain their health, or are doomed to die."
    n "People came to him from far and wide, taking him to their sick, and giving him so much money that he soon became a wealthy man."
    scene cutscene king sleep
    with fade
    n "Now it came to pass that the king became ill. The physician was summoned and was told to say if a recovery were possible."
    n "However, when he approached the bed, Death was standing at the sick man's feet, and so no herb on earth would be able to help him."
    n "Physician thought."
    show physician thinking at left2
    with moveinleft
    p "If I could only deceive death for once..."
    p "He will be angry, of course, but because I am his godson he will shut one eye. I will risk it."
    menu:
        "Should the Physician save the king?" 
        
        "Let the king die":
            jump death_king_die
            
        "Deceive Death and let the king live":
            jump death_king_live

label death_king_die:
    hide physician thinking
    $ king_die = True
    show sad animated at left2
    n "He let the sick man alone, and shake his head has he cannot cure the king."
    n "The kingdom is frown and the physician is feeling guilty."
    hide sad animated
    scene cutscene queen sleep
    with fade
    show physician sad at left2
    with dissolve
    n "Soon after the king has died the queen becomes ill. The Death was standing at the sick woman's feet, and so no herb on earth would be able to help him."
    n "The physician doesn’t want another human being to die"
    scene cutscene queen wake
    show physician at left2
    with fade
    n "So he cheated on death. He gave the queen some of the herb, and he recovered and became healthy again."
    jump death_angry
    
label death_king_live:
    scene cutscene king wake
    show physician at left2
    with dissolve
    n "He therefore took hold of the sick man and laid him the other way around, so that Death was now standing at his head."
    n "Then he gave the king some of the herb, and he recovered and became healthy again."
    jump death_angry

label death_angry:
    n "However..."
    n "Death came to the physician, made a dark and angry face, threatened him with his finger."
    if king_die == True:
        scene grey queen wake
    elif king_die == False:
        scene grey king wake
    show physician scared at leftscared
    show pointing_skin at pointing
    $ pointed_by = "d"
    with fade
    d "You have betrayed me. I will overlook it this time because you are my godson, but if you dare to do it again, it will cost you your neck, for I will take you yourself away with me."
    $ warning += 1
    scene cutscene princess sleep
    with fade
    if king_die == True:
        n "Soon afterward the queen's daughter became seriously ill."
    elif king_die == False:
        show king cry at center2
        with dissolve
        n "Soon afterward the king's daughter became seriously ill."
        n "She was his only child, and he cried day and night until his eyes were going blind."
        n "Then he proclaimed that whosoever rescued her from death should become her husband and inherit the crown."
        hide king cry
        with dissolve
    show physician at left2
    with moveinleft
    n "When the physician came to the sick girl's bed he saw Death at her feet."
    n "He should have remembered his godfather's warning, but he was so infatuated by the princess's great beauty and the prospect of becoming her husband that he threw all thought to the winds."
    n "He did not see that Death was looking at him angrily, lifting his hand into the air, and threatening him with his withered fist."
    menu:
        n "Should the Physician save the princess?" 
        
        "Let the princess die":
            jump death_princess_die
            
        "Deceive Death again and let the princess live":
            jump death_princess_live
            
label death_princess_die:
    jump ending_2
            
label death_princess_live:
    show physician at left2
    with dissolve
    n "He lifted up the sick girl and placed her head where her feet had been."
    scene cutscene princess wake
    show physician at left2
    with dissolve
    n "Then he gave her some of the herb, and her cheeks immediately turned red, and life stirred in her once again."
    n "Death, seeing that he had been cheated out of his property for a second time, approached the physician with long strides."
    scene grey princess wake
    show physician scared at leftscared
    show pointing_skin at pointing
    $ pointed_by = "d"
    with fade
    d "You are finished. Now it is your turn."
    n "Death seized him so firmly with his ice-cold hand that he could not resist, and led him into an underground cavern."
    scene bg cave at Zoom((800, 600), (200, 150, 800, 600), (0, 0, 2037, 1440), 3.0)
    with fade
    n "There the physician saw how thousands and thousands of candles were burning in endless rows, some large, others medium-sized, others small."
    n "Every instant some died out, and others were relit, so that the little flames seemed to be jumping about in constant change."
    show death at right2
    with dissolve
    show physician at left2
    with dissolve
    d "See."
    d "These are the life-lights of mankind. The large ones belong to children, the medium-sized ones to married people in their best years, and the little ones to old people."
    d "However, even children and young people often have only a tiny candle."
    p "Show me my life-light."
    n "The physician thought that his still would be very large."
    n "Death pointed to a little stump that was just threatening to go out."
    show death holding flame at Position(xpos=0.655, xanchor=0.5, ypos=0.05, yanchor=0.0)
    with dissolve
    d "See, there it is."
    #show physician worried
    p "Oh, dear godfather."
    p "Light a new one for me. Do it as a favour to me, so that I can enjoy my life, and become king and the husband of the beautiful princess."
    d "I cannot..."
    d "One must go out before a new one is lighted."
    
    menu:
        "What should physian do?"
        
        "Accept death":
            $ phy_choice = "accept death"
            jump ending_1
            
        "Beg":
            $ phy_choice = "beg"
            jump ending_1
    
label ending_1:
    if phy_choice == "accept death":
            show physician sad
            with dissolve
            p "I will take the responsibility"
            n "Death is going to fulfil his wish and extinguish his flame, and the little piece fell down and went out."
            show death holding flame none
            hide physician sad
            with dissolve
    elif phy_choice == "beg":
            p "Then set the old one onto a new one that will go on burning after the old one is finished."
            n "Death pretended that he was going to fulfil this wish and took hold of a large new candle"
            n "But he desire to get his revenge, he purposely made a mistake in relighting it, and the little piece fell down and went out."
            show physician heart attack
            show death holding flame none
            with hpunch
            with Pause(0.9)
            hide physician heart attack
            with moveoutbottom
    with Pause(2)
    scene black
    with fade
    n "The physician immediately fell to the ground, and he too was now in the hands of Death."
    "The End"
    if phy_choice == "beg":
        "True Ending"
    return
    
label ending_2:
    show physician sad at left2
    with dissolve
    n "The Physician does not want to make the same mistake again. So he has no choice but let the princess died."
    hide physician sad
    with dissolve
    if king_die == True:
        show queen at center2
        with dissolve
        n "The queen and the crowd stay silent for a moment."
        q "We respect you, you have done in every power you can."
    elif king_die == False:
        show king cry at center2
        with dissolve
        n "The king is felt full of sorrow when the princess cannot be cured."
    scene cutscene ending2:
    with fade
    n "Physician and the Death walks along the highway. Death whisper to him."
    d "As new one is lighted, one must go out."
    scene black
    with fade
    n "Physician understand that he cannot save everybody"
    n "but cannot get over the trauma as he will witness more death throughout his life."
    "The End"
    return
    
label ending_3:
    scene cutscene princess wake
    show physician at left2
    with dissolve
    n "He deceive Devil again. He switch the potion to remedy and cure the princess."
    show physician scared at leftscared
    show pointing_skin at pointing
    $ pointed_by = "v"
    with redflash
    v "You have betrayed me once again."
    n "Devil send him to hell."
    scene bg hell
    with fade
    n "Physician see thousands of people been tortured."
    show devil at right
    with moveinright
    v "Now you’ll join with them."
    show physician fierce at leftfierce
    with moveinleft
    p "I had enough from you."
    p "You may torture me for eternity, but I do not want to live as a murderer."
    n "Devil had no hesitant to push him off the edge of the cliff."
    hide physician fierce
    with easeoutleft
    #with Pause(0.5)
    scene black
    with fade
    n "Physician may be miserable, but he does not feel any guilt of what he has done recently."
    "The End"
    return

label ending_4:
    show physician at left2
    n "The Physician does not want to disappoint the Devil. So he let the princess died in vain."
    hide devil
    show physician scared at leftscared
    with dissolve
    ppl "He’s been killing off people all along. Get him!"
    scene black
    with dissolve
    n "The crowd eventually caught physician and put him a sentence to death."
    scene bg hangman
    with fade
    n "As the physician have his neck tie around the rope, the queen spoke."
    show queen
    with dissolve
    q "Any last words?"
    show physician hangman at right
    with moveinright
    p "Save me godfather!"
    n "The crowd though he has gone mad"
    n "Physician did not know that he was only one who can see the Devil."
    hide queen
    show devil flip at left
    with dissolve
    n "The devil smirk as he said to the Physician."
    v "You have brought this upon yourself."
    v "Your father shouldn’t made a pact with me."
    show physician hangman2 at right
    with dissolve
    n "Physician looks down and contemplate his life as his life have been betray by the Devil and the people."
    n "The executioner pull the switch and drop him."
    scene black
    n "And the crowd went silent."
    "The End"
    "Bad Ending"
    return

label ending_5:
    p "Farewell God, My father made a right choice."
    scene cutscene wedding:
        xalign 0.6
        linear 4.0 xalign 0.6 zoom 0.45
    #scene cutscene wedding at truecenter Zoom((800, 600), (450, 300, 800, 600), (0, 0, 2037, 1440), 3.0)
    with fade
    n "Physician and the princess got married and live happily ever after."
    scene black
    with fade
    "The End"
    "Good Ending"
    return

label ending_6:
    scene cutscene ending6
    with fade
    n "After curing many people, Physician and God left the kingdom and continue saving more wealthy people."
    scene black
    with fade
    "The End"
    "Good Ending"
    return

label ending_7:
    hide physician thinking
    show sad animated at left2
    if queen_die == True:
        n "He let the queen alone, and shake his head has he cannot cure her."
        scene grey queen sleep
    else:
        n "He let the princess alone, and shake his head has he cannot cure her."
        scene grey princess sleep
    hide sad animated
    show physician scared at leftscared
    with None
    show pointing_skin at pointing
    $ pointed_by = "g"
    with flash
    g "That is it!"
    g "Now I will bring rapture and your and the minorities will perish on earth."
    #scene cutscene apocalypse at center
    show cutscene apocalypse:
        xalign 0.0 yalign 0.0
        pause 0.1
        xalign 0.11 yalign 0.09
        pause 0.1
        xalign 0.04 yalign 0.12
        pause 0.1
        xalign 0.14 yalign 0.03
        pause 0.1
        xalign 0.04 yalign 0.08
        repeat 10
    with fade
    n "God has summon an earthquake and trample down the earth."
    scene black
    with fade
    "The End"
    "Bad Ending"
    return
