UNIT IA;

{ Unidad que controla la IA de AOL }

INTERFACE
USES ES, COMANDOS, GRAMATIC;

{*} FUNCTION Orden_Jugador(comandos :Comandos_Jugador; obje, sali :Objetos;
                           numero, turno :WORD; VAR movido :BOOLEAN) :Cadena;

IMPLEMENTATION

FUNCTION Orden_Jugador(comandos :Comandos_Jugador; obje, sali :Objetos;
                       numero, turno :WORD; VAR movido :BOOLEAN) :Cadena;
VAR
   pasado :BOOLEAN;
   aleatorio_area, aleatorio :WORD;
   area :Comandos_Jugador;
   lista :P_Lista;
   comando, salida, objeto :Cadena;
   apuntado :Cadena;
   caracter :CHAR;
BEGIN
     RANDOMIZE;
     pasado := FALSE;
     movido := FALSE;

     aleatorio_area := RANDOM(numero) + 1;
     WHILE (NOT(pasado)) DO BEGIN
           REPEAT
                 area := Situar_Area(comandos, aleatorio_area);
                 aleatorio := RANDOM(area^.numl) + 1;
                 lista := Situar_Comando(area^.lista, aleatorio);
                 aleatorio := RANDOM(lista^.entre) + 1;
                 aleatorio_area := lista^.sig_area;
           UNTIL ((aleatorio = lista^.posibilidades) AND (lista^.turno <= turno));
           pasado := TRUE;
           Copiar(comando, lista^.comando);
           IF ((Encontrado(comando, '/')) AND
              (Numero_Objetos(sali) = 0)) THEN BEGIN
                 pasado := FALSE;
                 aleatorio_area := lista^.sig_area;
           END;
           IF ((Encontrado(comando, '*')) AND
              (Numero_Objetos(obje) = 0)) THEN BEGIN
                 pasado := FALSE;
                 aleatorio_area := lista^.sig_area;
           END;
     END;

  { Para que el jugador se mueva }

     IF (Iguales_catx(comando, '/')) THEN BEGIN
        IF (Numero_Objetos(sali) > 0) THEN BEGIN
           movido := TRUE;
           aleatorio := RANDOM(Numero_Objetos(sali)) + 1;
           salida := Situar_Objeto(sali, aleatorio)^.nombre;
           IF (NOT(Es_Salida(salida))) THEN BEGIN
              comando := Asignar('go to ');
              Insertar_Final(comando, salida);
           END
           ELSE
               Copiar(comando, salida);
        END
     END

  { El intrprete mover al jugador siempre que el primer carcter y nico
    carcter sea / }

     ELSE BEGIN
          apuntado := Buscar_Caracter(comando, '*');
          IF (apuntado = NIL) THEN
             apuntado := Buscar_Caracter(comando, '/');
          WHILE (apuntado <> NIL) DO BEGIN
                caracter := apuntado^.car;
                objeto := NIL;
                IF (caracter = '*') THEN BEGIN
                   IF ((Numero_Objetos(obje)) > 0) THEN BEGIN
                      aleatorio := RANDOM(Numero_Objetos(obje)) + 1;
                      objeto := Situar_Objeto(obje, aleatorio)^.nombre;
                   END;
                END;
                IF (caracter = '/') THEN BEGIN
                   IF ((Numero_Objetos(sali)) > 0) THEN BEGIN
                      aleatorio := RANDOM(Numero_Objetos(sali)) + 1;
                      objeto := Situar_Objeto(sali, aleatorio)^.nombre;
                   END;
                END;
                IF (objeto <> NIL) THEN BEGIN
                   Insertar(apuntado, objeto);
                END;
                Borrar_Caracter(comando, caracter);
                apuntado := Buscar_Caracter(comando, '*');
                IF (apuntado = NIL) THEN
                   apuntado := Buscar_Caracter(comando, '/');
          END;
     END;

     Orden_Jugador := comando;
END; { Orden_Jugador }

END. { IA }
