UNIT ES;

{ Unidad para el funcionamiento de la E/S de AOL }

INTERFACE

TYPE
    Cadena = ^Reg_Cadena;
    Reg_Cadena = RECORD
                       car :CHAR;
                       sig :Cadena;
                 END;

    Doskey = ^Reg_Doskey;
    Reg_Doskey = RECORD
                       almacenado :Cadena;
                       sig :Doskey;
                       ant :Doskey;
                 END;

{*} FUNCTION Asignar(cadi :STRING) :Cadena;
{*} FUNCTION Iguales(cad1, cad2 :Cadena) :BOOLEAN;
{*} FUNCTION Iguales_catx(cad1 :Cadena; cad2 :STRING) :BOOLEAN;
{*} FUNCTION Longitud(cadi :Cadena) :WORD;
{*} PROCEDURE Copiar(VAR nuevo :Cadena; cadi :Cadena);
{*} PROCEDURE Insertar_Final(VAR cad1 :Cadena; cad2 :Cadena);
{*} PROCEDURE Insertar(VAR cad1 :Cadena; cad2 :Cadena);
{*} PROCEDURE Borrar_Caracter(VAR cadi :Cadena; car :CHAR);
{*} PROCEDURE Borrar_Ultimo(VAR cadi: Cadena);
{*} PROCEDURE Borrar_Cadena(VAR cadi :Cadena);
{*} FUNCTION Buscar_Caracter(cadi :Cadena; car :CHAR) :Cadena;
{*} FUNCTION Encontrado(cadi :Cadena; car :CHAR) :BOOLEAN;
{*} FUNCTION Dirigir_Ptr(cadi :Cadena; nume :WORD) :Cadena;
{*} PROCEDURE Inicializar_Cadena(VAR cadi :Cadena);
{*} PROCEDURE Meter_Doskey(VAR memo, ult :Doskey; cadi :Cadena);
{*} PROCEDURE Inicializar_Doskey(VAR memo :Doskey);
{*} FUNCTION Leer_Palabra(VAR cadi :Cadena) :Cadena;
{*} PROCEDURE Leer_Cadena(VAR cadi :Cadena; VAR memo, ult :Doskey);
{*} PROCEDURE Escribir_Cadena(cadi :Cadena);
{*} PROCEDURE A_Fichero(VAR fich :TEXT; cadi :Cadena);

IMPLEMENTATION
USES crt, GRAMATIC;

FUNCTION NumString(cadi :STRING) :BYTE;
BEGIN
     NumString := ORD(cadi[0]);
END; { NumString }

FUNCTION Asignar(cadi :STRING) :Cadena;
VAR
   valor, auxi :Cadena;
   cont :BYTE;
BEGIN
     Inicializar_Cadena(valor);
     cont := 1;
     IF (cont <= NumString(cadi)) THEN BEGIN
        NEW(valor);
        valor^.car := cadi[cont];
        auxi := valor;
        cont := cont + 1;
        WHILE (cont <= NumString(cadi)) DO BEGIN
              NEW(auxi^.sig);
              auxi := auxi^.sig;
              auxi^.car := cadi[cont];
              cont := cont + 1;
        END;
        auxi^.sig := NIL;
     END
     ELSE
         valor := NIL;
     Asignar := valor;
END; { Asignar }

FUNCTION Iguales(cad1, cad2 :Cadena) :BOOLEAN;
VAR
   aux1, aux2 :Cadena;
BEGIN
     aux1 := cad1;
     aux2 := cad2;
     WHILE (aux1 <> NIL) AND (aux2 <> NIL) AND
           (UPCASE(aux1^.car) = UPCASE(aux2^.car)) DO BEGIN
               aux1 := aux1^.sig;
               aux2 := aux2^.sig;
     END;
     Iguales := ((aux1 = NIL) AND (aux2 = NIL));
END; { Iguales }

FUNCTION Iguales_catx(cad1 :Cadena; cad2 :STRING) :BOOLEAN;
VAR
   aux1 :Cadena;
   cont :WORD;
BEGIN
     aux1 := cad1;
     cont := 1;
     WHILE (aux1 <> NIL) AND (cont <= ORD(cad2[0])) AND
           (UPCASE(aux1^.car) = UPCASE(cad2[cont])) DO BEGIN
               aux1 := aux1^.sig;
               cont := cont + 1;
     END;
     Iguales_catx := ((aux1 = NIL) AND (cont > ORD(cad2[0])));
END; { Iguales_catx }

FUNCTION Longitud(cadi :Cadena) :WORD;
VAR
   auxi :Cadena;
   cont :WORD;
BEGIN
     cont := 1;
     IF (cadi <> NIL) THEN BEGIN
        auxi := cadi;
        WHILE (auxi^.sig <> NIL) DO BEGIN
              cont := cont + 1;
              auxi := auxi^.sig;
        END;
     END
     ELSE
         cont := 0;
     Longitud := cont;
END; { Longitud }

PROCEDURE Copiar(VAR nuevo :Cadena; cadi :Cadena);
VAR
   aux, aux2 :Cadena;
BEGIN
     IF (cadi <> NIL) THEN BEGIN
        NEW(nuevo);
        nuevo^.car := cadi^.car;
        aux := cadi^.sig;
        aux2 := nuevo;
        WHILE (aux <> NIL) DO BEGIN
              NEW(aux2^.sig);
              aux2 := aux2^.sig;
              aux2^.car := aux^.car;
              aux := aux^.sig;
        END;
        aux2^.sig := NIL;
     END
     ELSE
         nuevo := NIL;
END; { Copiar }

PROCEDURE Insertar_Final(VAR cad1 :Cadena; cad2 :Cadena);
VAR
   aux1, aux2 :Cadena;
BEGIN
     IF (cad1 <> NIL) THEN BEGIN
        aux1 := cad1;
        WHILE (aux1^.sig <> NIL) DO
              aux1 := aux1^.sig;
        aux2 := cad2;
        WHILE (aux2 <> NIL) DO BEGIN
              NEW(aux1^.sig);
              aux1 := aux1^.sig;
              aux1^.car := aux2^.car;
              aux2 := aux2^.sig;
        END;
        aux1^.sig := NIL;
     END;
END; { Insertar_Final }

PROCEDURE Insertar(VAR cad1 :Cadena; cad2 :Cadena);
VAR
   aux1, auxiliar_1 :Cadena;
   aux2 :Cadena;
BEGIN
     IF (cad2 <> NIL) THEN
        NEW(aux1);
        aux1^.car := cad2^.car;
        auxiliar_1 := aux1;
        aux2 := cad2^.sig;
        WHILE (aux2 <> NIL) DO BEGIN
              NEW(auxiliar_1^.sig);
              auxiliar_1 := auxiliar_1^.sig;
              auxiliar_1^.car := aux2^.car;
              aux2 := aux2^.sig;
        END;
        auxiliar_1^.sig := cad1^.sig;
        cad1^.sig := aux1;
END; { Insertar }

PROCEDURE Retroceder(VAR cadi: Cadena; nume :WORD);
VAR
   auxi :Cadena;
   cont :WORD;
BEGIN
     auxi := cadi;
     FOR cont := 1 TO (nume - 1) DO
         auxi := auxi^.sig;
     DISPOSE(auxi);
END; { Borrar_Ptr }

PROCEDURE Borrar_Caracter(VAR cadi :Cadena; car :CHAR);
VAR
   ante :Cadena;
   auxi :Cadena;
BEGIN
     IF (cadi <> NIL) THEN BEGIN
        IF (UPCASE(cadi^.car) = car) THEN BEGIN
           auxi := cadi;
           cadi := cadi^.sig;
           DISPOSE(auxi);
        END
        ELSE BEGIN
            ante := cadi;
            auxi := cadi^.sig;
            WHILE ((auxi <> NIL) AND
                  (UPCASE(auxi^.car) <> UPCASE(car))) DO BEGIN
                      ante := auxi;
                      auxi := auxi^.sig;
            END;
            IF (auxi <> NIL) THEN BEGIN
               ante^.sig := auxi^.sig;
               DISPOSE(auxi);
            END;
        END;
     END;
END; { Borrar_Caracter }

PROCEDURE Borrar_Ultimo(VAR cadi: Cadena);
VAR
   auxi, ante :Cadena;
BEGIN
     IF (cadi^.sig = NIL) THEN BEGIN
        auxi := cadi;
        cadi := cadi^.sig;
        DISPOSE(auxi);
     END
     ELSE BEGIN
         ante := cadi;
         auxi := cadi^.sig;
         WHILE (auxi^.sig <> NIL) DO BEGIN
               ante := auxi;
               auxi := auxi^.sig;
         END;
         DISPOSE(auxi);
         ante^.sig := NIL;
     END;
END; { Borrar_Ultimo }

PROCEDURE Borrar_Cadena(VAR cadi :Cadena);
VAR
   auxi :Cadena;
BEGIN
     IF (cadi <> NIL) THEN BEGIN
        WHILE (cadi <> NIL) DO BEGIN
              auxi := cadi;
              cadi := cadi^.sig;
              DISPOSE(auxi);
        END;
     END;
END; { Borrar_Cadena }

FUNCTION Buscar_Caracter(cadi :Cadena; car :CHAR) :Cadena;
VAR
   auxi :Cadena;
BEGIN
     auxi := cadi;
     WHILE ((auxi <> NIL) AND (UPCASE(auxi^.car) <> UPCASE(car))) DO
           auxi := auxi^.sig;
     Buscar_Caracter := auxi;
END; { Buscar_Caracter }

FUNCTION Encontrado(cadi :Cadena; car :CHAR) :BOOLEAN;
BEGIN
     Encontrado := (Buscar_Caracter(cadi, car) <> NIL);
END; { Encontrado }

FUNCTION Dirigir_Ptr(cadi :Cadena; nume :WORD) :Cadena;
VAR
   auxi :Cadena;
   cont :WORD;
BEGIN
     auxi := cadi;
     FOR cont := 1 TO (nume - 1) DO
         auxi := auxi^.sig;
     Dirigir_Ptr := auxi;
END; { Dirigir_Ptr }

PROCEDURE Inicializar_Cadena(VAR cadi :Cadena);
BEGIN
     cadi := NIL;
END; { Inicializar_Cadena }

PROCEDURE Inicializar_Doskey(VAR memo :Doskey);
BEGIN
     memo := NIL;
END; { Inicializar_Doskey }

PROCEDURE Meter_Doskey(VAR memo, ult :Doskey; cadi :Cadena);
VAR
   nuevo :Doskey;
   auxi :Doskey;
BEGIN
     IF (Longitud(cadi) > 0) THEN BEGIN
        NEW(nuevo);
        Copiar(nuevo^.almacenado, cadi);
        IF (memo = NIL) THEN BEGIN
           nuevo^.sig := NIL;
           nuevo^.ant := NIL;
           memo := nuevo;
           ult := memo;
        END
        ELSE BEGIN
             memo^.ant := nuevo;
             nuevo^.ant := ult;
             nuevo^.sig := memo;
             memo := nuevo;
             ult^.sig := memo;
        END;
     END;
END; { Meter_Doskey }

FUNCTION Leer_Palabra(VAR cadi :Cadena) :Cadena;
TYPE
    Tipo_Separadores = SET OF CHAR;
VAR
   cadn :Cadena;
   auxi :Cadena;
BEGIN
     WHILE ((cadi <> NIL) AND (Es_Separador(cadi^.car))) DO
           cadi := cadi^.sig;
     IF (cadi <> NIL) THEN BEGIN
        NEW(cadn);
        cadn^.car := cadi^.car;
        auxi := cadn;
        cadi := cadi^.sig;
        WHILE ((cadi <> NIL) AND (NOT(Es_Separador(cadi^.car)))) DO BEGIN
              NEW(auxi^.sig);
              auxi := auxi^.sig;
              auxi^.car := cadi^.car;
              cadi := cadi^.sig;
        END;
        auxi^.sig := NIL;
     END
     ELSE
         cadn := NIL;
     Leer_Palabra := cadn;
END; { Leer_Palabra }

PROCEDURE Leer_Cadena(VAR cadi :Cadena; VAR memo, ult :Doskey);

{ SubAlgoritmos }

 PROCEDURE Borrar_Caracter(x, y :WORD);
 BEGIN
      IF (x = 1) THEN BEGIN
         x := 68;
         y := y - 1;
      END
      ELSE
          x := x - 1;
      GotoXY(x, y); Write(' ');
      GotoXY(x, y);
 END; { Borrar_Caracter }

 PROCEDURE Borrar_Actual(x :WORD; VAR y :WORD; hasta_y :WORD);
 VAR
    conty, contx, contc :WORD;
 BEGIN
      contx := x;
      conty := y;
      contc := 0;
      WHILE (contc < hasta_y) DO BEGIN
          GotoXY(contx, conty);
          ClrEol;
          contc := contc + 68;
          conty := conty + 1;
          IF (conty >= 19) THEN
             y := y - 1;
          contx := 1;
      END;
 END; { Borrar_Actual }

{ Algoritmo principal }

VAR
   car :CHAR;
   cont, x, y :WORD;
   auxi :Cadena;
   auxi_doskey :Doskey;
BEGIN
     cont := 0;
     x := WhereX;
     y := WhereY;
     auxi_doskey := memo;
     Borrar_Cadena(cadi);
     car := ReadKey;
     IF (car <> CHR(13)) THEN BEGIN
        IF (car <> CHR(0)) THEN BEGIN
           NEW(cadi);
           cadi^.car := car;
           cadi^.sig := NIL;
           auxi := cadi;
           Write(car);
           cont := 1;
           car := ReadKey;
        END;
        WHILE (car <> CHR(13)) DO BEGIN
              IF ((car <> CHR(8)) AND (car <> CHR(0))) THEN BEGIN
                 NEW(auxi^.sig);
                 auxi := auxi^.sig;
                 auxi^.car := car;
                 Write(car);
                 cont := cont + 1;
              END;
              IF (car = CHR(8)) THEN BEGIN
                 IF (cont > 1) THEN BEGIN
                    Retroceder(cadi, cont);
                    cont := cont - 1;
                    auxi := Dirigir_Ptr(cadi, cont);
                    Borrar_Caracter(WhereX, WhereY);
                 END;
              END;
              IF (car = CHR(0)) THEN BEGIN
                 car := ReadKey;
                 IF (car = CHR(72)) THEN BEGIN
                    IF (auxi_doskey <> NIL) THEN BEGIN
                       Borrar_Actual(x, y, cont);
                       GotoXY(x, y);
                       Escribir_Cadena(auxi_doskey^.almacenado);
                       auxi := NIL;
                       Copiar(cadi, auxi_doskey^.almacenado);
                       cont := Longitud(cadi);
                       auxi := Dirigir_Ptr(cadi, cont);
                       IF (car = CHR(72)) THEN
                          auxi_doskey := auxi_doskey^.sig;
                    END;
                 END;
              END;
             car := ReadKey;
        END;
        auxi^.sig := NIL;
     END;
     Meter_Doskey(memo, ult, cadi);
END;  { Leer_Cadena }

PROCEDURE Escribir_Cadena(cadi :Cadena);
VAR
   auxi :Cadena;
BEGIN
     auxi := cadi;
     WHILE (auxi <> NIL) DO BEGIN
           Write(auxi^.car);
           auxi := auxi^.sig;
     END;
END; { Escribir_Cadena }

PROCEDURE A_Fichero(VAR fich :TEXT; cadi :Cadena);
VAR
   x :WORD;
   auxi :Cadena;
BEGIN
     x := 1;
     auxi := cadi;
     WHILE (auxi <> NIL) DO BEGIN
           Write(fich, auxi^.car);
           x := x + 1;
           IF (x >= 80) THEN
              Writeln(fich);
           auxi := auxi^.sig;
     END;
END; { A_Fichero }

END. { ES }