#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include "family.h"
#include "libXs.h"

static void quit();
static void quit_info();
static void browse_callback();
static void browse_clist();
static void person_callback();
static void marriage_callback();
static void spouse_callback();
static void photo_callback();
static void notes_callback();
static void sources_callback();

static XtActionsRec actionsTable [] = {
   {"bye",  quit},
};
static char defaultTranslations[] = "<Key>Q:  bye()";


PERSON tree[MAXNODES];
char   line[MAXLINE];
int    indirect[MAXNODES];
int    current_node;
int    number_of_nodes=0;

main ( argc, argv )
int   argc;
char *argv[];
{
   int return_code;
   Widget    toplevel, list;
   Arg       wargs[10];
   int       n, i;
   XmString  *xmstr;
   char      list_string[80];
   XtTranslations trans_table;

   return_code = initialize_tree();

   if ( return_code == ERROR ) printf("\n\nAn error occurred in init_tree\n");
   else {
      printf("\n\nNumber of entries in database = %d\n",number_of_nodes);
 /*     print_tree(); */
   }

   toplevel = XtInitialize (argv[0], "XFamily", NULL, 0, &argc, argv);

   XtAddActions(actionsTable, XtNumber(actionsTable));
   trans_table = XtParseTranslationTable(defaultTranslations);

   xmstr = (XmString *) XtMalloc(sizeof(XmString)*number_of_nodes);

   for(i=0;i<number_of_nodes;++i){
      sprintf(list_string,"%s %s     ",tree[indirect[i]].name.other_names,
                                       tree[indirect[i]].name.family_name);
      xmstr[i] = XmStringCreate(list_string,XmSTRING_DEFAULT_CHARSET);
   }
 
   n = 0;
   XtSetArg(wargs[n], XmNitems,            xmstr );                  n++;
   XtSetArg(wargs[n], XmNitemCount,        number_of_nodes);         n++;
   XtSetArg(wargs[n], XmNvisibleItemCount, min(number_of_nodes,30)); n++;
   list = XmCreateScrolledList(toplevel,"list",wargs,n);
   XtManageChild(list);
   XtAddCallback(list, XmNbrowseSelectionCallback, browse_callback, NULL);
   XtAugmentTranslations(list, trans_table);
   XtRealizeWidget (toplevel);
   XtMainLoop();
}  

/*********************  end of main routine  **************************/

int initialize_tree()
{
   int  return_code=0;

   data_base = fopen("family.dat","r");
   if ( data_base == (FILE *)NULL ) return ERROR;

   setup_UNK_person();
   setup_ALT_person();

   while ( getline(line, MAXLINE, data_base) > 0 ) {
      if ( line[0] != '<' ) return ERROR;
      else if ( field_is("start record",1) ) number_of_nodes++;
      else if ( field_is("name",1)       ) return_code = insert_name();
      else if ( field_is("dob",1)        ) return_code = insert_dob();
      else if ( field_is("pob",1)        ) return_code = insert_pob();
      else if ( field_is("father",1)     ) return_code = insert_father();
      else if ( field_is("mother",1)     ) return_code = insert_mother();
      else if ( field_is("marriages",1)  ) return_code = insert_marriages();
      else if ( field_is("dod",1)        ) return_code = insert_dod();
      else if ( field_is("pod",1)        ) return_code = insert_pod();
      else if ( field_is("children",1)   ) return_code = insert_children();
      else if ( field_is("photos",1)     ) return_code = insert_photos();
      else if ( field_is("generation",1) ) return_code = insert_generation();
      if ( return_code < 0 ) return return_code;
   }
   return 0;
}

/***********************  end of routine initialize_tree  *******************/

int insert_name ( )
{
   int length;
   int cindex;
   int L1;                    /* index of end of family name   */
   int L2;                    /* index of start of family name */
   int flen;
   STRING tline;
   STRING temp_string;
   char   c;

   tline = get_name_and_number(&current_node);
   
   cindex = strlen(tline);
   while ( cindex && ((c=tline[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}
   L1     = cindex;
   while ( cindex && ((c=tline[--cindex]) != ' ' && c!='\t' && c!='\n') ) {}
   L2     = cindex + 1;

   if ( cindex < 0 ) return ERROR;

   flen = L2 - 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,tline,flen);
      temp_string[flen]='\0';
      tree[current_node].name.other_names = temp_string;
   }
   else{
      free(tline);
      return ERROR;
   }

   flen = L1 - L2 + 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,&tline[L2],flen);
      temp_string[flen]='\0';
      tree[current_node].name.family_name = temp_string;
      free(tline);
   }
   else{
      free(tline);
      return ERROR;
   }
   indirect[number_of_nodes-1] = current_node;
   tree[current_node].number_of_marriages = 0;
   tree[current_node].current_marriage    = 0;
   tree[current_node].number_of_photos    = 0;

   return OK;
}

/************************  end of routine insert_name  *********************/

int insert_father (  )
{
   STRING tline;
   int    ID;

   tline = get_name_and_number(&ID);
   tree[current_node].father = &tree[ID];
   if ( ID != NO_ONE ) free(tline);

   return OK;
}

/************************  end of routine insert_father  *******************/

int insert_mother (  )
{
   STRING tline;
   int    ID;

   tline = get_name_and_number(&ID);
   tree[current_node].mother = &tree[ID];
   if ( ID != NO_ONE ) free(tline);

   return OK;
}

/************************  end of routine insert_mother  *******************/

int insert_marriages ( )
{
   int nmarriages;
   int nbytes;
   int i;
   int ID;
   int status;
   int lend;
   int psize = sizeof(MARRIAGE_PTR);
   int msize = sizeof(MARRIAGE);
   STRING tline;
   MARRIAGE_PTR start_of_list;
   MARRIAGE_PTR *paddr;
   MARRIAGE     *this_mar;

   status = OK;
   nmarriages = tree[current_node].number_of_marriages = int_field(16);
   lend = (nmarriages>0) ? nmarriages : 1;
   if ( nmarriages >= 0 ) {
      tree[current_node].current_marriage = 1;
      nbytes = lend*psize;
      if ( (paddr=(MARRIAGE_PTR *)malloc(nbytes)) != NO_SUCH_MARRIAGE_PTR ){
         tree[current_node].marriage_list = paddr;
         for(i=0;i<lend;++i) {
            if ((this_mar=(MARRIAGE *)malloc(msize)) != NO_SUCH_MARRIAGE){
               *(paddr++) = this_mar;
               getline(line, MAXLINE, data_base);
               if ( field_is("Unknown",16) ) {
                  this_mar->wedding.year = UNKNOWN_NUMBER;
                  this_mar->wedding.date = UNKNOWN_STRING;
               }
               else if ( field_is("Unwed",16) ) {
                  this_mar->wedding.year = UNKNOWN_NUMBER;
                  this_mar->wedding.date = UNWED_STRING;
               }
               else {
                  this_mar->wedding.year = int_field(16);
                  if ((this_mar->wedding.date=string_field(21)) == NULL_STRING)
                     status = ERROR;
               }

               getline(line, MAXLINE, data_base);
               if ( field_is("Unknown",16) ) {
                  this_mar->wedding.place = UNKNOWN_STRING;
               }
               else if ( (this_mar->wedding.place = string_field(16)) 
			      == NULL_STRING ) status = ERROR;

               getline(line, MAXLINE, data_base);
               tline = get_name_and_number(&ID);
	       this_mar->spouse = &tree[ID];
	       if ( ID != NO_ONE && ID != ALTERNATE ) free(tline);
            }
            else status = ERROR;
         }
      }
      else status = ERROR;
   }

   return status;
}

/***************************  end of routine insert_marriages  ************/

int insert_children ( )
{
   int nchildren;
   int nbytes;
   int i;
   int ID;
   int psize = sizeof(PERSON_PTR);
   STRING tline;
   PERSON_PTR start_of_list;
   PERSON_PTR *paddr;

   nchildren = tree[current_node].number_of_children = int_field(16);
   if ( nchildren != 0 ) {
      nbytes = nchildren*psize;
      if ( (paddr=(PERSON_PTR *)malloc(nbytes)) != NO_SUCH_PERSON_PTR ){
         tree[current_node].child_list = paddr;
         for(i=0;i<nchildren;++i) {
            getline(line, MAXLINE, data_base);
            tline = get_name_and_number(&ID);
            *(paddr++) = &tree[ID];
            free(tline);
         }
      }
      else return ERROR;
   }

   return OK;
}

/***************************  end of routine insert_children  **************/

int insert_generation()
{
   tree[current_node].generation_number = int_field(16);
   return OK;
}

/****************************  end of routine insert_generation  ***********/

int insert_photos()
{
   tree[current_node].number_of_photos = int_field(16);
   return OK;
}

/****************************  end of routine insert_photos ****************/

int getline ( s, lim, stream )
char s[];
int  lim;
FILE *stream;
{
   int c, i;

   i=0;
   while (--lim > 0 && (c=getc(stream)) != EOF && c != '\n' ) s[i++] = c;
   if ( c == '\n' ) s[i++] = c;
   s[i] ='\0';
   return i;
}

/************************  end of routine getline  *********************/

int field_is(type,start_index)
STRING type;
int    start_index;
{
   int slen = strlen(type);
   char tline[MAXLINE];

   strncpy(tline,&line[start_index],slen);
   tline[slen] = '\0';
   return ( !strncmp(tline,type,slen) );
}

/************************** end of routine field_is  ********************/

int insert_dob()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].birth.year = UNKNOWN_NUMBER;
      tree[current_node].birth.date = UNKNOWN_STRING;
      return OK;
   }

   tree[current_node].birth.year = int_field(16);
   if ( (tree[current_node].birth.date = string_field(21)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_dob  ******************/

int insert_pob()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].birth.place = UNKNOWN_STRING;
      return OK;
   }

   if ( (tree[current_node].birth.place = string_field(16)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_pob  ********************/

int insert_dod()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].death.year = UNKNOWN_NUMBER;
      tree[current_node].death.date = UNKNOWN_STRING;
      return OK;
   }

   if ( field_is("Living",16) ) {
      tree[current_node].death.year = UNKNOWN_NUMBER;
      tree[current_node].death.date = LIVING_STRING;
      return OK;
   }
   tree[current_node].death.year = int_field(16);
   if ( (tree[current_node].death.date = string_field(21)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_dod  ******************/

int insert_pod()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].death.place = UNKNOWN_STRING;
      return OK;
   }

   if ( (tree[current_node].death.place = string_field(16)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_pod  ********************/

int int_field ( start_index )
int start_index;
{
    int slen;
    int cindex;
    int end_index;
    char temp_string[10];
    char c;

    cindex = start_index;
    while ( (c=line[cindex++]) != ' ' && c != '\t' && c != '\n' ) {}
    end_index = cindex + 1;

    slen = end_index-start_index+1;
    strncpy(temp_string,&line[start_index],slen);
    temp_string[slen] = '\0';

    return (atoi(temp_string));
}

/**************************  end of int_field  ***************************/

STRING string_field ( start_index )
int start_index;
{
   int length=strlen(line);
   int cindex;
   int flen;
   STRING temp_string;
   char c;

   cindex = length;
   while ( cindex && ((c=line[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}

   flen = cindex - start_index + 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,&line[start_index],flen);
      temp_string[flen]='\0';
   }
   return (temp_string);

}

/**************************  end of routine string_field  ********************/

print_tree()
{
   int i;

   for(i=0;i<number_of_nodes;++i) print_person(indirect[i]);
}

/***************************  end of routine print_tree  *********************/

print_person(i)
int i;
{
   int nchild;
   int nwed;

   printf("\nname       : %s %s",tree[i].name.other_names,
                                tree[i].name.family_name);
   if ( strcmp(tree[i].birth.date,UNKNOWN_STRING) == 0 )
        printf("\ndob        : Unknown");
   else printf("\ndob        : %s, %d",tree[i].birth.date,
                                      tree[i].birth.year);
   print_string("pob       ",tree[i].birth.place);
   print_name("father    ",tree[i].father);
   print_name("mother    ",tree[i].mother);
   printf("\nmarriages ",tree[i].number_of_marriages);
   for(nwed=1;nwed<=tree[i].number_of_marriages;nwed++){
      print_marriage(i, nwed);
   }
   if ( tree[i].number_of_marriages == 0 ) {
      printf("\ndom        : Unwed");
      printf("\npom        : Not applicable");
      printf("\nspouse     : Not applicable");
   }
   printf("\nchildren   : %d",tree[i].number_of_children);
   for(nchild=0;nchild<tree[i].number_of_children;++nchild){
      print_name("child     ",get_child_ptr(i,nchild));
   }
   if ( strcmp(tree[i].death.date,UNKNOWN_STRING) == 0 )
        printf("\ndod        : Unknown");
   else if ( strcmp(tree[i].death.date,LIVING_STRING) == 0 )
      printf("\ndod        : Living");
   else printf("\ndod        : %s, %d",tree[i].death.date,
                                       tree[i].death.year);
   print_string("pod       ",tree[i].death.place);
   printf("\ngeneration : %d",tree[i].generation_number);
   printf("\n");
}

/***************************  end of routine print_person  ******************/

print_marriage ( i, nwed )
int i, nwed;
{
   MARRIAGE *this_mar;
   PERSON_PTR pptr;

   this_mar = get_marriage_ptr(i,nwed);
   if ( strcmp(this_mar->wedding.date,UNKNOWN_STRING) == 0 )
        printf("\ndom        : Unknown");
   else printf("\ndom        : %s, %d",this_mar->wedding.date,
                                      this_mar->wedding.year);
   print_string("pom       ",this_mar->wedding.place);

   pptr = this_mar->spouse;
   if ( pptr == UNKNOWN_PERSON ) printf("\nspouse     : Unknown");
   else printf("\nspouse     : %s %s",pptr->name.other_names,
                                    pptr->name.family_name);
}

/**************************  end of routine print_name  *********************/   
print_string ( field, string )
STRING field;
STRING string;
{
      if ( string == NULL_STRING ) printf("\n%s : Unknown",field); 
      else printf("\n%s : %s",field,string);
}

/**************************  end of routine print_string  *******************/   
print_name ( label, ptr )
STRING label;
PERSON_PTR ptr;
{
      if ( ptr == UNKNOWN_PERSON ) printf("\n%s : Unknown",label);
      else if ( ptr == ALTERNATE_PERSON ) printf("\n%s : Unwed",label);
      else printf("\n%s : %s %s",label,ptr->name.other_names,
                                       ptr->name.family_name);
}
   
/**************************  end of routine print_name  *********************/   
STRING get_name_and_number ( number_ptr )
int *number_ptr;
{
   int length=strlen(line);
   int cindex;
   int L1;
   int L2;
   int slen;
   char c;
   char carray[10];
   STRING temp_string;

   cindex = length;
   while ( cindex && ((c=line[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}
   L1     = cindex;
   if ( field_is("Unknown",16) ){
      *number_ptr = NO_ONE;
      return (NULL_STRING);
   }
   else if ( field_is("Not applicable",16) || field_is("Unwed",16) ){
      *number_ptr = ALTERNATE;
      return (NULL_STRING);
   }
   while ( cindex && ((c=line[--cindex]) != ' ' && c!='\t') ) {}
   L2     = cindex + 1;

   slen = L1 - L2 + 1;
   strncpy(carray,&line[L2],slen);
   carray[slen] = '\0';

   *number_ptr = atoi(carray);
 
   slen = L2 - 17;
   if ( (temp_string=(STRING)malloc(slen+1)) != NULL_STRING ) {
      strncpy(temp_string,&line[16],slen);
      temp_string[slen]='\0';
   }

   return (temp_string);
}

/********************  end of routine get_name_and_number  *****************/
   
setup_UNK_person()
{
        tree[NO_ONE].name.family_name = UNKNOWN_STRING;
	tree[NO_ONE].name.other_names = UNKNOWN_STRING;
        tree[NO_ONE].number_of_marriages = UNKNOWN_NUMBER;
        tree[NO_ONE].death.year = UNKNOWN_NUMBER;
	tree[NO_ONE].death.place = UNKNOWN_STRING;
	tree[NO_ONE].death.date = UNKNOWN_STRING;
        tree[NO_ONE].father = &tree[NO_ONE];
        tree[NO_ONE].mother = &tree[NO_ONE];
        tree[NO_ONE].number_of_children = UNKNOWN_NUMBER;
        tree[NO_ONE].generation_number = UNKNOWN_NUMBER;
}

/*************************  end of setup_UNK_person  *************************/
   
setup_ALT_person()
{
	tree[ALTERNATE].name.family_name = UNWED_STRING;
	tree[ALTERNATE].name.other_names = UNWED_STRING;
        tree[ALTERNATE].number_of_marriages = UNKNOWN_NUMBER;
        tree[ALTERNATE].death.year = UNKNOWN_NUMBER;
	tree[ALTERNATE].death.place = NA_STRING;
	tree[ALTERNATE].death.date = LIVING_STRING;
        tree[ALTERNATE].father = &tree[ALTERNATE];
        tree[ALTERNATE].mother = &tree[ALTERNATE];
        tree[ALTERNATE].number_of_children = UNKNOWN_NUMBER;
        tree[ALTERNATE].generation_number = UNKNOWN_NUMBER;
}

/*************************  end of setup_ALT_person  *************************/

PERSON_PTR get_child_ptr ( i, j )
int i;
int j;
{
   PERSON_PTR *paddr;

   paddr = tree[i].child_list;
   return ( *( paddr + j ) );
}

/*************************  end of get_child_ptr  ***************************/

MARRIAGE_PTR get_marriage_ptr ( i, j )
int i;
int j;
{
   MARRIAGE_PTR *paddr;

   paddr = tree[i].marriage_list;
   return ( *( paddr + j - 1 ) );
}

/*************************  end of get_marriage_ptr  ************************/

static void quit(w, event, params, num_params)
   Widget        w;
   XEvent        *event;
   String        *params;
   Cardinal      *num_params;
{
   XtCloseDisplay(XtDisplay(w));
   exit(0);
}

/***************************  end of quit  ***********************************/

static void browse_callback(w, client_data, call_data)
   Widget               w;
   caddr_t              *client_data;
   XmListCallbackStruct *call_data;
{
   int ID;

   ID = (call_data->item_position) - 1;

   show_person(indirect[ID]);
}

/**************************  end of browse_callback  ***********************/

show_person(ID)
int        ID;
{
   Widget   info_shell;
   Widget   form;
   Widget   list_child;
   Widget   window_child;
   Widget   button[8];
   Widget   label[20];
   Widget   separator[8];
   char     *labels[]     = {"Name", 
                             "DOB", "birth_date", "POB",  "birth_place",
                             "Father    ", "Mother", 
                             "DOM", "w_date", "POM",  "w_place",
                             "Spouse",
                             "DOD", "death_date", "POD", "death_place",
                             "Children", "n_children",
                             "Generation", "n_generation"};
   char     *buttons[]    = {"fatherB", "motherB", "spouseB", "discard",
                             "photos", "sources", "notes","marriagesB"};
   char     *separators[] = {"separator1", "separator2", "separator3",
                             "separator4", "separator5", "separator6",
                             "separator7", "separator8"};
   XmString XmStrings[13];
   XmString xmstr[22];
   char     temp_string[80];
   Arg      wargs[10];
   int      i, n, nchild, nwed;
   PERSON_PTR temp_PTR;
   MARRIAGE_PTR this_wed;
   int      form_height[5]={ 400, 445, 470, 493, 515};
   float    delta[5]={ 90.3, 91.9, 92.0, 92.9, 93.0};
   int      nval;
   int      marriage_number;

   info_shell = XtCreateApplicationShell("Person",topLevelShellWidgetClass,
                                         NULL, 0);
   form       = XtCreateManagedWidget("form", xmFormWidgetClass,
                                      info_shell, NULL, 0);

   nchild = tree[ID].number_of_children;
   nwed   = tree[ID].number_of_marriages;
 
   if ( nchild > 0 ){ 
      for(i=0;i<nchild;++i){
         temp_PTR = get_child_ptr(ID,i);
         sprintf(temp_string,"%s    ",temp_PTR->name.other_names);
         xmstr[i] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
      }
      list_child = XmCreateScrolledList(form,"list_child", NULL, 0);
      window_child = XtParent(list_child);
   }

   for(i=0;i<XtNumber(labels);++i)
      label[i]     = XtCreateWidget(labels[i],xmLabelWidgetClass,
                               form, NULL, 0);  

   for(i=0;i<XtNumber(separators);++i)
      separator[i] = XtCreateWidget(separators[i],xmSeparatorWidgetClass,
                               form, NULL, 0);  

   for(i=0;i<XtNumber(buttons)-1;++i)
      button[i]    = XtCreateWidget(buttons[i],xmPushButtonWidgetClass,
                               form, NULL, 0);  
   if (nwed > 1) {
      i = XtNumber(buttons)-1;
      button[i]    = XtCreateWidget(buttons[i],xmPushButtonWidgetClass,
				     form, NULL, 0);
   }
      
   for(i=0;i<XtNumber(separators);++i)   XtManageChild(separator[i]);
   for(i=0;i<XtNumber(labels);++i)     XtManageChild(label[i]);
   for(i=0;i<XtNumber(buttons)-1;++i)    XtManageChild(button[i]);

   if (nwed > 1) {
      XtManageChild(button[XtNumber(buttons)-1]);
   }

   if ( nchild > 0 ){
       XtManageChild(list_child);
       XtAddCallback(list_child, XmNbrowseSelectionCallback, browse_clist, ID );
   }

   XtAddCallback(button[0],XmNactivateCallback,person_callback,tree[ID].father);
   XtAddCallback(button[1],XmNactivateCallback,person_callback,tree[ID].mother);
   XtAddCallback(button[2],XmNactivateCallback,spouse_callback,&tree[ID]);
   XtAddCallback(button[4],XmNactivateCallback,photo_callback,&tree[ID]);
   XtAddCallback(button[5],XmNactivateCallback,sources_callback,&tree[ID]);
   XtAddCallback(button[6],XmNactivateCallback,notes_callback,&tree[ID]);
   XtAddCallback(button[3], XmNactivateCallback, quit_info, info_shell);
   if ( nwed > 1 )
    XtAddCallback(button[7], XmNactivateCallback, marriage_callback, &tree[ID]);

   sprintf(temp_string,"%s %s",tree[ID].name.other_names,
                               tree[ID].name.family_name);
   XmStrings[0] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   if ( strcmp(tree[ID].birth.date,UNKNOWN_STRING) == 0 )
        strcpy(temp_string,UNKNOWN_STRING);
   else sprintf(temp_string,"%s, %d",tree[ID].birth.date,
                                     tree[ID].birth.year);
   XmStrings[1] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   XmStrings[2] = XmStringCreate(tree[ID].birth.place,XmSTRING_DEFAULT_CHARSET);
   temp_PTR = tree[ID].father;
   if ( temp_PTR == UNKNOWN_PERSON ) strcpy(temp_string,UNKNOWN_STRING);
   else sprintf(temp_string,"%s %s",temp_PTR->name.other_names,
                                    temp_PTR->name.family_name);
   XmStrings[3] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   temp_PTR = tree[ID].mother;
   if ( temp_PTR == UNKNOWN_PERSON ) strcpy(temp_string,UNKNOWN_STRING);
   else sprintf(temp_string,"%s %s",temp_PTR->name.other_names,
                                    temp_PTR->name.family_name);
   XmStrings[4] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);

   tree[ID].current_marriage = 1;
   this_wed = get_marriage_ptr (ID,1);
   if ( strcmp(this_wed->wedding.date,UNKNOWN_STRING) == 0 )
        strcpy(temp_string,UNKNOWN_STRING);
   else if ( strcmp(this_wed->wedding.date,UNWED_STRING) == 0 )
        strcpy(temp_string,UNWED_STRING);
   else sprintf(temp_string,"%s, %d",this_wed->wedding.date,
                                     this_wed->wedding.year);
   XmStrings[5] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   XmStrings[6] = XmStringCreate(this_wed->wedding.place,
				 XmSTRING_DEFAULT_CHARSET);
   temp_PTR = this_wed->spouse;
   if ( temp_PTR == UNKNOWN_PERSON ) strcpy(temp_string,UNKNOWN_STRING);
   else if ( temp_PTR == ALTERNATE_PERSON ) strcpy(temp_string,NA_STRING);
   else sprintf(temp_string,"%s %s",temp_PTR->name.other_names,
                                    temp_PTR->name.family_name);
   XmStrings[7] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);

   if ( strcmp(tree[ID].death.date,UNKNOWN_STRING) == 0 )
        strcpy(temp_string,UNKNOWN_STRING);
   else if ( strcmp(tree[ID].death.date,LIVING_STRING) == 0 )
        strcpy(temp_string,LIVING_STRING);
   else sprintf(temp_string,"%s, %d",tree[ID].death.date,tree[ID].death.year);
   XmStrings[8] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   XmStrings[9] = XmStringCreate(tree[ID].death.place,XmSTRING_DEFAULT_CHARSET);

   sprintf(temp_string,"%d",tree[ID].number_of_children);
   XmStrings[10] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);

   sprintf(temp_string,"%d",tree[ID].generation_number);
   XmStrings[11] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);

   marriage_number = tree[ID].current_marriage;
   if ( tree[ID].number_of_marriages > 1 ){
      sprintf(temp_string,"%2d",marriage_number);
      XmStrings[12] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
   }

   nval = min(4,nchild);
   n = 0;
   XtSetArg(wargs[n], XmNheight,      form_height[nval]); n++;
   XtSetValues(form, wargs, n);

/*  NAME LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[0]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(label[0], wargs, n);

/*  HORIZONTAL SEPARATOR 1 */

   n = 0;
   XtSetArg(wargs[n], XmNseparatorType,    XmDOUBLE_LINE); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[0]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[0], wargs, n);

/*  HORIZONTAL SEPARATOR 2 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[3]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[2], wargs, n);

/*  HORIZONTAL SEPARATOR 3 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        button[1]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[3], wargs, n);

/*  HORIZONTAL SEPARATOR 4 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        button[2]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[4], wargs, n);

/*  HORIZONTAL SEPARATOR 5 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   if ( nchild > 0 )
      {XtSetArg(wargs[n], XmNtopWidget,        window_child);        n++;}
   else
      {XtSetArg(wargs[n], XmNtopWidget,        label[17]);        n++;}
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[5], wargs, n);

/*  HORIZONTAL SEPARATOR 6 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[15]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[6], wargs, n);

/*  HORIZONTAL SEPARATOR 7 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
   XtSetArg(wargs[n], XmNtopPosition,      delta[nval]);        n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(separator[7], wargs, n);

/*  VERTICAL SEPARATOR 1 */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[0]);        n++;
   XtSetArg(wargs[n], XmNbottomAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNbottomWidget,       separator[7]); n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,       label[5]); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(separator[1], wargs, n);

/*  DOB LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[0]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[1], wargs, n);

/*  BIRTH_DATE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[1]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[0]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[2], wargs, n);

/*  POB LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[1]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[3], wargs, n);

/*  BIRTH_PLACE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[2]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[2]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[4], wargs, n);

/*  FATHER LABEL */ 

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[2]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[5], wargs, n);

/*  FATHER BUTTON */ 

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[3]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[2]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(button[0], wargs, n);

/*  MOTHER LABEL */ 

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[5]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[6], wargs, n);

/*  MOTHER BUTTON */ 

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[4]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        button[0]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(button[1], wargs, n);

/*  DOM LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[3]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[7], wargs, n);

/*  WEDDING_DATE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[5]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[3]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[8], wargs, n);

/*  POM LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[7]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[9], wargs, n);

/*  WEDDING_PLACE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[6]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[8]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[10], wargs, n);

/*  SPOUSE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[9]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[11], wargs, n);

/*  SPOUSE BUTTON */ 

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[7]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[10]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetValues(button[2], wargs, n);

/*  NUMBER OF MARRIAGES BUTTON */ 

   if ( tree[ID].number_of_marriages > 1 ){
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,      XmStrings[12]); n++;
      XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNtopWidget,        separator[3]);          n++;
      XtSetArg(wargs[n], XmNrightAttachment,    XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNrightWidget,        separator[1]);          n++;
      XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_NONE); n++;
      XtSetValues(button[7], wargs, n);
   }
/*  DOD LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[5]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[12], wargs, n);

/*  DEATH_DATE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[8]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[5]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[13], wargs, n);

/*  POD LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[12]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[14], wargs, n);

/*  DEATH_PLACE LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[9]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        label[13]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[15], wargs, n);

/*  CHILDREN LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[4]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[16], wargs, n);

/* NUMBER OF CHILDREN LABEL */

   n=0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[10]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[4]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[17], wargs, n);

   if ( nchild > 0 ){
      n = 0;
      XtSetArg(wargs[n], XmNitems,            xmstr );                  n++;
      XtSetArg(wargs[n], XmNitemCount,        nchild);         n++;
      XtSetArg(wargs[n], XmNvisibleItemCount, min(nchild,4)); n++;
      XtSetValues(list_child, wargs, n);

      n = 0;
      XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNtopWidget,        label[17]);          n++;
      XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
      XtSetArg(wargs[n], XmNbottomAttachment,  XmATTACH_NONE); n++;
      XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
      XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
      XtSetValues(window_child, wargs, n);
   }

/*  GENERATION LABEL */

   n = 0;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[6]);          n++;
   XtSetArg(wargs[n], XmNbottomAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNbottomWidget,     separator[7]);          n++;
   XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_NONE); n++;
   XtSetValues(label[18], wargs, n);

/* GENERATION NUMBER LABEL */

   n=0;
   XtSetArg(wargs[n], XmNlabelString,      XmStrings[11]); n++;
   XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNtopWidget,        separator[6]);          n++;
   XtSetArg(wargs[n], XmNbottomAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNbottomWidget,     separator[7]);          n++;
   XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM); n++;
   XtSetArg(wargs[n], XmNleftAttachment,    XmATTACH_WIDGET); n++;
   XtSetArg(wargs[n], XmNleftWidget,        separator[1]);          n++;
   XtSetValues(label[19], wargs, n);

/*  BUTTON 4 */

   n = 0;
   XtSetArg(wargs[n], XmNleftAttachment,  XmATTACH_FORM);  n++;
   XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNrightPosition,   25);  n++;
   XtSetArg(wargs[n], XmNtopAttachment,   XmATTACH_WIDGET);n++;
   XtSetArg(wargs[n], XmNtopWidget,       separator[7]);     n++;
   XtSetArg(wargs[n], XmNbottomAttachment,XmATTACH_FORM);  n++;
   XtSetValues(button[3], wargs, n);

/*  BUTTON 5 */

   n = 0;
   XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNleftPosition,   25);  n++;
   XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNrightPosition,   50);  n++;
   XtSetArg(wargs[n], XmNtopAttachment,   XmATTACH_WIDGET);n++;
   XtSetArg(wargs[n], XmNtopWidget,       separator[7]);     n++;
   XtSetArg(wargs[n], XmNbottomAttachment,XmATTACH_FORM);  n++;
   XtSetValues(button[4], wargs, n);

/*  BUTTON 6 */

   n = 0;
   XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNleftPosition,   50);  n++;
   XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNrightPosition,   75);  n++;
   XtSetArg(wargs[n], XmNtopAttachment,   XmATTACH_WIDGET);n++;
   XtSetArg(wargs[n], XmNtopWidget,       separator[7]);     n++;
   XtSetArg(wargs[n], XmNbottomAttachment,XmATTACH_FORM);  n++;
   XtSetValues(button[5], wargs, n);

/*  BUTTON 7 */

   n = 0;
   XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_POSITION);  n++;
   XtSetArg(wargs[n], XmNleftPosition,   75);  n++;
   XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM);  n++;
   XtSetArg(wargs[n], XmNtopAttachment,   XmATTACH_WIDGET);n++;
   XtSetArg(wargs[n], XmNtopWidget,       separator[7]);     n++;
   XtSetArg(wargs[n], XmNbottomAttachment,XmATTACH_FORM);  n++;
   XtSetValues(button[6], wargs, n);

   XtRealizeWidget(info_shell);

}

/***************************  end of show_person *****************************/

static void quit_info(w, client_data, call_data)
   Widget        w;
   Widget        client_data;
   XmAnyCallbackStruct *call_data;
{
   XtDestroyWidget(client_data);
}

/***************************  end of quit_info  ******************************/

static void spouse_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int person_ID;
   MARRIAGE_PTR this_mar;
   int cmar;

   person_ID = (client_data - (&tree[0]));
   cmar = tree[person_ID].current_marriage;

   this_mar = *(tree[person_ID].marriage_list + cmar - 1);
   person_ID = (this_mar->spouse - (&tree[0]));
   if ( person_ID < ALTERNATE ) show_person(person_ID);
}

/***************************  end of spouse_callback *************************/

static void notes_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int person_ID;
   int i;
   char load_string[38];

   person_ID = (client_data - (&tree[0]));

   sprintf(load_string,"fileview NOTES/notes%4d",person_ID);
   if ( person_ID<1000 )  load_string[20] = '0';
   if ( person_ID<100  )  load_string[21] = '0';
   if ( person_ID<10   )  load_string[22] = '0';
   system(load_string);
}

/***************************  end of notes_callback *************************/

static void sources_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int person_ID;
   int i;
   char load_string[38];

   person_ID = (client_data - (&tree[0]));

   sprintf(load_string,"sourceview %d",person_ID);
   system(load_string);
}

/****************************  end of sources_callback ************************/

static void photo_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int person_ID;
   int i;
   int nphotos;
   char load_string[38];

   person_ID = (client_data - (&tree[0]));
   nphotos = tree[person_ID].number_of_photos;

   for(i=0;i<nphotos;++i){
      sprintf(load_string,"xv PHOTOS/X%4d.%2d.*",person_ID,i);
      if ( i<10 )            load_string[16] = '0';
      if ( person_ID<1000 )  load_string[11] = '0';
      if ( person_ID<100  )  load_string[12] = '0';
      if ( person_ID<10   )  load_string[13] = '0';
      system(load_string);
   }
}

/***************************  end of photo_callback *************************/

static void person_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int person_ID;
   person_ID = (client_data - (&tree[0]));
   if ( person_ID < ALTERNATE ) show_person(person_ID);
}

/***************************  end of person_callback *************************/

static void browse_clist(w, ID, call_data)
   Widget               w;
   int                  ID;
   XmListCallbackStruct *call_data;
{
   int person_ID;
   int child_number;

   child_number = (call_data->item_position) - 1;
   person_ID = (*(tree[ID].child_list + child_number)- (&tree[0]));

   show_person(person_ID);
}

/**************************  end of browse_clist  ****************************/

static void marriage_callback(w, client_data, call_data)
Widget     w;
PERSON_PTR client_data;
XmAnyCallbackStruct *call_data;
{
   int n;
   int marriage_number;
   Arg      wargs[10];
   XmString XmStrings[13];
   char     temp_string[80];
   MARRIAGE_PTR this_wed;
   PERSON_PTR   temp_PTR;
   int nwed;
   int cwed;
   Widget spouse;
   Widget dom;
   Widget pom;
   Widget form;

   nwed = client_data->number_of_marriages;
   if ( nwed > 1 ){
      form = XtParent(w);
      spouse = XtNameToWidget(form,"spouseB");
      dom    = XtNameToWidget(form,"w_date");
      pom    = XtNameToWidget(form,"w_place");
      cwed = (client_data->current_marriage++)%nwed + 1;
      client_data->current_marriage = cwed;
      marriage_number = client_data->current_marriage;
      this_wed =  *(client_data->marriage_list + marriage_number - 1);
      if ( strcmp(this_wed->wedding.date,UNKNOWN_STRING) == 0 )
           strcpy(temp_string,UNKNOWN_STRING);
      else if ( strcmp(this_wed->wedding.date,UNWED_STRING) == 0 )
           strcpy(temp_string,UNWED_STRING);
      else sprintf(temp_string,"%s, %d",this_wed->wedding.date,
                                        this_wed->wedding.year);
      XmStrings[5] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
      XmStrings[6] = XmStringCreate(this_wed->wedding.place,
   				 XmSTRING_DEFAULT_CHARSET);
      temp_PTR = this_wed->spouse;
      if ( temp_PTR == UNKNOWN_PERSON ) strcpy(temp_string,UNKNOWN_STRING);
      else if ( temp_PTR == ALTERNATE_PERSON ) strcpy(temp_string,NA_STRING);
      else sprintf(temp_string,"%s %s",temp_PTR->name.other_names,
                                       temp_PTR->name.family_name);
      XmStrings[7] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
      sprintf(temp_string,"%2d",marriage_number);
      XmStrings[12] = XmStringCreate(temp_string,XmSTRING_DEFAULT_CHARSET);
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,      XmStrings[12]); n++;
      XtSetValues(w, wargs, n);
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,      XmStrings[5]); n++;
      XtSetValues(dom, wargs, n);
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,      XmStrings[6]); n++;
      XtSetValues(pom, wargs, n);
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,      XmStrings[7]); n++;
      XtSetValues(spouse, wargs, n);
   }

}

/***************************  end of person_callback *************************/
