#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "libXs.h"

#define MAX_SOURCES 50
#define min(A,B)        ((A) < (B) ? (A) : (B))

static void quit();
static void choose_callback();

static XtActionsRec actionsTable [] = {
   {"bye",  quit},
};
static char defaultTranslations[] = "<Key>Q:  bye()";

main ( argc, argv )
int   argc;
char *argv[];
{
   int ID, return_code, number_of_files;
   Widget    toplevel, list;
   Arg       wargs[10];
   int       n, i;
   XmString  *xmstr, dirstr;
   char      *list_string[MAX_SOURCES];
   XtTranslations trans_table;

   ID = atoi (argv[1]);
   return_code = initialize_sourceview (ID, list_string, &number_of_files);
   if (return_code<0) exit (1);

   toplevel = XtInitialize (argv[0], "Sourceview", NULL, 0, &argc, argv);

   XtAddActions (actionsTable, XtNumber(actionsTable));
   trans_table = XtParseTranslationTable (defaultTranslations);

   xmstr = (XmString *) XtMalloc (sizeof(XmString)*number_of_files);

   for(i=0;i<number_of_files;++i){
      xmstr[i] = XmStringCreate (list_string[i],XmSTRING_DEFAULT_CHARSET);
   }
   n = 0;
   XtSetArg(wargs[n], XmNitems,            xmstr );                  n++;
   XtSetArg(wargs[n], XmNitemCount,        number_of_files);         n++;
   XtSetArg(wargs[n], XmNvisibleItemCount, min(number_of_files,8)); n++;
   list = XmCreateScrolledList(toplevel,"files",wargs,n);
   XtManageChild(list);
   XtAddCallback(list, XmNbrowseSelectionCallback, choose_callback,list_string);
   XtAugmentTranslations(list, trans_table);
   XtRealizeWidget (toplevel);
   XtMainLoop();

   exit (0);
}

/************************* end of main routine ********************************/

static void choose_callback (w, file_list, call_data)
Widget     w;
char  **file_list;
XmListCallbackStruct *call_data;
{
   char load_string[38];
   int i;

   i = call_data->item_position - 1;

   sprintf(load_string,"fileview DOCS/%s",file_list[i]);
   system(load_string);
}

/**************************** end of fileSB_callback **************************/

static void quit(w, event, params, num_params)
   Widget        w;
   XEvent        *event;
   String        *params;
   Cardinal      *num_params;
{
   XtCloseDisplay(XtDisplay(w));
   exit(0);
}

/****************************  end of quit  ***********************************/

initialize_sourceview (ID, ptr_to_strings, nstrings)
int ID, *nstrings;
char **ptr_to_strings;
{
   char file_string[20];
   char word[81];
   char *temp_string;
   FILE *fopen(), *file;
   int word_len;

   sprintf (file_string, "SOURCES/sources%4d",ID);
   if ( ID <1000 ) file_string[15] = '0';
   if ( ID <100  ) file_string[16] = '0';
   if ( ID <10   ) file_string[17] = '0';

   file = fopen(file_string,"r");
   if ( file == (FILE *)NULL ) return -1;

   *nstrings = 0;
   while ( (getword(word, 80, file) > 0) && (*nstrings<MAX_SOURCES) ) {
       word_len = strlen (word);
       if ( (temp_string=(char *)malloc(word_len+1)) != ((char *)0) ) {
       strcpy(temp_string,word); }
       ptr_to_strings[(*nstrings)++] = temp_string;
   }

   return 0;
}

/********************** end of initialize_sourceview **************************/

int getword (word, lim, file)
char *word;
int lim;
FILE *file;
{
   int c;
   char *w = word;

   while (isspace(c=getc(file))) {}
   if (c != EOF) *w++ = c;
   while (!isspace(c=getc(file))) {
      if (c != EOF) *w++ = c;
      else break;
   }
   *w = '\0';
   return word[0];
}

/*************************** end of getword ***********************************/
