#define NO_SUCH_PERSON  ( (PERSON_PTR)0 )
#define NO_SUCH_PERSON_PTR  ( (PERSON_PTR *)0 )
#define NO_SUCH_MARRIAGE_PTR  ( (MARRIAGE_PTR *)0 )
#define NO_SUCH_MARRIAGE      ( (MARRIAGE *)0 )
#define UNKNOWN_NUMBER  -999
#define MAXNODES        1000
#define NO_ONE          (MAXNODES-1)
#define ALTERNATE       (MAXNODES-2)
#define UNKNOWN_PERSON  (&tree[NO_ONE])
#define ALTERNATE_PERSON  (&tree[ALTERNATE])
#define MAXLINE         80
#define OK               1
#define ERROR           -1
#define NULL_STRING     ((STRING)0)
#define max(A,B)        ((A) > (B) ? (A) : (B))
#define min(A,B)        ((A) < (B) ? (A) : (B))

typedef char *STRING;

typedef struct name {
    STRING   family_name;
    STRING   other_names;
} NAME;

typedef struct event {
    int      year;
    STRING   date;
    STRING   place;
} EVENT;

typedef struct marriage {
    EVENT    wedding;
    struct person *spouse;
} MARRIAGE, *MARRIAGE_PTR;

typedef struct person {
    NAME          name;
    EVENT         birth;
    EVENT         death;
    struct person *father;
    struct person *mother;
    int           number_of_marriages;
    int           current_marriage;
    struct marriage **marriage_list;
    int           number_of_children;
    struct person **child_list;
    int           number_of_photos;
    int           generation_number;
} PERSON, *PERSON_PTR;

STRING string_field ( /* int start_index */);
STRING get_name_and_number ( /* int *number_ptr */ );
STRING UNKNOWN_STRING = "Unknown";
STRING UNWED_STRING   = "Unwed";
STRING LIVING_STRING  = "Living";
STRING NA_STRING      = "Not applicable";
FILE *data_base;
PERSON_PTR get_child_ptr( /* int i, int j */ );
MARRIAGE_PTR get_marriage_ptr();
