#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "family.h"

PERSON tree[MAXNODES];
char   line[MAXLINE];
int    indirect[MAXNODES];
int    jndirect[MAXNODES];
int    current_node;
int    number_of_nodes=0;
STRING c2upper();

main ( argc, argv )
int   argc;
char *argv[];
{
   int return_code;

   return_code = initialize_tree();

   if ( return_code == ERROR ) printf("\n\nAn error occurred in init_tree\n");
   else {
   /*
      printf("\n\nNumber of entries in database = %d\n",number_of_nodes);
      */
      PS_print_tree(); 
   }
}  

/*********************  end of main routine  **************************/

int initialize_tree()
{
   int  return_code=0;

   data_base = fopen("family.dat","r");
   if ( data_base == (FILE *)NULL ) return ERROR;

   setup_UNK_person();
   setup_ALT_person();

   while ( getline(line, MAXLINE, data_base) > 0 ) {
      if ( line[0] != '<' ) return ERROR;
      else if ( field_is("start record",1) ) number_of_nodes++;
      else if ( field_is("name",1)       ) return_code = insert_name();
      else if ( field_is("dob",1)        ) return_code = insert_dob();
      else if ( field_is("pob",1)        ) return_code = insert_pob();
      else if ( field_is("father",1)     ) return_code = insert_father();
      else if ( field_is("mother",1)     ) return_code = insert_mother();
      else if ( field_is("marriages",1)  ) return_code = insert_marriages();
      else if ( field_is("dod",1)        ) return_code = insert_dod();
      else if ( field_is("pod",1)        ) return_code = insert_pod();
      else if ( field_is("children",1)   ) return_code = insert_children();
      else if ( field_is("photos",1)     ) return_code = insert_photos();
      else if ( field_is("generation",1) ) return_code = insert_generation();
      if ( return_code < 0 ) return return_code;
   }
   return 0;
}

/***********************  end of routine initialize_tree  *******************/

int insert_name ( )
{
   int length;
   int cindex;
   int L1;                    /* index of end of family name   */
   int L2;                    /* index of start of family name */
   int flen;
   STRING tline;
   STRING temp_string;
   char   c;

   tline = get_name_and_number(&current_node);
   
   cindex = strlen(tline);
   while ( cindex && ((c=tline[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}
   L1     = cindex;
   while ( cindex && ((c=tline[--cindex]) != ' ' && c!='\t' && c!='\n') ) {}
   L2     = cindex + 1;

   if ( cindex < 0 ) return ERROR;

   flen = L2 - 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,tline,flen);
      temp_string[flen]='\0';
      tree[current_node].name.other_names = temp_string;
   }
   else{
      free(tline);
      return ERROR;
   }

   flen = L1 - L2 + 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,&tline[L2],flen);
      temp_string[flen]='\0';
      tree[current_node].name.family_name = temp_string;
      free(tline);
   }
   else{
      free(tline);
      return ERROR;
   }
   indirect[number_of_nodes-1] = current_node;
   jndirect[current_node]      = number_of_nodes-1;
   tree[current_node].number_of_marriages = 0;
   tree[current_node].current_marriage    = 0;

   return OK;
}

/************************  end of routine insert_name  *********************/

int insert_father (  )
{
   STRING tline;
   int    ID;

   tline = get_name_and_number(&ID);
   tree[current_node].father = &tree[ID];
   if ( ID != NO_ONE ) free(tline);

   return OK;
}

/************************  end of routine insert_father  *******************/

int insert_mother (  )
{
   STRING tline;
   int    ID;

   tline = get_name_and_number(&ID);
   tree[current_node].mother = &tree[ID];
   if ( ID != NO_ONE ) free(tline);

   return OK;
}

/************************  end of routine insert_mother  *******************/

int insert_marriages ( )
{
   int nmarriages;
   int nbytes;
   int i;
   int ID;
   int status;
   int lend;
   int psize = sizeof(MARRIAGE_PTR);
   int msize = sizeof(MARRIAGE);
   STRING tline;
   MARRIAGE_PTR start_of_list;
   MARRIAGE_PTR *paddr;
   MARRIAGE     *this_mar;

   status = OK;
   nmarriages = tree[current_node].number_of_marriages = int_field(16);
   lend = (nmarriages>0) ? nmarriages : 1;
   if ( nmarriages >= 0 ) {
      tree[current_node].current_marriage = 1;
      nbytes = lend*psize;
      if ( (paddr=(MARRIAGE_PTR *)malloc(nbytes)) != NO_SUCH_MARRIAGE_PTR ){
         tree[current_node].marriage_list = paddr;
         for(i=0;i<lend;++i) {
            if ((this_mar=(MARRIAGE *)malloc(msize)) != NO_SUCH_MARRIAGE){
               *(paddr++) = this_mar;
               getline(line, MAXLINE, data_base);
               if ( field_is("Unknown",16) ) {
                  this_mar->wedding.year = UNKNOWN_NUMBER;
                  this_mar->wedding.date = UNKNOWN_STRING;
               }
               else if ( field_is("Unwed",16) ) {
                  this_mar->wedding.year = UNKNOWN_NUMBER;
                  this_mar->wedding.date = UNWED_STRING;
               }
               else {
                  this_mar->wedding.year = int_field(16);
                  if ((this_mar->wedding.date=string_field(21)) == NULL_STRING)
                     status = ERROR;
               }

               getline(line, MAXLINE, data_base);
               if ( field_is("Unknown",16) ) {
                  this_mar->wedding.place = UNKNOWN_STRING;
               }
               else if ( (this_mar->wedding.place = string_field(16)) 
			      == NULL_STRING ) status = ERROR;

               getline(line, MAXLINE, data_base);
               tline = get_name_and_number(&ID);
	       this_mar->spouse = &tree[ID];
	       if ( ID != NO_ONE && ID != ALTERNATE ) free(tline);
            }
            else status = ERROR;
         }
      }
      else status = ERROR;
   }

   return status;
}

/***************************  end of routine insert_marriages  ************/

int insert_children ( )
{
   int nchildren;
   int nbytes;
   int i;
   int ID;
   int psize = sizeof(PERSON_PTR);
   STRING tline;
   PERSON_PTR start_of_list;
   PERSON_PTR *paddr;

   nchildren = tree[current_node].number_of_children = int_field(16);
   if ( nchildren != 0 ) {
      nbytes = nchildren*psize;
      if ( (paddr=(PERSON_PTR *)malloc(nbytes)) != NO_SUCH_PERSON_PTR ){
         tree[current_node].child_list = paddr;
         for(i=0;i<nchildren;++i) {
            getline(line, MAXLINE, data_base);
            tline = get_name_and_number(&ID);
            *(paddr++) = &tree[ID];
            free(tline);
         }
      }
      else return ERROR;
   }

   return OK;
}

/***************************  end of routine insert_children  **************/

int insert_photos()
{
   tree[current_node].number_of_photos = int_field(16);
   return OK;
}

/****************************  end of routine insert_photos ****************/

int insert_generation()
{
   tree[current_node].generation_number = int_field(16);
   return OK;
}

/****************************  end of routine insert_generation  ***********/

int getline ( s, lim, stream )
char s[];
int  lim;
FILE *stream;
{
   int c, i;

   i=0;
   while (--lim > 0 && (c=getc(stream)) != EOF && c != '\n' ) s[i++] = c;
   if ( c == '\n' ) s[i++] = c;
   s[i] ='\0';
   return i;
}

/************************  end of routine getline  *********************/

int field_is(type,start_index)
STRING type;
int    start_index;
{
   int slen = strlen(type);
   char tline[MAXLINE];

   strncpy(tline,&line[start_index],slen);
   tline[slen] = '\0';
   return ( !strncmp(tline,type,slen) );
}

/************************** end of routine field_is  ********************/

int insert_dob()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].birth.year = UNKNOWN_NUMBER;
      tree[current_node].birth.date = UNKNOWN_STRING;
      return OK;
   }

   tree[current_node].birth.year = int_field(16);
   if ( (tree[current_node].birth.date = string_field(21)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_dob  ******************/

int insert_pob()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].birth.place = UNKNOWN_STRING;
      return OK;
   }

   if ( (tree[current_node].birth.place = string_field(16)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_pob  ********************/

int insert_dod()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].death.year = UNKNOWN_NUMBER;
      tree[current_node].death.date = UNKNOWN_STRING;
      return OK;
   }

   if ( field_is("Living",16) ) {
      tree[current_node].death.year = UNKNOWN_NUMBER;
      tree[current_node].death.date = LIVING_STRING;
      return OK;
   }
   tree[current_node].death.year = int_field(16);
   if ( (tree[current_node].death.date = string_field(21)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_dod  ******************/

int insert_pod()
{
   if ( field_is("Unknown",16) ) {
      tree[current_node].death.place = UNKNOWN_STRING;
      return OK;
   }

   if ( (tree[current_node].death.place = string_field(16)) != NULL_STRING )
      return OK;
   else
      return ERROR;

}

/**************************  end of routine insert_pod  ********************/

int int_field ( start_index )
int start_index;
{
    int slen;
    int cindex;
    int end_index;
    char temp_string[10];
    char c;

    cindex = start_index;
    while ( (c=line[cindex++]) != ' ' && c != '\t' && c != '\n' ) {}
    end_index = cindex + 1;

    slen = end_index-start_index+1;
    strncpy(temp_string,&line[start_index],slen);
    temp_string[slen] = '\0';

    return (atoi(temp_string));
}

/**************************  end of int_field  ***************************/

STRING string_field ( start_index )
int start_index;
{
   int length=strlen(line);
   int cindex;
   int flen;
   STRING temp_string;
   char c;

   cindex = length;
   while ( cindex && ((c=line[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}

   flen = cindex - start_index + 1;
   if ( (temp_string=(STRING)malloc(flen+1)) != NULL_STRING ) {
      strncpy(temp_string,&line[start_index],flen);
      temp_string[flen]='\0';
   }
   return (temp_string);

}

/**************************  end of routine string_field  ********************/

STRING get_name_and_number ( number_ptr )
int *number_ptr;
{
   int length=strlen(line);
   int cindex;
   int L1;
   int L2;
   int slen;
   char c;
   char carray[10];
   STRING temp_string;

   cindex = length;
   while ( cindex && ((c=line[--cindex]) == ' ' || c=='\t' || c=='\n') ) {}
   L1     = cindex;
   if ( field_is("Unknown",16) ){
      *number_ptr = NO_ONE;
      return (NULL_STRING);
   }
   else if ( field_is("Not applicable",16) || field_is("Unwed",16) ){
      *number_ptr = ALTERNATE;
      return (NULL_STRING);
   }
   while ( cindex && ((c=line[--cindex]) != ' ' && c!='\t') ) {}
   L2     = cindex + 1;

   slen = L1 - L2 + 1;
   strncpy(carray,&line[L2],slen);
   carray[slen] = '\0';

   *number_ptr = atoi(carray);
 
   slen = L2 - 17;
   if ( (temp_string=(STRING)malloc(slen+1)) != NULL_STRING ) {
      strncpy(temp_string,&line[16],slen);
      temp_string[slen]='\0';
   }

   return (temp_string);
}

/********************  end of routine get_name_and_number  *****************/
   
setup_UNK_person()
{
        tree[NO_ONE].name.family_name = UNKNOWN_STRING;
	tree[NO_ONE].name.other_names = UNKNOWN_STRING;
        tree[NO_ONE].number_of_marriages = UNKNOWN_NUMBER;
        tree[NO_ONE].death.year = UNKNOWN_NUMBER;
	tree[NO_ONE].death.place = UNKNOWN_STRING;
	tree[NO_ONE].death.date = UNKNOWN_STRING;
        tree[NO_ONE].father = &tree[NO_ONE];
        tree[NO_ONE].mother = &tree[NO_ONE];
        tree[NO_ONE].number_of_children = UNKNOWN_NUMBER;
        tree[NO_ONE].generation_number = UNKNOWN_NUMBER;
}

/*************************  end of setup_UNK_person  *************************/
   
setup_ALT_person()
{
	tree[ALTERNATE].name.family_name = UNWED_STRING;
	tree[ALTERNATE].name.other_names = UNWED_STRING;
        tree[ALTERNATE].number_of_marriages = UNKNOWN_NUMBER;
        tree[ALTERNATE].death.year = UNKNOWN_NUMBER;
	tree[ALTERNATE].death.place = NA_STRING;
	tree[ALTERNATE].death.date = LIVING_STRING;
        tree[ALTERNATE].father = &tree[ALTERNATE];
        tree[ALTERNATE].mother = &tree[ALTERNATE];
        tree[ALTERNATE].number_of_children = UNKNOWN_NUMBER;
        tree[ALTERNATE].generation_number = UNKNOWN_NUMBER;
}

/*************************  end of setup_ALT_person  *************************/

PERSON_PTR get_child_ptr ( i, j )
int i;
int j;
{
   PERSON_PTR *paddr;

   paddr = tree[i].child_list;
   return ( *( paddr + j ) );
}

/*************************  end of get_child_ptr  ***************************/

MARRIAGE_PTR get_marriage_ptr ( i, j )
int i;
int j;
{
   MARRIAGE_PTR *paddr;

   paddr = tree[i].marriage_list;
   return ( *( paddr + j - 1 ) );
}

/*************************  end of get_marriage_ptr  ************************/

PS_print_tree()
{
   int i;
   int Row, Col;

   printf("\nScale_Factor dup scale");
   printf("\n0.5 setlinewidth");
   printf("\nX_Trans Y_Trans translate\n");

   Row = 4;
   Col = 0;
   for(i=0;i<number_of_nodes;++i) {
      PS_print_person(indirect[i]);
      printf("\n%d %d Print_Person\n",Col,Row);
      Col++;
      if (Col>1){
	 Col = 0;
	 Row--;
	 if (Row < 0){
	    Row = 4;
	    printf("\nshowpage\n");
	    if (i != (number_of_nodes-1) )
	       printf("\nX_Trans Y_Trans translate\n");
         }
       }
   }

   if (Row != 4) printf("\nshowpage\n");
}

/***************************  end of routine print_tree  *********************/

PS_print_person(i)
int i;
{
   int nchild;
   int nwed;
   int j,k;
   PERSON_PTR ptr;

   printf("\n(%s %s)",c2upper(tree[i].name.other_names),
		      c2upper(tree[i].name.family_name));
   j = jndirect[i];
   if ( j < 10 ) 
      printf("\n(%1d)",j);
   else if ( j<100)
      printf("\n(%2d)",j);
   else if ( j<1000)
      printf("\n(%3d)",j);
   else 
      printf("\n(%4d)",j);
   if ( strcmp(tree[i].birth.date,UNKNOWN_STRING) == 0 )
        printf("\n(Unknown)");
   else printf("\n(%s, %d)",tree[i].birth.date,tree[i].birth.year);
   print_string(tree[i].birth.place);
   print_name(tree[i].father);
   print_name(tree[i].mother);
   if ( tree[i].number_of_marriages == 0 ) {
      printf("\n[");
      printf("\n[(Unwed) (Not applicable) (Not applicable)]");
      printf("\n]");
   }
   else{
      printf("\n[");
      for(nwed=1;nwed<=tree[i].number_of_marriages;nwed++)
         print_marriage(i, nwed);
      printf("\n]");
   }

   if ( strcmp(tree[i].death.date,UNKNOWN_STRING) == 0 )
        printf("\n(Unknown)");
   else if ( strcmp(tree[i].death.date,LIVING_STRING) == 0 )
      printf("\n(Living)");
   else printf("\n(%s, %d)",tree[i].death.date,
                                       tree[i].death.year);
   print_string(tree[i].death.place);

   printf("\n[");
   for(nchild=0;nchild<tree[i].number_of_children;++nchild){
      ptr = get_child_ptr(i,nchild);
      k = (int *)(ptr - &tree[0]);
      j = jndirect[k];
      if (j < 10) printf("\n(%s %1d)",ptr->name.other_names,j);
      else if (j < 100) printf("\n(%s %2d)",ptr->name.other_names,j);
      else if (j < 1000) printf("\n(%s %3d)",ptr->name.other_names,j);
      else printf("\n(%s %4d)",ptr->name.other_names,j);
   }
   printf("\n]");
}

/***************************  end of routine print_person  ******************/

print_marriage ( i, nwed )
int i, nwed;
{
   MARRIAGE *this_mar;
   PERSON_PTR pptr;
   int j;

   this_mar = get_marriage_ptr(i,nwed);
   if ( strcmp(this_mar->wedding.date,UNKNOWN_STRING) == 0 ){
        printf("\n[(Unknown)");
   }
   else printf("\n[(%s, %d)",this_mar->wedding.date,
                             this_mar->wedding.year);
   print_string(this_mar->wedding.place);

   pptr = this_mar->spouse;
   print_name(pptr);
   printf("]");
}

/**************************  end of routine print_name  *********************/   
print_string ( string )
STRING string;
{
      if ( string == NULL_STRING ) printf("\n(Unknown)"); 
      else printf("\n(%s)",string);
}

/**************************  end of routine print_string  *******************/   
print_name ( ptr )
PERSON_PTR ptr;
{
      int i,j;

      i = (int *)(ptr - &tree[0]);
      j = jndirect[i];
      if ( ptr == UNKNOWN_PERSON ) printf("\n(Unknown)");
      else if ( ptr == ALTERNATE_PERSON ) printf("\n(Unwed)");
      else if (j < 10) printf("\n(%s %s %1d)",ptr->name.other_names,
                                       c2upper(ptr->name.family_name),j);
      else if (j < 100) printf("\n(%s %s %2d)",ptr->name.other_names,
                                       c2upper(ptr->name.family_name),j);
      else if (j < 1000) printf("\n(%s %s %3d)",ptr->name.other_names,
                                       c2upper(ptr->name.family_name),j);
      else printf("\n(%s %s %4d)",ptr->name.other_names,
                                       c2upper(ptr->name.family_name),j);
}
   
/**************************  end of routine print_name  *********************/   
STRING c2upper(str1)
STRING str1;
{
   STRING str2;
   STRING stemp;
   int slen;
   
   slen = strlen(str1);
   if ( (str2=(STRING)malloc(slen+1)) != NULL_STRING ) {
      stemp = str2;
      while (*str1 != '\0') {
         *str2 = toupper(*str1);
         str1++; str2++;
      }
      *str2 = '\0';
      return stemp;
  }
  else
     return NULL_STRING;
}

/**************************  end of routine c2upper  ************************/   
