/* mathsubs.c - math operators for spin
 *
 *  5.Nov.87  jimmc  Initial definition
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include "spin.h"

static
SPbadbool(op)
char *op;
{
/* this routine is to catch and error which "should never happen" */
	SPescape("BadTokenType","non-list arg to %s",op);
	/* NOTREACHED */
}

int
sp_not(b)
int b;
{
	return (!b);
}

int
sp_and(l)
SPtoken *l;
{
	if (!l || l->type!=SPTokList) {
		SPbadbool("and");
		/* NOTREACHED */
	}
	for (l=l->value.l; l; l=l->next)
		if (SPbooleval(l)==0)
			return 0;
	return 1;
}

int
sp_or(l)
SPtoken *l;
{
	if (!l || l->type!=SPTokList) {
		SPbadbool("or");
		/* NOTREACHED */
	}
	for (l=l->value.l; l; l=l->next)
		if (SPbooleval(l)==1)
			return 1;
	return 0;
}

SPinitmath()
{
extern int SPbool();
	SPdeffunc("bool","iV",SPbool);
	SPdeffunc("not","ib",sp_not);
	SPdeffunc("and","iR",sp_and);
	SPdeffunc("or","iR",sp_or);
}

/* end */
