/* main.c - test module and sample main program for spin
 *
 * 17.Oct.87  jimmc  Initial definition
 *  4.Nov.87  jimmc  Add ieq, igr, streq
 */

#include <stdio.h>
#include <strings.h>
#include "xalloc.h"

/* #define MINSPIN */
/* define MINSPIN to get just the stripped down interpreter (in case
 * you are curious as to just how big it is).
 */

char *Progname, *rindex();

main(argc,argv)
int argc;
char *argv[];
{
int i,j;
char *execval;

	Progname=rindex(argv[0],'/');
	if (Progname) Progname++; else Progname=argv[0];

	m_init();
#ifndef MINSPIN
	SPinitsubs();
#endif
	for (i=1; i<argc; i++) {
		if (argv[i][0]=='-') for (j=1; j>0&&argv[i][j]; j++) {
			switch (argv[i][j]) {
			case 'e':
				execval = argv[++i];
				j = -1;
				break;
			default:	break;	/* just ignore it */
			}
		}
		/* ignore other stuff */
	}
	if (execval) { SPmainstring(execval); }
	SPmainfile(stdin);
	exit(0);
}

int
m_plus(a,b)
int a,b;
{
printf("add %d %d\n", a, b);
	return (a+b);
}

int
m_strlen(s)
char *s;
{
	if (!s) return NULL;
	return strlen(s);
}

char *
m_strcat(a,b)
char *a, *b;
{
char *r;

	r = XALLOC(char,strlen(a)+strlen(b)+1);
	strcpy(r,a);
	strcat(r,b);
	return r;
}

int
m_streq(a,b)
char *a,*b;
{
	return (strcmp(a,b)==0);
}

int
m_ieq(a,b)
int a,b;
{
	return (a==b);
}

int
m_igr(a,b)
int a,b;
{
	return (a>b);
}

m_init()
{
	SPdeffunc("plus","iii;summand addend addend",m_plus);
	SPdeffunc("strlen","iSN",m_strlen);
	SPdeffunc("strcat","sS\"foo\"S\"bar\"",m_strcat);
	SPdeffunc("streq","iss",m_streq);
	SPdeffunc("ieq","iii",m_ieq);
	SPdeffunc("igr","iii",m_igr);
}

/* end */
