/* contsubs.c - control structure subroutines for spin
 *
 * 16.Oct.87  jimmc  Initial definition
 * 21.Oct.87  jimmc  Add func and args stuff
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <stdio.h>
#include "xalloc.h"
#include "spin.h"
#include "exec.h"

struct funcargs {
	struct funcargs *up;
	int num;	/* number of args */
	SPtoken **val;	/* the args (pointer to array of pointers) */
	SPtoken *vallist;
};
struct funcargs *curargs;

extern SPtoken *SPexec();

SPtoken *
sp_if(test,truecode,falsecode)
int test;	/* the value to test */
SPtoken *truecode;	/* execute this if true */
SPtoken *falsecode;	/* execute this is false */
{
	if (test) {
		return SPexec(truecode);
	}
	else {
		return SPexec(falsecode);
	}
}

void
sp_exit(code)
int code;
{
/*** should allow programs to set up exit routines which are called
 * before the exit is actually done, or which may abort the exit.
 */
	exit(code);
}

char *
sp_priminfo(name)
char *name;
{
SPfuncinfo *finfo, *SPfindfunc();

	finfo = SPfindfunc(name);
	if (!finfo) return NIL;
	return finfo->args;
}

void
sp_define(name,list)
char *name;
SPtoken *list;
{
extern SPtoken *sp_fset();

	(void)sp_fset(name,list);
}

int	/* 1 if we found and executed the function */
sp_xexec(name,args,rval)
char *name;	/* name of the function to execute */
SPtoken *args;	/* the args to that function */
SPtoken *rval;	/* the token in which to return the value of the func */
{
SPtoken *fval, *sp_fget(), *rrval, *SPexec();
struct funcargs fargs;
int n;
SPtoken* tk;

	fval = sp_fget(name);	/* see if we have it */
	if (!fval) return 0;	/* not found */
	for (n=0,tk=args; tk; tk=tk->next) n++;	/* count args */
	fargs.num = n;
	if (n>0) fargs.val = XALLOC(SPtoken *,n);
	for (n=0,tk=args; tk; tk=tk->next) fargs.val[n++]=tk;
	fargs.vallist = NIL;
	fargs.up = curargs;
	curargs = &fargs;
	rrval = SPexec(fval);	/* execute the function (just a list!) */
		/*** not much argument checking here! */
	if (rrval) *rval = *rrval;
	else rval->type = SPTokNil;
	if (n>0) XFREE(fargs.val);
	curargs = fargs.up;
	return 1;		/* we got it OK */
}

SPtoken *
sp_argquote(argnum)
int argnum;
{
	if (!curargs || argnum<1 || argnum>curargs->num) return NIL;
	return curargs->val[argnum-1];
}

SPtoken *
sp_argeval(argnum)
int argnum;
{
	if (!curargs || argnum<1 || argnum>curargs->num) return NIL;
	return SPexec(curargs->val[argnum-1]);
}

static
sp_makevallist()
{
	ALLOCTOKEN(curargs->vallist)
	curargs->vallist->type = SPTokList;
	curargs->vallist->value.l = curargs->val[0];
	curargs->vallist->next = NIL;
}

SPtoken *
sp_arglistquote()
{
	if (!curargs) return NIL;
	if (!curargs->vallist) sp_makevallist();
	return curargs->vallist;
}

SPtoken *
sp_arglisteval()
{
SPtoken *list, *tk, *newtk, **prevtkp, *SPnewnil();

	if (!curargs) return NIL;
	if (!curargs->vallist) sp_makevallist();
	ALLOCTOKEN(list)
	list->type = SPTokList;
	list->next = NIL;
	prevtkp = &list->value.l;
	for (tk=curargs->vallist->value.l; tk; tk=tk->next) {
		newtk = SPexec(tk);
		if (!newtk) newtk = SPnewnil();
		*prevtkp = newtk;
		prevtkp = &newtk->next;
	}
	*prevtkp = NIL;
	return list;
}

SPinitcont()
{
	SPdeffunc("if","lbLL",sp_if);
	SPdeffunc("exit","vI0",sp_exit);
	SPdeffunc("quit","vI0",sp_exit);	/* synonym for exit */
	SPdeffunc("define","vnL",sp_define);
	SPdeffunc("argquote","li",sp_argquote);
	SPdeffunc("argeval","Li",sp_argeval);
	SPdeffunc("arglistquote","l",sp_arglistquote);
	SPdeffunc("arglisteval","L",sp_arglisteval);
	SPdeffunc("priminfo","sn",sp_priminfo);
	SPsetxexecp(sp_xexec);
}

/* end */
