/* @(#)sprintf.c	4.1 (Berkeley) 12/21/80 */
/* vsprintf from sprintf */
/* Created from bsd4.1 unix sprintf by Jim McBeath (jimmc) at SCI */
/* last edit 8-Jan-1988 16:31:45 by jimmc () */

#ifndef sun	/* sun now provides vsprintf as a standard function */

#include	<stdio.h>

/* vsprintf is like sprintf, but instead of passing a list of arguments,
 * the address of the list is passed.  This is typically used to implement
 * a function which accepts a format string and list of arguments of
 * its own.
 */

#ifndef USG
/* This ifdef should really be #ifdef BSD4_2, but that symbol doesn't exist!
 * If you are using USG, you should add -DUSG to the makefile.  If you are
 * using some other system in which _doprnt does not quite work like the one
 * in BSD4.2, you should change this line to #if 0.
 */

/* VARARGS2 */
char *vsprintf(str, fmt, argv)
char *str, *fmt;
{
	struct _iobuf _strbuf;

	_strbuf._flag = _IOWRT+_IOSTRG;
#ifdef sun
	_strbuf._ptr = (unsigned char *)str;
#else
	_strbuf._ptr = str;
#endif
	_strbuf._cnt = 32767;
	_doprnt(fmt, argv, &_strbuf);
	putc('\0', &_strbuf);
	return(str);
}

#else USG

/* this version of vsprintf is limited to a certain number of arguments,
 * and is still machine-dependant. (There is also an extermely slight
 * possibility of accessing non-existant memory on machines that grow the stack
 * upwards. (comments from Jim McBeath; routine by Ian Darwin.)

/* VARARGS2 */
char *vsprintf(str, fmt, argv)
char *str, *fmt;
char	**argv;
{
	sprintf(str, fmt,
	    argv[0], argv[1], argv[2], argv[3], argv[4]); /* up to 5 args */
		/* quasi-portable?? */
	return(str);
}

#endif USG

#else sun
#ifndef lint
static char dummy;	/* prevent "empty file" error messages */
#endif
#endif sun
