/* strings.c - some string manipulation routines
 *
 *  3.Feb.85  jimmc  Previous last edit
 * 26.Oct.87  jimmc  Collect numerous small routines into strings.c
 *  1.Jan.88  jimmc  Add freestr
 *  8.Jan.88  jimmc  Lint cleanup
 */

#include <ctype.h>
#include <strings.h>
#include "xalloc.h"

extern char end[];	/* for freestr */

/* Since index and rindex appear to be only in bsd4.2, these functions
 * will have to be distributed to assure portability.
 */
char *
index(str,ch)
char *str;		/* string to look through */
char ch;		/* char to look for */
{
	for ( ; *str; str++)
		if (*str==ch) return str;
	return 0;		/* not found */
}

char *
rindex(str,ch)
char *str;
char ch;
{
	char *ss;

	for (ss = str+strlen(str)-1; ss>=str; ss--)
		if (*str==ch) return ss;
	return 0;
}

char *
strcrep(str,cs,cd)	/* replace specified chars in a string */
char *str;
char cs;		/* char to look for */
char cd;		/* char to replace it with */
{
	char *ss;

	for (ss=str; *ss; ss++)
		if (*ss == cs) *ss = cd;
	return str;
}

/* strsav - make a copy of a string and return a pointer to it */
char *
strsav(ss)
char *ss;
{
	char *dd;

	dd = XALLOCM(char,strlen(ss)+1,"strsav");
	strcpy(dd,ss);		/* make a copy of the string */
	return dd;			/* return the copy */
}

strup(ss)		/* make a string all upper case */
char *ss;
{
	for ( ; *ss; ss++)
		if (islower(*ss)) *ss = toupper(*ss);
}

/* tprintf - do a printf into a temp buffer, then make a copy of the
 * string and return a pointer to the copy */
/* VARARGS1 */
char *
tprintf(fmt,args)
char *fmt;
{
	char buf[2050];

	vsprintf(buf,fmt,&args);	/* printf the string */
	return strsav(buf);		/* return a copy */
}

/* freestr - free up a string, but not if it's in program space or stack */
freestr(s)
char *s;
{
	if (s>=end && s<(char *)&s)
		free(s);
}

/* end */
