/* pagemap.h - definition for the pagemap functions
 * last edit 29-Jan-85 07:18:22 by jimmc (Jim McBeath)
 *
 * 29-Jan-85	Jim McBeath	convert to 7-char-distinct names
 * 18.Sep.87  jimmc  Move XALLOC into xalloc.h
 */

struct pagem {
	int rows;		/* number of rows (lines) on the page */
	int cols;		/* number of columns on the page */
	char **data;	/* pointer to an array of char pointers */
};

typedef struct pagem Pagem, *Pagemp;

/* data is stored in row major order; given the data pointer from the
 * above structure, data[x] points to row x, and data[x][y] points to
 * character y in row x.
 *
 * The number of columns is actually greater by two than the number
 * x->cols indicates; this is to leave space for a newline and a null
 * at the end.
 */

/* access macros */
#define pagPutc(pp,r,c,ch) ((pp)->data[r][c] = (ch))
#define pagGetc(pp,r,c)    ((pp)->data[r][c])

extern Pagemp pageInit();

/* end */
