/* misc.c - miscellaneous routines for geneal
 *
 * 17.Aug.87  jimmc  Initial definition
 *  4.Jan.88  jimmc  Add gdblist, annlist, LAll, LFieldMatch, LRefs
 *  8.Jan.88  jimmc  Add GSetOutput, GGetOutput, GFlushOutput, GSetSep, GGetSep
 *			gfamily, gfamilyh, gindivs; lint cleanup
 *  1.Mar.88  jimmc  Make GVersion return a string intead of printing it
 */

#include <stdio.h>
#include <strings.h>
#include "spin.h"
#include "geneal.h"

extern SPtoken *SPiarrtolist();

extern char *genealVersion;
extern int dataDebug;
extern int indexDebug;

extern char *strsave();
extern int olisttoiarr();

char outfpname[1024+1];
char *sepstr;

char Gflag[256];
int Gflagcount = sizeof(Gflag)/sizeof(Gflag[0]);

char Gflagr[256+1];
char *Label;

char *
GFlags(flags)
char *flags;
{
int i;
char *cp, *np;

	if (!flags) flags="";
	switch (flags[0]) {
	case '=':
		for (i=0; i<Gflagcount; i++) Gflag[i]=0;
		/* FALL THROUGH */
	case '+':
		for (cp=flags+1; *cp; cp++) {
			Gflag[*cp] = 1;
			switch (*cp) {	/* some special flags */
			case 'D': dataDebug=1; break;
			case 'I': indexDebug=1; break;
			default:  break;	/* do nothing */
			}
		}
		break;
	case '-':
		for (cp=flags+1; *cp; cp++) {
			Gflag[*cp] = 0;
			switch (*cp) {	/* some special flags */
			case 'D': dataDebug=0; break;
			case 'I': indexDebug=0; break;
			default:  break;	/* do nothing */
			}
		}
		break;
	case '?':
	case '\0':
		break;		/* just return the value */
	case 'h':
		GFlagsHelp();
		break;
	default:
		break;	/*** should output error message */
	}
	for (np=Gflagr, i=0; i<Gflagcount; i++)
		if (Gflag[i]) *np++ = i;
	*np = '\0';
	return Gflagr;
}

GFlagsHelp()
{
	printf("GFlags [+-=?][flagchars]\n");
	printf("a  enables output of addresses in family pages\n");
	printf("b  enables additional birth/death info in famtree\n");
	printf("m  includes spouses in famtrees\n");
printf("N  enables additional printing of index numbers (only if +n)\n");
	printf("n  enables printing of index numbers\n");
	printf("s  enables printing of sibling info in atrees\n");
	printf("t  include TNOTEs in famtree\n");
	printf("y  makes date sorts include year (by default they do not)\n");
	printf("D  debug data routines\n");
	printf("I  debug index routines\n");
}

char *
GVersion()
{
	return genealVersion;
}

int
GSetOutput(name)
char *name;
{
FILE *f;
int t;
char *mode;
char m[4];

	if (outfp!=stdout && outfp!=stderr) {
		t = ferror(outfp) || fclose(outfp);
		if (t) {
			warning("error closing previous output file %s",
					outfpname);
		}
	}
	t = 0;		/* assume no errors */
	if (strcmp(name,"stdout")==0)
		f = stdout;
	else if (strcmp(name,"stderr")==0)
		f = stderr;
	else {
		if (name[0]=='+') {
			name++;
			mode = "append";
		}
		else {
			mode = "write";
		}
		m[0] = mode[0];
		m[1] = 0;
		f = fopen(name,m);
		if (!f) {
			warning("can't open file %s for %s",name,mode);
			f = stdout;
			name = "stdout";
			t = 1;		/* error */
		}
	}
	strcpy(outfpname,name);		/* save for later messages */
	outfp = f;
	return t;		/* non-zero is error */
}

char *
GGetOutput()
{
	return outfpname;
}

GFlushOutput()
{
	fflush(outfp);
}

GSetSep(s)
char *s;		/* page separator string */
{
	if (sepstr) freestr(sepstr);
	sepstr = strsav(s);
}

char *
GGetSep()
{
	return sepstr;
}

GSetLabel(s)
char *s;
{
	if (Label) free(Label);
	Label = strsave(s);
}

char *
GGetLabel()
{
	return Label;
}

int
gfamily(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t =  family(ac,av);
	free((char *)av);
	return t;
}

int
gfamilyh(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t =  familyh(ac,av);
	free((char *)av);
	return t;
}

int
gindivs(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t =  indivs(ac,av);
	free((char *)av);
	return t;
}

int
gfamntree(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t = famntree(ac,av);
	free((char *)av);
	return t;
}

int
gannlist(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t = annlist(ac,av);
	free((char *)av);
	return t;
}

int
gbdlist(list)
SPtoken *list;
{
int ac;
int *av;
int t;

	ac = olisttoiarr(list,&av);
	t = bdlist(ac,av);
	free((char *)av);
	return t;
}

SPtoken *
LAnc(list,n)		/* ancestor list */
SPtoken *list;
int n;
{
int iac, *iav;
int ac, *av;
SPtoken *l;

	iac = olisttoiarr(list,&iav);
	ac = famalist(iac,iav,&av,n);
	l = SPiarrtolist(ac,av);
	free((char *)av);
	free((char *)iav);
	return l;
}

SPtoken *
LDesc(list,n)		/* descendant list */
SPtoken *list;
int n;
{
int iac, *iav;
int ac, *av;
SPtoken *l;

	iac = olisttoiarr(list,&iav);
	ac = famdlist(iac,iav,&av,n);
	l = SPiarrtolist(ac,av);
	free((char *)av);
	free((char *)iav);
	return l;
}

SPtoken *
LAll()			/* all entries in the database */
{
int ac, *av;
SPtoken *l;

	ac = alllist(&av);
	l = SPiarrtolist(ac,av);
	free((char *)av);
	return l;
}

SPtoken *
LFieldMatch(il,fname,fvalue)	/* match value of a field */
SPtoken *il;		/* the list of entry id's to check */
char *fname;		/* field name */
char *fvalue;		/* field value to look for */
{
int iac, *iav;
int ac, *av;
SPtoken *l;

	iac = olisttoiarr(il,&iav);
	ac = lfieldmatch(iac,iav,fname,fvalue,&av);
	l = SPiarrtolist(ac,av);
	free((char *)av);
	return l;
}

SPtoken *
LRefs(il,refname)	/* follow field references */
SPtoken *il;		/* the list of entry id's to check */
char *refname;		/* field name */
{
int iac, *iav;
int ac, *av;
SPtoken *l;

	iac = olisttoiarr(il,&iav);
	ac = lrefs(iac,iav,refname,&av);
	l = SPiarrtolist(ac,av);
	free((char *)av);
	return l;
}

int
GPfi(il)	/*print family or individual pages */
SPtoken *il;
{
int ac;
int *av;
int n;
int i,t;

	t = 0;
	ac = olisttoiarr(il,&av);
	for (i=0; i<ac; i++) {
		if (i>0) fprintf(outfp,sepstr);
		n = av[i];
		switch (fgtype(n)) {
		case 'I':
			t += indivs1(n);
			break;
		case 'F':
			t += family1(n);
			break;
		default:
			warning("bad record %d\n", n);
			break;
		}
	}
	return t;
}

/* end */
