/* indivs.v - print out short form info about an individual
 * Written by Jim McBeath (jimmc) at SCI
 *
 * Revision history:
 * 24-Jan-85	Jim McBeath	add include stdio
 * 27-Jan-85	Jim McBeath	use fgbslist
 * 18.Aug.87  jimmc  Use Gflag instead in indexes flag
 * 25.Aug.87  jimmc  Add buried info
 * 27.Oct.87  jimmc  General cleanup; call fggen to get GEN
 *  8.Jan.88  jimmc  Lint cleanup
 */

#include <stdio.h>
#include "geneal.h"
#include "xalloc.h"

int			/* 0 if OK */
indivs(ac,av)
int ac;
int *av;
{
	int i,t;

	t = 0;
	for (i=0; i<ac; i++) {
		if (i>0) fprintf(outfp,sepstr);
		t += indivs1(av[i]);
	}
	return t;
}

int			/* 0 if OK */
indivs1(n)
int n;			/* the person's ID number */
{
	char *ss;
	int pnum;	/* parent family number */
	int fnum;	/* father's number */
	int mnum;	/* mother's number */
	int mgnum;	/* marriage number */
	int snum;	/* spouse's number */
	int mhnum, mwnum;
	int i;		/* loop counter */
	int t;		/* random numbers and status */
	char *spousestr;
	int scount, slist[1000];
	char *gen;

	t = fgtype(n);
	if (t!='I') {
		warning("id %d is not an individual");
		return 1;
	}
	ss = fgfname(n);
	fprintf(outfp,"Name: %s\n", ss);
	ss = fgbirth(n);
	if (ss && *ss) fprintf(outfp,"%s\n", ss);
	ss = fgdeath(n);
	if (ss && *ss) fprintf(outfp,"%s\n", ss);
	ss = fgburied(n);
	if (ss && *ss) fprintf(outfp,"%s\n", ss);
	pnum = fgnum(n,"P");	/* get number of parent family */
	if (pnum>0) {			/* if we got a family */
		if (Gflag['n']) fprintf(outfp,"Parent family: %d\n", pnum);
		fnum = fgnum(pnum,"H");
		if (fnum>=0) {
			ss = fgfname(fnum);
			fprintf(outfp,"  Father: %s\n", ss);
			ss = fgbrtdeath(fnum);
			if (ss && *ss) fprintf(outfp,"  %s\n", ss);
		}
		mnum = fgnum(pnum,"W");
		if (mnum>=0) {
			ss = fgfname(mnum);
			fprintf(outfp,"  Mother: %s\n", ss);
			ss = fgbrtdeath(mnum);
			if (ss && *ss) fprintf(outfp,"  %s\n", ss);
		}
		ss = fgmarriage(pnum);
		if (ss) fprintf(outfp,"Parent's marriage: %s\n", ss);
		doiclist(pnum,"Sibling","Siblings",n);	/* do the siblings */
	}
	else {	/* no parent in this record */
		if (Gflag['n']) fprintf(outfp,"No parent family specified\n");
	}
	scount = fgbslist(n,slist);
	for (i=0; i<scount; i++) {	/* look at marriages */
		mgnum = slist[i];
		if (Gflag['n']) fprintf(outfp,"Marriage %d: %d\n", i, mgnum);
		mhnum = fgnum(mgnum,"H");	/* are we the husband? */
		mwnum = fgnum(mgnum,"W");	/*  or the wife */
		if (n!=mhnum && n!= mwnum)
warning("person %d claims marriage %d, but not vice-versa",
			    n, mgnum);
		if (n==mhnum) {
			snum = mwnum;
			spousestr = "Wife";
		}
		else {
			snum = mhnum;
			spousestr = "Husband";
		}
		if (snum>0) {
			ss = fgbname(snum);
			fprintf(outfp," %s: %s\n", spousestr, ss);
			ss = fgbrtdeath(snum);
			if (ss && *ss) fprintf(outfp," %s\n", ss);
		}
		ss = fgmarriage(mgnum);
		if (ss && *ss) fprintf(outfp," %s\n", ss);
		doiclist(mgnum,"Child","Children",-1);
	}
	gen = fggen(mgnum);
	if (gen && *gen) fprintf(outfp,"General:\n%s\n",gen);
	if (gen) XFREE(gen);
	return 0;			/* finished it all OK */
}

/*..........*/

doiclist(pnum,c1,cm,xn)		/* print out info about children */
int pnum;			/* the family to deal with */
char *c1;			/* string to use if one child */
char *cm;			/* string to use if more than one child */
int xn;		/* number of special sibling, or -1 if none */
{
	int i;
	int t;
	char *ss;
	int *clist;
	int cflag=0;

	t = fgclist(pnum,&clist);	/* get list of kids */
	if (t==0) {
		if (Gflag['n']) fprintf(outfp,"No %s specified\n", cm);
		if (xn>0)
warning("person %d claims parents %d but not vice-versa", xn, pnum);
	}
	else {
		if (t==1) fprintf(outfp,"  1 %s:\n",c1);
		else fprintf(outfp,"  %d %s:\n",t,cm);
		for (i=0; i<t; i++) {	/* for each child */
			if (clist[i]==xn) cflag++;
				/* note found special sibling */
			if (Gflag['n']) fprintf(outfp,"  %s %d:", c1, i);
			ss = fgtname(clist[i]);
			fprintf(outfp,"  %s%s\n",(clist[i]==xn?"*":""),ss);
			ss = fgbrtdeath(clist[i]);
			if (ss&&*ss) fprintf(outfp,"  %s\n", ss);
		}
		if (xn>0 && cflag==0)
warning("person %d claims parents %d but not vice-versa", xn, pnum);
	}
}

/* end */
