/* index.h - definitions for index
 * Written by Jim McBeath (jimmc) at SCI
 *
 * 19.Jan.85  jimmc  previous last edit
 *  8.Jan.88  jimmc  Use a union for tdata
 */

#define TBLSIZ 100

struct tblblock {
	int repnum;		/* number of indexes represented by this blk */
	int count;		/* count of entries in this level */
	union {
		long n;		/* integer values at the leaves */
		struct tblblock *p;	/* or else pointers to more blocks */
	} tdata[TBLSIZ];	/* the actual data for this level */
};

struct toplevel {
	int numlevs;		/* how deep the table is at it's deepest */
	struct tblblock *data;	/* pointer to the top level */
	int nzcount;		/* number of non-zero entries in the table */
};

/* end */
