.\" geneal.3
.TH GENEAL 1 "1 March 1988"
.SH NAME
geneal \- A genealogy program

.SH SYNOPSIS
.br
geneal [-e <commands>]

.SH DESCRIPTION
.I Geneal
is a program which reads a genealogy data file and produces output in
various formats.
Geneal
knows how to produce the following types of output:
.IP
Family pages (two formats).
.IP
Birthday and anniversary lists (sorted by month/day or by year/month/day).
.IP
Treepar-format output (for feeding to the treepar program to make
family history (ancestor), genealogy (descendant), or mixed charts).
.IP
Simple textual ancestor and descendant trees.
.LP
There are a number of flags which control options in the
output.
.LP
In addition to the output capabilities, geneal can be used to:
.IP
Browse through the data file
.IP
Check the consistency of references (e.g. parent/family/child) in the data file
.LP
Note that geneal is NOT used to maintain the data file.
The data file is a text file, and is maintained with any standard text editor.
.LP
Geneal uses the
.I spin
interpreter as a front end.
Control of geneal is accomplished by entering simple or complex commands
to the spin interpreter, which parses and executes them.
Whenever a geneal command is encountered, it is executed.
Given an understanding of the the spin interpreter and a list of the
geneal functions, the full capabilities of geneal are available.
The list of geneal functions is described below.

.SH SWITCHES
.LP
There is only one command line switch, which is the
.I -e
switch.
The argument to this switch is a fragment of spin code to be executed.
This code fragment can contain any valid commands.
When the execution is done, commands are then read from standard input.
Typically the argument to the -e switch is a compound command which
executes the desired function and then exits.
Here's an example of how the -e switch might be used:
.LP
% geneal -e '(GFlags "+btn")(PFamtree (LAnc 1092))(quit)'

.SH ENVIRONMENT
.LP
Geneal uses the following environment variables:
.TP
.B GENEALDAT
The path to the data file to use.
If no environment variable is specified, geneal tries to open
the file "geneal.dat".
.TP
.B GENEALLABEL
Sets the label to the value of this variable as if it were passed
to the function GSetLabel.
.SH KEY CONCEPTS
.LP
Geneal reads its data from a file which is
organized into records about individuals and families
(described in more detail below).
A family is defined to be a union of two individuals;
thus a family has exactly one father, one mother, and
zero or more children.
Note that a "family" in geneal is not necessarily the same
as a real-life family.
It is more appropriate to think of a geneal family merely as
a union between a man and a woman.
This may be a contractual union, such as a marriage, or a
de facto union which produced children, independent of whether
the couple was married.
.LP
Each record in the data file has associated with it a unique id
number (assigned manually by the creator of the file).
These numbers are used within the data file to refer to other records,
and within geneal functions.
ID numbers need not be ordered or consecutive.
.LP
Within each individual record may be references to family records
for spouse and parents.
Within each family record may be references to husband, wife, or
children.
These two record types may also refer to other record types
(address or reference), which may refer back to them.
.LP
Many of the geneal functions accept a list of record id numbers, and
perform an operation upon that set of records.
These lists are typically generated by a set of list generation and
manipulation functions, and then passed on to the output function.
Thus, for example, a single lineage from person A to person B
can be easily generated by taking
the intersection of the descendants of person A with the
ancestors of person B.
Since the spin interpreter maintains variables, fairly complex
combinations of id lists can be incrementally
created by taking various combinations
of lists.

.SH GENEAL FUNCTIONS
.LP
All of the geneal functions take as operands either integers, strings, or
lists of integers;
all functions return either an integer, a string, or a list of integers.
In the descriptions below, these three types of data are indicated by
the letters i, s, and L appended to the operand name.
A type of I means an optional integer argument.
.LP
List generation and manipulation routines:
.TP
.B LAll    
Returns list of all records in the data file.
.TP
.B LAnc idlist.L limit.I
Returns a list of all the ancestors of the given families or individuals
in the idlist.
If a limit is specified, it indicates the number of additional generations
to return (e.g "2" means return the input list plus all parents and
grandparents of anyone in that list).
If no limit is specified, all known ancestors are included.
.TP
.B LDesc idlist.L limit.I
Returns a list of all the descendants of the given families of individuals.
If a limit is specified, it indicates the number of additional generations
to return (e.g "2" means return the input list plus all children and
grandchildren of anyone in that list).
If no limit is specified, all known descendant are included.
.TP
.B LRefs idlist.L fieldname.s
Returns a list of all the id numbers referenced by the specified field
in all entries in the idlist.
For example, to find all the children of a group of families, the fieldname
would be "C".
.TP
.B LFieldMatch idlist.L fieldname.s matchvalue.s
Returns a list of all the id numbers in the input idlist which have a field
fieldname which matches the value given by fieldvalue.
Example: to get a list of all family records in the data file, use the
compound statement (LFieldMatch (LAll) T F).
.TP
.B LRange from.i to.i
Returns a list of all integers in the given range, inclusive.
.TP
.B LUnion a.L b.L
Returns a list which is the union of the two input lists.
.TP
.B LIntersect a.L b.L
Returns a list which is the intersection of the two input lists.
.TP
.B LAndNot a.L b.L
Returns a list which contains all the numbers in list a
which are not in list b.
.LP
Output routines:
.LP
The output of all of the 'P' output routines is directed to a file
controlled by the command GSetOutput.
By default, output goes to stdout.
For the family and individual outputs, each family or individual
is separated by a string which is controlled by the command GSetSep.
By default, this string is a form feed.
.TP
.B PFamily fam_id.L
Prints out a family page for each family in the list.
.TP
.B PFamilyh fam_id.L
Prints out another style of family page for each family in the list.
The information about each individual is spread horizontally across the
page.
.TP
.B PF fam_id.L
Equivalent to PFamily.
.TP
.B PIndiv ind_id.L
Prints out a data page for each individual in the list.
.TP
.B PI ind_id.L
Same as PIndiv.
.TP
.B P id.L
Prints out in PF format for each family, in PI format for each individual
in the list.
.TP
.B PAtree id.i
Prints out a simple textual ancestor tree for the specified individual
or family.
.TP
.B PDtree id.i
Prints out a simple textual descendant tree for the specified individual
or family.
.TP
.B PFamtree idlist.L
Prints out information in treepar format about all families or individuals
in the list.
This output format is referred to as a famtree.
The output is suitable for feeding directly into the treepar program
for producing charts.
If the idlist is generated with LAnc, this will give an ancestor chart;
if the idlist is generated with LDesc, this will give a descendant chart.
Other more complicated charts can be created by using the list manipulation
functions to generate different kinds of lists.
.TP
.B PBDlist idlist.L
Prints out a birthday list containing the birthdate and name of all the
individuals in the list.
The list is sorted by month and day if the y flag is not set, or
by year, month and day if the y flag is set.
.TP
.B PAnnlist idlist.L
Prints out an anniversary list containing the wedding
anniversary date and name of all the
families in the list.
The list is sorted by month and day if the y flag is not set, or
by year, month and day if the y flag is set.
.LP
Browsing routines:
.LP
All of the browsing functions accept an optional integer argument.
If this argument is supplied, it sets the internally maintained
"current" selection.
If the argument is not supplied, the internal current selection is
used as the argument.
All browsing functions return the id number of the current selection
as of the completion of that operation.
The browsing functions always output to the standard output,
independent of the GSetOutput command.
.TP
.B TCurrent id.I
Prints out a short information summary about the selection
and sets it to be the current selection.
.TP
.B TFamily id.I
Follows the parent reference to the family record for the selection,
prints out information about that family,
and sets it to be the current selection.
.TP
.B TFather id.I
Follows the husband reference of a family record or the husband
reference in the parent reference for an individual record,
prints out information about that individual,
and sets it to be the current selection.
.TP
.B TMother id.I
Follows the wife reference of a family record or the wife
reference in the parent reference for an individual record,
prints out information about that individual,
and sets it to be the current selection.
.LP
Miscellaneous:
.TP
.B GFlags newflags.s
Sets or clears flags, according to the first character in the string.
The return value is a string which is a list of the flags which are
set after the execution of the command.
If the first character is a "+", each remaining character in the string
is considered a flag character and is set.
If the first character is a "-", each remaining character in the string
is considered a flag character and is cleared.
If the first character is a "=",
all flags are cleared, then each remaining character in the string
is considered a flag character and is set.
If the first character is a "?", no operation is performed, but
the current list of flags which are set is returned as a string.
If the first character is a "h", a help message is printed.
A list of the flags and what they control is given below.
.TP
.B GSetLabel newlabel.s
Sets a string to be output on family pages and treepar trees.
.TP
.B GGetLabel
Returns the current value of the label.
.TP
.B GVersion
Returns a string which is
the current version number and date of the geneal program.
.TP
.B GSetOutput filename.s
Sets the output for all 'P' commands.
If a previous file was opened, it is flushed and closed first.
If the first character of the filename is a '+', the file will be
appended to.
If the filename is stdout or stderr, output goes to that stream
rather than to a file by that name.
The output is initially set to stdout.
Returns 1 if the file was opened successfully, 0 if not.
.TP
.B GGetOutput
Returns the filename of the last successful GSetOutput command.
.TP
.B GFlushOutput
Flushes the output file.
Does not close it.
.TP
.B GSetSep sepstr.s
Sets the separator string which is output between items (families or
individuals) in the 'P' output routines.
The separator string is initially set to a form-feed.
.TP
.B GGetSep
Returns the current separator string.
.TP
.B GConsist
Checks the consistency of the data file; verifies that families which
reference children are also referenced as parent family by the child, etc.
Prints out some statistics about the data it checked.

.SH FLAGS
.LP
There are a number of flags which control various output options.
These flags are set by the function GFlags, described above.
The current state of the flags can be examined with the command
(GFlags "?").
A help message describing what the flags do is printed by the command
(GFlags h).
The flags and their function are:
.TP
.B a
Enables the output of addresses in family pages and famtrees.
.TP
.B b
Enables the printing of additional birth and death information in famtrees.
.TP
.B m
Includes spouses in famtrees (useful for descendant trees).
.TP
.B n
Enables printing of index numbers in all P output routines.
.TP
.B N
Enables additional printing of index numbers in all P output routines.
.TP
.B s
Enables printing of sibling information in atrees (PAtree).
.TP
.B t
Includes TNOTEs (or TGENs) in famtrees.
.TP
.B y
Enables the inclusion of years when sorting dates in birthday
and anniversary lists.
When not set, these lists are sorted by month and day only.
.TP
.B D
A debug flag for low level data reading routines.
.TP
.B I
A debug flag for low level index routines.

.SH DATA FILE FORMAT
.LP
The format of the data file was designed to make it simple to maintain
file with any standard text editor.
.LP
Within a data file there are "records".  A record is a group of
associated information; it corresponds to a "row" in a relational
database system.  Within the record there are "fields", which
contain the individual items of data.  A field more or less
corresponds to a "column" in a relational system.  Each field
is composed of a "keyword" and a "value".  The keyword and the
value are separated by a colon (:); each field is on one line;
and each record is separated by one or more empty lines (that
means no spaces or tabs on the line either).
.LP
In addition to obeying the rules indicated above, note also the following:
.IP
Keywords consist only of alphanumeric characters, underscore,
and dot, with
the first character being alphanumeric.  Spaces and punctuation are
not allowed in keywords, and will cause that line to be considered
as a continuation line rather than a keyword line (see below).
.IP
There are no spaces before or after the colon which separates the
keyword and the value: a space before would cause the keyword not
to be recognized;
a space after would be seen as a part of the value.  Likewise
there are no trailing spaces on the values.
.IP
Not all records must have all fields.  If a record is missing a field,
its value will be null (i.e. ""), which can easily be tested for if desired.
.IP
Comment lines can be included by starting the line with a colon.
As many comment lines can be included as desired.
.LP
When editing a geneal data file, be very careful about spaces.  In particular,
be sure that the empty lines which separate the records really are empty,
and do not have even one space one them.  If one of these "empty" lines is
not really empty, it will cause the two records to be seen as one.
When a line has trailing blanks on it, a warning message is output
which gives the line number.
The error messages are also output to an error file, whose name is the
name of the data file with ".error" appended to it.
These errors should be fixed before
proceeding, since ignoring them may lead to the above problems.
Note that these error messages are only output when the index is
being generated, which normally happens only once after each time
the data file is edited (see the discussion about index files below).
.LP
It is sometimes desirable to have a value in a field which is more than
one line long.  This can be done.  The value in a field can be continued
onto the next line by starting that line with a plus mark (+).  This
character will not be a part of the value, but indicates to geneal
that the value on the preceding line is being continued on this line.
There are other ways to make continuation lines: if a line
is not blank, does not begin with a colon, and does not
begin with a keyword immediately followed by a colon,
then it is considered a continuation line.
This makes it easy to put in simple text in multiple lines, without the
necessity of adding the leading plus sign; however, for safety and clarity,
it is suggested that the leading plus sign always be used for continuation
lines.
.LP
If the first line of a record is a continuation line, that line (plus all
following continuation lines) is put into a variable called "unnamed",
where it can be checked by a program segment if desired.
.LP
Geneal maintains an index file for each data file which
it accesses, in order to improve performance on large (over 500 records)
database files.  If the database file is called "foo.db", then geneal
will create an index file called "foo.db.index" in the same
directory as the data file.  If the index file already exists and is newer
than the data file, then it is used; if the index file does not exist or
is older than the data file, then a new index file is created.
.LP
In some cases it may not be possible to create a new index file.  This is
not considered an error, geneal merely ignore the index file and scans
the data file to build its internal index list.  This is to allow people
to use databases in directories in which they might not have write
access.  Similarly, if there is an error creating a ".error" file,
that problem is silently ignored.
.LP
Geneal understands four different types of records: individuals,
families, addresses, and references.
The type of a record is indicated by the "T" field, which has the value
"I", "F", "A", or "R" for the known record types.
The remainder of the fields which are recognized by geneal depend on
what the record type is.

.SH GENERAL RECORD FIELDS
.LP
There are some fields which apply to all record types:
.TP
.B T
Type of the record, as described above
.TP
.B EDITED
Date the record was last edited, in the format dd-mmm-yyyy
(this is not currently used by geneal, but may be in the future)
.TP
.B SOURCE
Source for the information in this record (e.g. reference number)

.SH INDIVIDUAL RECORDS
.LP
The type code for an individual record is I.
.LP
Fields in an individual record:
.TP
.B LN
Last (born) name (family name)
.TP
.B LN.A
Adopted last name (typically through marriage)
.TP
.B FN
First name
.TP
.B MN
Middle names
.TP
.B NN
Nickname
.TP
.B PN
Prefix name (Dr., Lord, King, etc.)
.TP
.B SN
Suffix name (Jr., Sr., Esq., R.N., etc.)
.TP
.B SX
Sex (M or F)
.TP
.B B
Birthdate in the format dd-mmm-yyyy (e.g. 4-Jul-1776)
.TP
.B BP
Place of birth
.TP
.B D
Date of death in the same format
.TP
.B DP
Place of death
.TP
.B BUR
Burial place
.TP
.B P
Index number of parent's marriage
.TP
.B S
List of index numbers of marriages
.TP
.B ADDR
Record number of addr for this record
.TP
.B TNOTE
A note which can be output in family trees (may be multi-line)
.TP
.B GEN
General information of interest about that person.
.TP
.B TGEN
Things which are both TNOTE and GEN.
.TP
.B COM
Comments (these do not appear in family pages or trees).

.SH FAMILY RECORDS
.LP
The type code for an individual record is F.
.LP
A family record contains information about a marriage and its offsprings.
These fields are the same as for an Individual record:
TNOTE, GEN, TGEN, COM.
.LP
Fields in a family record:
.TP
.B N
Family name
.TP
.B H
Index number of husband
.TP
.B W
Index number of wife
.TP
.B M
Date of marriage
.TP
.B MD
Date of end of marriage
.TP
.B MP
Place of marriage
.TP
.B MDP
Place of end of marriage
.TP
.B C
Index number list of children from this marriage
.TP
.B ADDR
Record number of address for this record

.SH ADDRESS RECORDS
.LP
The type code for an individual record is A.
.LP
Fields in an address record:
.TP
.B WHO
Record number for the I or F record this addr applies to
.TP
.B ADDR
The address
.TP
.B PHONE
Telephone

.SH REFERENCE RECORDS
.LP
The type code for an individual record is R.
.LP
There are currently no fields defined in the reference record other than
the type field.
You can put whatever fields you like there, or make the entire record
a comment by starting each line with a colon.

.SH BUGS
.LP
There are lots and lots of memory leaks.
.LP
The only .A field which is supported is LN.A, and even there there
are sometimes formatting questions which arise when a person has
adopted multiple last names.
In particular, C.A and P.A are not supported; thus the data file can
represent adoption, but geneal can not do anything with it.
.LP
The support for complex trees is not adequate; it is difficult to
generate the lists for complex trees, and not possible to specify
different flags for different areas of the tree.
