/* geneal - manipulate family trees, etc.
 * Written by Jim McBeath (jimmc) at SCI
 *
 * Revision history:
 * 24-Jan-85	Jim McBeath	Use real dpoint instead of int for gendp.
 *				Add -C switch for consistency check.
 * v2.0 27-Jan-85 Jim McBeath	Add -a, -d, -V switches; add version string;
 *				add GENEALDAT environment var. check.
 * v2.1 29-Jan-85 Jim McBeath	7-char-distinct names
 * v2.2  2-Feb-85 Jim McBeath	Adopt the .A convention for adopted items.
 * v2.3 12-Feb-85 Jim McBeath	Include usage line in help message; change
 *				default filename to geneal.dat (suggestions
 *				of Ian Darwin)
 * v2.4  8-Mar-85 Jim McBeath	minor fixes in other modules
 * v2.5  2.Aug.87  jimmc  Modify -t switch to be suitable for famtree program
 * v2.6 13.Aug.87  jimmc  Add -T switch
 * v3.0 17.Aug.87  jimmc  Convert to genie interface
 * v3.1 28.Aug.87  jimmc  Add GENEALLABEL check
 * v3.2 17.Oct.87  jimmc  Convert to spin interface
 *      27.Oct.87  jimmc  Add outfp
 * v3.3  4.Jan.88  jimmc  Add Pfamilyh, PBDlist, PAnnlist, LRange, LAll,
 *				LFieldMatch, LRefs
 * v3.4  8.Jan.88  jimmc  Add GSetOutput, GGetOutput, GFlushOutput; modify
 *				remaining P output routines to output to outfp;
 *				add GSetSep, GGetSep; modify fampage output
 *				routines to accept list of id numbers;
 *				lint cleanup
 *      18.Jan.88  jimmc  Make LAnc, LDesc take input list args, plus limit
 *      19.Jan.88  jimmc  Clean up data file access stuff
 * v3.5  1.Mar.88  jimmc  Make GVersion return a string instead of printing it
 */
char *genealVersion="geneal v3.5 1-Mar-88";

#define MAIN

#include <stdio.h>
#include <ctype.h>
#include "spin.h"
#include "geneal.h"

extern char *rindex(), *getenv();
extern char *getData();

extern char *Label;

char *Progname;		/* name of the program */
char *defdatfile="geneal.dat";	/* default datafile name */
char *gendatfile=0;	/* filename for data file */
FILE *outfp=stdout;	/* stream to output to */

main(argc,argv)
int argc;
char *argv[];
{
char *estr;
char *s;
int i,j;
char *execval=NULL;

	Progname = rindex(argv[0],'/');
	if (Progname) Progname++; else Progname=argv[0];

	if (!gendatfile)	/* if he didn't specify a file... */
	{
		estr = getenv("GENEALDAT"); /* look for data file */
		if (estr && *estr) gendatfile=estr;
		else gendatfile=defdatfile;
	}
	fgsetfn(gendatfile);

	s = getenv("GENEALLABEL");
	if (s) Label = strsav(s);

	sepstr = strsav("\f");	/* default separator string */
	GSetOutput("stdout");

	applinit();
	SPinitsubs();

	for (i=1; i<argc; i++) {
		if (argv[i][0]=='-') for (j=1; j>0 && argv[i][j]; j++) {
			switch (argv[i][j]) {
			case 'e':	/* execute */
				if (argv[i][++j]) execval = argv[i]+j;
				else if (++i<argc) execval = argv[i];
				else fatalerr("not enough args for -e");
				j = -1;
				break;
			default:
				fatalerr("unknown switch %c", argv[i][j]);
			}
		}
		else {	/* not a switch */
			fatalerr("unknown argument %s", argv[i]);
		}
	}

	if (execval) { SPmainstring(execval); }
	SPmainfile(stdin);
	exit(0);
}

/*
 * arg types are:
 * i - integer
 * s - string
 * f - float (double)
 * L - application list
 */

#define BB(name,func,args) { \
	extern func(); \
	SPdeffunc("name",args,func); \
}

#define B(name,args) BB(name,name,args)

#define BBS(name,func,args) { \
	extern char *func(); \
	SPdeffunc("name",args,func); \
}

#define BS(name,args) BBS(name,name,args)

#define BBL(name,func,args) { \
	extern SPtoken *func(); \
	SPdeffunc("name",args,func); \
}

#define BL(name,args) BBL(name,name,args)

applinit()
{
/* routines to output data pages */
BB(PFamily,gfamily,"iV");
BB(PFamilyh,gfamilyh,"iV");	/* alternate format family page */
BB(PF,gfamily,"iV");	/* an alias */
BB(PIndiv,gindivs,"iV");
BB(PI,gindivs,"iV");	/* an alias */
BB(P,GPfi,"iV");		/* useful for browsing */
BB(PAtree,famatree,"ii");
BB(PDtree,famdtree,"ii");
BB(PFamtree,gfamntree,"iV");
BB(PBDlist,gbdlist,"iV");
BB(PAnnlist,gannlist,"iV");

/* DB dependent list generation and manipulation routines */
BL(LAll,"L");
BL(LAnc,"LVI-1");
BL(LDesc,"LVI-1");
BL(LRefs,"LVs");
BL(LFieldMatch,"LVss");

/* DB independent list manipulation routines */
BL(LRange,"Lii");
BL(LUnion,"LVV");
BL(LIntersect,"LVV");
BL(LAndNot,"LVV");

/* browsing commands */
B(TCurrent,"iI0");
B(TFamily,"iI0");
B(TFather,"iI0");
B(TMother,"iI0");

/* miscellaneous routines */
BS(GFlags,"ss");
B(GSetLabel,"vs");
BS(GGetLabel,"s");
BS(GVersion,"s");
B(GSetOutput,"is");
BS(GGetOutput,"s");
B(GFlushOutput,"v");
B(GSetSep,"vs");
BS(GGetSep,"s");
BB(GConsist,gconsist,"i");

/* for debugging */
BBS(fgstr,fgstr,"sis");
}

/* end */
