/* famntree.h - header file for famntree.c
 *
 * 12.Aug.87  jimmc  Initial definition
 * 31.Aug.87  jimmc  Add bd2, marr, headerlines
 *  8.Sep.87  jimmc  Add tnote
 * 18.Sep.87  jimmc  Moved XALLOC into xalloc.h; add addr in Famninfo
 * 21.Sep.87  jimmc  Use info[] instead of separate char* fields
 */

typedef struct _Fammemspouse {	/* one spouse for an individual */
	int id;		/* spouse id */
	int mid;	/* marriage (family) id */
#define FS_MD 0		/* marriage date/place */
#define FS_MTNOTE 1	/* a tnote on the marriage */
#define FS_NAME 2	/* spouse name */
#define FS_BD 3		/* birthdate */
#define FS_BD2 4	/* more bd stuff */
#define FS_BUR 5	/* buried */
#define FS_TNOTE 6	/* a tnote on the spouse */
#define FSSIZE 7	/* number of info items for a spouse record */
	char *info[FSSIZE];	/* info per above defines */
	int lines;	/* number of lines of text for this spouse */
	int cols;		/* number of cols in this fs */
	int connx;	/* position of connector for this spouse */
} Fammemspouse;

typedef struct _Fammember {	/* one individual */
	int id;		/* member id */
#define FM_NAME 0	/* member name */
#define FM_BD 1		/* birthdate/place */
#define FM_BD2 2	/* more bd stuff */
#define FM_BUR 3	/* buried */
#define FM_TNOTE 4	/* a tnote on the member */
#define FMSIZE 5
	char *info[FMSIZE];	/* info per above defines */
	int headerlines;	/* number of lines in the header part */
	int lines;	/* total number of lines of text for this member */
	int cols;		/* number of cols in this fm */
	int connx;	/* x position of connector for this member */
	int scount;	/* number of spouse entries */
	Fammemspouse *slist;	/* pointer to array of spouse entries */
} Fammember;

typedef struct _Famninfo {	/* a family or individual in a box */
	char *boxname;		/* for labeling and for connectors */
	int famid;		/* family id, even if box for individual */
	int fatherid;		/* id for father of that family */
	int motherid;		/* id for mother of that family */
#define FI_NAME 0	/* family name */
#define FI_MARR 1	/* marriage info */
#define FI_TNOTE 2	/* a tnote on the family */
#define FI_ADDR 3	/* address/phone for the family */
#define FISIZE 4	/* number of info items for a family info record */
	char *info[FISIZE];	/* info per above defines */
	int namelen;		/* length of name */
	int headerlines;	/* number of lines in the header part */
	int lines;		/* number of lines in this square */
	int cols;		/* number of cols in this square */
	int mcount;		/* number of members in this box */
	Fammember *mlist;	/* pointer to array of members */
} Famninfo;

/* end */
