/* famlists.c - routines to generate or modify lists of id numbers
 *
 * 18.Aug.87  jimmc  Initial defintion
 *  8.Jan.88  jimmc  Lint cleanup
 * 18.Jan.88  jimmc  Add limit to famalist, famdlist, make them take input list
 * 19.Jan.88  jimmc  Call fgenum instead of enumIndex
 */

#include <stdio.h>
#include "geneal.h"

static
famafsub(clist,famid,n)	/* add an individual */
Group *clist;
int famid;
int n;
{
int hid,wid;

	GroupSortedAdd(clist,famid);
	if (n==1) return;	/* return if this was the last one */
	hid = fgnum(famid,"H");
	wid = fgnum(famid,"W");
	if (hid>0) famaisub(clist,hid,n-1);
	if (wid>0) famaisub(clist,wid,n-1);
}

static
famaisub(clist,id,n)	/* add an individual */
Group *clist;
int id;
int n;
{
int famid;

	famid = fgnum(id,"P");
	if (famid<=0) {
		GroupSortedAdd(clist,id);
		return;
	}
	famafsub(clist,famid,n);
}

int
famalist(ac,av,pav,n)
int ac;
int *av;
int **pav;
int n;
{
int i;
int tac,rac,nac;
int *tav,*rav,*nav;

	rac = 0;
	rav = 0;
	for (i=0; i<ac; i++) {
		nac = famaidlist(av[i],&nav,n);
		tac = llunion(rac,rav,nac,nav,&tav);
		if (nav) free((char *)nav);
		rac = tac;
		rav = tav;
	}
	*pav = rav;
	return rac;
}

static
int			/* returns count of entries in list */
famaidlist(id,pav,n)	/* list of ancestors */
int id;			/* id to get list for */
int **pav;		/* where to return list pointer */
int n;			/* number of generations to do (-1 means no limit) */
{
Group clist;

	if (n>=0) n++;	/* total number of generations to include in list */
	clist.count = clist.alloc = 0;
	clist.n = 0;
	switch (fgtype(id)) {
	case 'I':
		famaisub(&clist,id,n);	/* enter recursive search */
		break;
	case 'F':
		famafsub(&clist,id,n);	/* enter recursive search */
		break;
	default:
		printf("bad type code for id %d\n",id);
		break;
	}
	if (clist.count) *pav = clist.n;
	return clist.count;
}

static
famdfsub(clist,famid,n)	/* add an individual */
Group *clist;
int famid;
int n;
{
int cnt, *ll;
int i;

	GroupSortedAdd(clist,famid);
	if (n==1) return;
	cnt = fglist(famid,"C",&ll);
	for (i=0; i<cnt; i++) {
		famdisub(clist,ll[i],n-1);
	}
	free((char *)ll);
}

static
famdisub(clist,id,n)	/* add an individual */
Group *clist;
int id;
int n;
{
int cnt, *ll;
int i;

	cnt = fglist(id,"S",&ll);
	for (i=0; i<cnt; i++) {
		famdfsub(clist,ll[i],n);
	}
	free((char *)ll);
}

int
famdlist(ac,av,pav,n)
int ac;
int *av;
int **pav;
int n;
{
int i;
int tac,rac,nac;
int *tav,*rav,*nav;

	rac = 0;
	rav = 0;
	for (i=0; i<ac; i++) {
		nac = famdidlist(av[i],&nav,n);
		tac = llunion(rac,rav,nac,nav,&tav);
		if (nav) free((char *)nav);
		rac = tac;
		rav = tav;
	}
	*pav = rav;
	return rac;
}

static
int			/* returns count of entries in list */
famdidlist(id,pav,n)	/* list of descendants */
int id;			/* id to get list for */
int **pav;		/* where to return list pointer */
int n;			/* number of generations to add */
{
Group clist;

	if (n>=0) n++;	/* total number of generations to include in list */
	clist.count = clist.alloc = 0;
	clist.n = 0;
	switch (fgtype(id)) {
	case 'I':
		GroupSortedAdd(&clist,id);
		famdisub(&clist,id,n);	/* enter recursive search */
		break;
	case 'F':
		famdfsub(&clist,id,n);	/* enter recursive search */
		break;
	default:
		printf("bad type code for id %d\n",id);
		break;
	}
	if (clist.count) *pav = clist.n;
	return clist.count;
}

static Group allclist;

/* ARGSUSED */
int
alladdone(id,v)
int id;		/* index number */
int v;		/* value (seek offset) */
{
	GroupSortedAdd(&allclist,id);
	return 0;
}

int			/* returns count of entries in list */
alllist(pav)		/* list of all indexes in the entire database */
int **pav;		/* where to return list pointer */
{
	allclist.count = 0;
	fgenum(alladdone);
	if (allclist.count) *pav = allclist.n;
	return allclist.count;
}

int
lfieldmatch(ac,av,fname,fvalue,pav)
int ac;			/* input list */
int *av;
char *fname;		/* name of field to check */
char *fvalue;		/* value to look for */
int **pav;		/* where to return list pointer */
{
	int i;
	Group clist;
	int id;
	char *dvalue;

	clist.count = clist.alloc = 0;
	clist.n = 0;
	for (i=0; i<ac; i++) {
		id = av[i];
		dvalue = fgstr(id,fname);
		if (strcmp(dvalue,fvalue)==0) {
			GroupSortedAdd(&clist,id);
		}
		freestr(dvalue);
	}
	if (clist.count) *pav = clist.n;
	return clist.count;
}

int
lrefs(ac,av,fname,pav)
int ac;			/* input list */
int *av;
char *fname;		/* name of field to follow references of */
int **pav;		/* where to return list pointer */
{
	int i,j;
	Group clist;
	int id;
	int n;
	int flist[1000];

	clist.count = clist.alloc = 0;
	clist.n = 0;
	for (i=0; i<ac; i++) {
		id = av[i];
		n = fgblist(id,fname,flist);
		for (j=0; j<n; j++)
			GroupSortedAdd(&clist,flist[j]);
	}
	if (clist.count) *pav = clist.n;
	return clist.count;
}

/* end */
