/* familyh.c - a more horizontal style of family page
 *
 *  4.Jan.88  jimmc  Initial definition
 *  8.Jan.88  jimmc  Allow lists of families to be printed
 */

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include "geneal.h"

#define TITLECOL 24
#define NAMECOL 4
#define COLFMT "    %-30s %-18s %s\n"

extern char *convertsdate();

int			/* 0 if OK */
familyh(ac,av)
int ac;
int *av;
{
	int i,t;

	t = 0;
	for (i=0; i<ac; i++) {
		if (i>0) fprintf(outfp,sepstr);
		t += familyh1(av[i]);
	}
	return t;
}

int			/* 0 if OK */
familyh1(famnum)
int famnum;			/* the family to give info about */
{
	int rtype;
	char *famname;
	int addrnum;
	char *addr, *phone, *gen;
	char mbuf[200];
	char *mdate, *mplace;
	int i, cnum, clist[1000];

	rtype = fgtype(famnum);
	if (rtype<=0) {
		warning("no such record number %d", famnum);
		return 1;
	}
	if (rtype!='F') {
		warning("record %d is not a family", famnum);
		return 1;
	}

	famname = fglhname(famnum);
	strup(famname);
	printindented(TITLECOL,famname);
	addrnum = fgnum(famnum,"ADDR");
	if (Gflag['a'] && addrnum>0) {	/* print address if known */
		addr = fgstr(addrnum,"ADDR");
		printindented(TITLECOL,addr);
		phone = fgstr(addrnum,"PHONE");
		printindented(TITLECOL,phone);
	}
	fprintf(outfp,"\n\n\n");

	fprintf(outfp,COLFMT,"NAME","BIRTHDATE","BIRTHPLACE");
	fprintf(outfp,COLFMT,"----","---------","----------");
	fprintf(outfp,"\n");

	famhp(fgnum(famnum,"H"),"");	/* print info about husband */

	mdate = fgstr(famnum,"M");
	mplace = fgstr(famnum,"MP");
	strcpy(mbuf,"MARRIED ");
	if (Gflag['n'])
		sprintf(mbuf+strlen(mbuf),"[%d] ",famnum);
	if (mdate && mdate[0])
		sprintf(mbuf+strlen(mbuf),"%s ",convertsdate(mdate));
	if (mplace && mplace[0])
		sprintf(mbuf+strlen(mbuf),"at %s ",mplace);
	strcat(mbuf,"to\n");
	printindented(NAMECOL,mbuf);

	famhp(fgnum(famnum,"W"),"N");

	gen = fggen(famnum);
	if (gen && gen[0]) {
		printindented(NAMECOL,gen);
		fprintf(outfp,"\n");
	}

	fprintf(outfp,"\n");

	cnum = fgbclist(famnum,clist);
	if (cnum==0) {
		;	/* do nothing here if no children */
	}
	else {
		printindented(NAMECOL,"Born to this union:\n");
		for (i=0; i<cnum; i++) {
			famhp(clist[i],"S");
			fprintf(outfp,"\n");
		}
	}
	return 0;
}

famhp(n,mflags)
int n;			/* individual to print info about */
char *mflags;		/* mode flags */
{
	char *name, *bdate, *bplace;
	char *deathdate, *deathplace, *buried, *gen;
	int scount, slist[1000];
	int mnum, mgnum, spnum;
	char *spname;
	char *mdate, *mplace;
	char sbuf[1000];

	if (index(mflags,'N'))	/* include last name */
		name = fgbname(n);
	else
		name = fgtname(n);
	bdate = fgstr(n,"B");
	bplace = fgstr(n,"BP");
	deathdate = fgstr(n,"D");
	deathplace = fgstr(n,"DP");
	buried = fgstr(n,"BUR");
	gen = fggen(n);
	fprintf(outfp,COLFMT,name,convertsdate(bdate),bplace);
	if (index(mflags,'S')) {	/* do spouse info */
		scount = fgbslist(n,slist);
		for (mnum=0; mnum<scount; mnum++) {
			mgnum = slist[mnum];
			spnum = fgspouse(mgnum,n);
			spname = fgbname(spnum);
			if (!spname || !spname[0]) spname="??";
			mdate = fgstr(mgnum,"M");
			mplace = fgstr(mgnum,"MP");
			strcpy(sbuf,"Married ");
			if (Gflag['n'])
				sprintf(sbuf+strlen(sbuf),"[%d] ",mgnum);
			if (mdate && mdate[0])
				sprintf(sbuf+strlen(sbuf),"%s ",
					convertsdate(mdate));
			sprintf(sbuf+strlen(sbuf),"to %s",spname);
			if (mplace && mplace[0])
				sprintf(sbuf+strlen(sbuf)," at %s",mplace);
			strcat(sbuf,".");
			printindented(NAMECOL,sbuf);
		}
	}
	if ((deathdate&&deathdate[0])||(deathplace&&deathplace[0])) {
		strcpy(sbuf,"Deceased ");
		if (deathdate&&deathdate[0])
			sprintf(sbuf+strlen(sbuf),"%s ",
				convertsdate(deathdate));
		if (deathplace&&deathplace[0])
			sprintf(sbuf+strlen(sbuf),"at %s",deathplace);
		strcat(sbuf,".");
		printindented(NAMECOL,sbuf);
	}
	if (buried && buried[0]) {
		sprintf(sbuf,"Buried at %s.", buried);
		printindented(NAMECOL,sbuf);
	}
	if (gen && gen[0]) printindented(NAMECOL,gen);
	fprintf(outfp,"\n");
}

/* end */
