/* famdtree.c - produce descendant trees
 * Written by Jim McBeath (jimmc) at SCI
 *
 * Revision history:
 * 27-Jan-85	Jim McBeath	Initial definition
 * 14-Feb-85	(Ian Darwin)	return error counter e instead of 0
 * 26.Oct.87  jimmc  Just a little cleaning up
 *  8.Jan.88  jimmc  Direct output to outfp instead of stdout
 */

#include <stdio.h>
#include "geneal.h"
#include "ctype.h"

#define INDENTOFFSET 4	/* how far each generation is offset */

int		/* 0 means OK */
famdtree(n)
int n;		/* the person to do a tree for */
{
	char *ss;
	char buf[1000];
	int t;

	switch ((t=fgtype(n))) {
	case 'I':
		ss = fgbname(n);
		strup(ss);		/* make it upper case */
		fprintf(outfp,"Descendant tree for %s\n\n", ss);
		break;
	case 'F':
		fgbstr(n,"N",buf);
		strup(buf);
		fprintf(outfp,"Descendant tree for family %s\n\n", buf);
		break;
	default:
		warning("bad record type %c for dtree\n", t);
		return 1;	/* error */
	}
	return famdtrr(n,0);	/* use recursive routine */
}

/*..........*/

int
famdtrr(n,indent)	/* recursive descendant routine */
int n;			/* the person or family to do */
int indent;		/* the indentation for this level */
{
	char buf[200];
	int ccount, clist[1000];
	int e;		/* error count */
	int i;
	char *ss, *bd, *md;
	int snum;

	e = 0;
	fgbstr(n,"T",buf);
	if (strcmp(buf,"F")==0) {	/* if a family */
		ccount = fgbclist(n,clist);	/* get list of children */
		for (i=0; i<ccount; i++)
			e += famdtrr(clist[i],indent);
	}
	else if (strcmp(buf,"I")==0) {	/* if an individual */
		ss = fgbname(n);	/* get his name */
		bd = fgbrtdeath(n);	/* and vital dates */
		fprintf(outfp,"%*s%s%s\n", indent, "", ss, bd );
		ccount = fgbslist(n,clist);	/* get list of marriages */
		for (i=0; i<ccount; i++) {	/* for each marriage */
			snum = fgnum(clist[i],"H");
			if (snum==n) snum = fgnum(clist[i],"W"); /* spouse */
			ss = fgbname(snum);	/* name of spouse */
			if (ss==0 || ss[0]==0) ss = "???";
			bd = fgbrtdeath(snum);
			if (bd==0) bd="";
			md = fgstr(clist[i],"M");	/* date of marriage */
			if (md==0) md="";
			fprintf(outfp,"%*s m: %s to %s%s\n",
				indent, "", md, ss, bd);
			e += famdtrr(clist[i],indent+INDENTOFFSET);
				/* do the family */
		}
	}
	else {
		warning("bad record type \"%s\" in record %d", buf, n);
		e++;		/* this counts as an error */
	}
	return e;
}

/* end */
