/* famatree.c - simple ancestor tree generator
 * Written by Jim McBeath (jimmc) at SCI
 *
 * Revision history:
 * 27-Jan-85	Jim McBeath	Initial defintion
 *  8-Mar-85	Jim McBeath	add return 0 in famatrr
 * 26.Oct.87  jimmc  A little cleanup
 *  8.Jan.88  jimmc  Direct output to outfp instead of stdout
 */

#include <stdio.h>
#include "geneal.h"

#define NOLINE 0	/* don't draw any line from this person */
#define LINEUP 1	/* draw a line up from this person */
#define LINEDN 2	/* draw a line down from this person */
#define INDENTOFFSET 3	/* distance each generation is offset */
#define LINEOFFSET (INDENTOFFSET-2)	/* distance to a line */

extern char Gflag[];

int lines[1000];	/* column number to draw lines in */
int linecount;		/* number of entries in lines */

int		/* 0 means OK */
famatree(n)
int n;		/* the person to make the tree for */
{
	char *ss;

	if (fgtype(n)!='I') {
		warning("record %d is not an individual", n);
		return 1;
	}
	ss = fgbname(n);
	strup(ss);
	fprintf(outfp,"Ancestor tree for %s\n\n", ss);
	linecount = 0;
	return famatrr(n,0,NOLINE);		/* use recursive routine */
}

/*..........*/

int			/* 0 means OK */
famatrr(n,indent,lineflag)	/* recursive tree printer */
int n;			/* the person to print the tree for */
int indent;		/* indentation for this person */
int lineflag;		/* flag to indicate a line from this person */
{
	int pp, ff, mm;
	int i;
	int ccount, clist[1000], cflag;

	pp = fgnum(n,"P");	/* get parents */
	if (pp>0) {
		ff = fgnum(pp,"H");		/* get father */
		if (ff>0) {	/* print father and ancestors */
			if (lineflag==LINEUP)
				lines[linecount++] = indent+LINEOFFSET;
			famatrr(ff,indent+INDENTOFFSET,LINEDN);
			if (lineflag==LINEUP) linecount--;
		}
	}
	if (Gflag['s']>1 && pp>0) {
			/* if he wants siblings and we have them... */
		ccount = fgbclist(pp,clist);	/* get a child list */
		cflag= -1;
		for (i=0; i<ccount; i++) {
			if (clist[i]==n) cflag=0;
			famatrp(clist[i],indent,lineflag,cflag);
			if (clist[i]==n) cflag=1;
		}
	}
	else {
		famatrp(n,indent,lineflag,0);
		/* print up info for this person */
	}
	if (pp>0) {
		mm = fgnum(pp,"W");		/* get mother */
		if (mm>0) {	/* print mother and ancestors */
			if (lineflag==LINEDN)
				lines[linecount++] = indent+LINEOFFSET;
			famatrr(mm,indent+INDENTOFFSET,LINEUP);
			if (lineflag==LINEDN) linecount--;
		}
	}
	return 0;	/* we have no error counter, so always return OK */
}

/*..........*/

famatrp(n,indent,lineflag,cflag)
int n;			/* the person of interest */
int indent;		/* indent level */
int lineflag;		/* flags to tell how to draw lines */
int cflag;		/* flag to indicate lines for siblings */
/* -1 means we are above the sibling in the ancestry */
/* 0 means this is the sibling in the ancestry */
/* 1 means we are below th sibling in the ancestry */
{
	int i;
	int lastl;
	char *ss, *bd;
	char *xstr;

	lastl = 0;	/* adjust the left/right position by changing this */
	for (i=0; i<linecount; i++) {		/* put in the extra lines */
		fprintf(outfp,"%*s|", lines[i]-lastl-1, "");
		lastl = lines[i];
	}
	fprintf(outfp,"%*s", indent-lastl, "");
	ss = fgbname(n);
	bd = fgbrtdeath(n);
	if (lineflag==NOLINE) {
		if (cflag==0) xstr="*-";
		else if (cflag== 1) xstr = " '";
		else xstr = " ,";
	}
	else if (lineflag==LINEUP) {
		if (cflag==0) xstr="\\-";
		else if (cflag== -1) xstr="|,";
		else xstr=" '";
	}
	else {	/* must be lineflag==LINEDN */
		if (cflag==0) xstr="/-";
		else if (cflag== 1) xstr="|'";
		else xstr=" ,";
	}
	fprintf(outfp,"%s%s%s\n", xstr, ss, bd);
		/* print info for this person */
}

/* end */
