/* errorman.c - general error handling routines
 * Written by Jim McBeath (jimmc) at SCI
 *
 * To use these routines, the user must have the variable Progname declared
 * elsewhere; also, these routines call vsprintf, so that must be included
 * in the load list.
 *
 *  8.Jan.88  jimmc  Lint cleanup
 */

#include <stdio.h>
#include <strings.h>

#define ERROR_EXIT 1
#define BSIZE 200

extern char *Progname;		/* user must set up the progname to use */

/*..........*/

/* VARARGS1 */
warning(s,args)
char *s;
{
char buf[BSIZE];

    vsprintf(buf,s,&args);
    fprintf(stderr,"%s: warning: %s\n", Progname, buf);
}

/*..........*/
/* hack... */
fferror(s) char *s; {fatalerr(s);}

/* VARARGS1 */
fatalerr(s,args)
char *s;
{
char buf[BSIZE];

    vsprintf(buf,s,&args);
    fprintf(stderr,"%s: fatal error: %s\n", Progname, buf);
    exit(ERROR_EXIT);
}

/*..........*/

/* VARARGS1 */
fatalperr(s,args)
char *s;
{
char buf[BSIZE];
char buf2[BSIZE];

    vsprintf(buf,s,&args);
    sprintf(buf2,"%s: fatal error: %s: ", Progname, buf);
    perror(buf2);
    exit(ERROR_EXIT);
}

/*..........*/

/* VARARGS1 */
errormsg(s,args)
char *s;
{
char buf[BSIZE];

    (void)vsprintf(buf,s,&args);
    fprintf(stderr,"%s: error: %s\n", Progname, buf);
}

/* end */
