/* datesort.c - routines dealing with sorting of dates
 *
 *  4.Jan.1988  jimmc  Initial definition
 */

#include <stdio.h>
#include "xalloc.h"
#include "geneal.h"

typedef struct _dsortinfo {
	char *sdate;
	int idate;
	char *pstr;
} Dsortinfo;

Dsortinfo *dsortinf;
int dsortalloc;
int dsortcount;

dsortinit()	/* init the sorting routine */
{
	Dsortinfo *p;
	int i;

	for (i=0; i<dsortcount; i++) {
		p = dsortinf + i;
		freestr(p->sdate);
	}
	dsortcount = 0;
}

dsortadd(sdate,pstr)
char *sdate;		/* the date to be sorted, in short format */
char *pstr;		/* the extra pointer to keep with the date */
{
	Dsortinfo *p;

	if (dsortcount>=dsortalloc) {	/* need more space */
		if (dsortalloc) dsortalloc *= 2;
		else dsortalloc = 15;
		if (dsortinf)
			dsortinf = XREALLOC(Dsortinfo,dsortinf,dsortalloc);
		else
			dsortinf = XALLOC(Dsortinfo,dsortalloc);
	}
	p = dsortinf+dsortcount;
	p->sdate = sdate;
	p->idate = sdatetoint(sdate);
	p->pstr = pstr;
	dsortcount++;
}

dsortadds(sdate,pstr)
char *sdate;
char *pstr;
{
	dsortadd(strsav(sdate),strsav(pstr));
}

int
dsortsort(a,b)
Dsortinfo *a, *b;
{
	if (Gflag['y'])		/* include year in date sorts */
		return a->idate - b->idate;
	else
		return (a->idate%10000) - (b->idate%10000);
}

int			/* returns 0 if no errors, else value of funcp() */
dsortenum(funcp)	/* enumerate the sorted list */
int (*funcp)();		/* function to call for each item */
		/* the function is called as funcp(sdate,pstr,idate) */
		/* if the function returns non-zero, the enumeration stops */
{
	Dsortinfo *p;
	int i,t;

	if (dsortcount<=0) return 0;
	qsort((char *)dsortinf,dsortcount,sizeof(Dsortinfo),dsortsort);
	for (i=0; i<dsortcount; i++) {
		p = dsortinf+i;
		t = (*funcp)(p->sdate,p->pstr,p->idate);
		if (t) break;
	}
	for (i=0; i<dsortcount; i++) {
		p = dsortinf+i;
		freestr(p->sdate);
	}
	dsortcount = 0;
	return t;
}

/* end */
