/* dates.c - some date manipulation routines
 *
 *  4.Jan.88  jimmc  Initial definition
 */

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include "geneal.h"

struct {
	char *sname;
	char *lname;
} montab[] = {
	{ "???", "???" },
	{ "Jan", "January" },
	{ "Feb", "February" },
	{ "Mar", "March" },
	{ "Apr", "April" },
	{ "May", "May" },
	{ "Jun", "June" },
	{ "Jul", "July" },
	{ "Aug", "August" },
	{ "Sep", "September" },
	{ "Oct", "October" },
	{ "Nov", "November" },
	{ "Dec", "December" },
};
int montabsize = sizeof(montab)/sizeof(montab[0]);

int		/* returns 1 to 12 for a month, 0 if not found */
findmonth(sname)
char *sname;
{
	int i;

	for (i=1; i<montabsize; i++) {
		if (strcmp(sname,montab[i].sname)==0)
			return i;
	}
	return 0;	/* not found */
}

int			/* (year*10000) + (month(jan==1)*100 + day(1-based) */
			/* or -1 if it can't make the conversion */
sdatetoint(olddate)	/*    for example, decimal 18760123 */
char *olddate;		/* in format "23-Jan-1876" */
{
	char *dash1, *dash2;
	int day, month, year;
	int n;

	if (!olddate || !olddate[0]) return -1;	/* nothing to convert */
	dash1 = index(olddate,'-');
	if (dash1) {
		dash2 = index(dash1+1,'-');
		if (dash2) {	/* all three of day, month, year given */
			if (strlen(dash2)!=sizeof("-1876")-1 ||
			    (dash2-dash1)!=sizeof("-Jan")-1 ||
			    (dash1-olddate>2)) {
				goto badformat;
			}
			day = atoi(olddate);
			year = atoi(dash2+1);
			*dash2 = 0;
			month = findmonth(dash1+1);
			*dash2 = '-';
		}
		else {	/* only two of day, month, year given */
			if (isdigit(olddate[0])) {	/* day given */
				if (dash1-olddate>2)
					goto badformat;
				day = atoi(olddate);
				if (isdigit(dash1[1])) { /* year given */
					if (strlen(dash1)!=sizeof("-1876")-1)
						goto badformat;
					year = atoi(dash1+1);
					month = 0;
				}
				else {
					if (strlen(dash1)!=sizeof("-Jan")-1)
						goto badformat;
					year = 0;
					month = findmonth(dash1+1);
				}
			}
			else {	/* must be month and year */
				if (strlen(dash1)!=sizeof("-1876")-1
				    || (dash1-olddate!=sizeof("Jan")-1))
					goto badformat;
				day = 0;
				year = atoi(dash1+1);
				*dash1 = 0;
				month = findmonth(olddate);
				*dash1 = '-';
			}
		}
	}
	else {		/* only one of day, month, year given */
		if (isdigit(olddate[0])) {
			n = atoi(olddate);
			if (n>=32) {	/* assume no years before 100 */
				if (strlen(olddate)!=sizeof("1876")-1)
					goto badformat;
				year = n;
				day = 0;
			}
			else {
				if (strlen(olddate)<2)
					goto badformat;
				year = n;
				year = 0;
				day = n;
			}
			month = 0;
		}
		else {		/* not a digit, must be a month */
			if (strlen(olddate)!=sizeof("Jan")-1)
				goto badformat;
			month = findmonth(olddate);
			year = 0;
			day = 0;
		}
	}
	return year*10000 + month*100 + day;

badformat:
	return -1;	/* don't understand it */
}

char *
convertidate(cnvdate)
int cnvdate;
{
	int year, month, day;
	char tbuf[100];

	year = cnvdate/10000;
	month = cnvdate/100 - year*100;
	day = cnvdate - month*100 - year*10000;

	tbuf[0] = 0;
	if (month)
		sprintf(tbuf,"%s",montab[month].lname);
	if (day) {
		if (tbuf[0])
			strcat(tbuf," ");
		sprintf(tbuf+strlen(tbuf),"%d",day);
	}
	if (year) {
		if (tbuf[0])
			strcat(tbuf,", ");
		sprintf(tbuf+strlen(tbuf),"%d",year);
	}
	return strsav(tbuf);
}

char *			/* allocated string in format "January 23, 1876" */
convertsdate(olddate)
char *olddate;		/* in format "23-Jan-1876" */
{
	int cnvdate;

	cnvdate = sdatetoint(olddate);
	if (cnvdate<=0)
		return strsav(olddate);
			/* can't figure it out, use what's there */
	return convertidate(cnvdate);
}

/* end */
