/* browse.c - functions to simplify browsing through the tree
 *
 * 18.Aug.87  jimmc  Initial definition
 *  8.Jan.88  jimmc  Lint cleanup
 */

#include <stdio.h>
#include "geneal.h"

int CurrentID;

static
printandfree(s)
char *s;
{
	printf("%s\n",s);
	freestr(s);
}

static
printIndiv(id)
int id;
{
int cnt, *slist;
int i;

	printandfree(fgbname(id));
	printandfree(fgbrtdeath(id));
	cnt = fgslist(id,&slist);
	if (cnt>0) printf("Marriages:\n");
	for (i=0; i<cnt; i++) {
		printf("[%d] ",slist[i]);
		printandfree(fgmarriage(slist[i]));
	}
	if (cnt) free((char *)slist);
}

static
printFamily(id)
int id;
{
int hid,wid;
int cnt, *clist;
int i;

	printf("Family [%d] ",id);
	printandfree(fgmarriage(id));
	hid = fgnum(id,"H");
	if (hid>0) printandfree(fgbname(hid));
	wid = fgnum(id,"W");
	if (wid>0) printandfree(fgbname(wid));
	cnt = fgclist(id,&clist);
	if (cnt>0) printf("Children:\n");
	for (i=0; i<cnt; i++) {
		printf("  ");
		printandfree(fgbname(clist[i]));
	}
	if (cnt) free((char *)clist);
}

static
printCurrent(id)
int id;
{
int oldflag;

	CurrentID = id;
	oldflag = Gflag['n'];
	Gflag['n'] = 1;
	switch (fgtype(id)) {
	case 'I':
		printIndiv(id);
		break;
	case 'F':
		printFamily(id);
		break;
	default:
		printf("bad type code for record %d\n",id);
		break;
	}
	Gflag['n'] = oldflag;
}

TCurrent(id)
int id;
{
	if (id<=0) id=CurrentID;
	if (id<=0) return 0;
	printCurrent(id);
	return id;
}

TFamily(id)
int id;
{
int t;

	if (id<=0) id=CurrentID;
	t = fgnum(id,"P");	/* get parent record */
	if (t<=0) return 0;
	printCurrent(t);
	return t;
}

TFather(id)
int id;
{
int t;

	if (id<=0) id=CurrentID;
	if (fgtype(id)=='I') id=fgnum(id,"P");
	if (id<=0) return 0;
	t = fgnum(id,"H");
	if (t<=0) return 0;
	printCurrent(t);
	return t;
}

TMother(id)
int id;
{
int t;

	if (id<=0) id=CurrentID;
	if (fgtype(id)=='I') id=fgnum(id,"P");
	if (id<=0) return 0;
	t = fgnum(id,"W");
	if (t<=0) return 0;
	printCurrent(t);
	return t;
}

/* end */
