/*=============================================================
 * table.c -- Hash table operations
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 29 Aug 93
 *   3.0.0 - 04 Sep 94    3.0.2 - 22 Dec 94
 *===========================================================*/

#include "standard.h"
#include "table.h"

/*======================
 * hash -- Hash function
 *====================*/
static INT hash (key)
STRING key;
{
	INT hval = 0;
	while (*key)
		hval += *key++;
	return hval %= MAXHASH;
}
/*================================
 * fndentry -- Find entry in table
 *==============================*/
static ENTRY fndentry (tab, key)
TABLE tab;
STRING key;
{
	ENTRY entry;
	entry = tab[hash(key)];
	while (entry) {
		if (eqstr(key, entry->ekey)) return entry;
		entry = entry->enext;
	}
	return NULL;
}
/*=============================
 * create_table -- Create table
 *===========================*/
TABLE create_table ()
{
	TABLE tab = (TABLE) stdalloc(MAXHASH*sizeof(ENTRY));
	INT i;
	for (i = 0; i < MAXHASH; i++)
		tab[i] = NULL;
	return tab;
}
/*======================================
 * insert_table -- Insert entry in table
 *====================================*/
insert_table (tab, key, val)
TABLE tab;
STRING key;
WORD val;
{
	ENTRY entry = fndentry(tab, key);
	if (entry)
		entry->evalue = val;
	else {
		INT hval = hash(key);
		entry = (ENTRY) stdalloc(sizeof(*entry));
		entry->ekey = key;
		entry->evalue = val;
		entry->enext = tab[hval];
		tab[hval] = entry;
	}
}
/*==========================================
 * delete_table -- Remove element from table
 *========================================*/
delete_table (tab, key)
TABLE tab;
STRING key;
{
	INT hval = hash(key);
	ENTRY prev = NULL;
	ENTRY this = tab[hval];
	while (this && nestr(key, this->ekey)) {
		prev = this;
		this = this->enext;
	}
	if (!this) return;
	if (prev)
		prev->enext = this->enext;
	else
		tab[hval] = this->enext;
	stdfree(this);
}
/*======================================
 * in_table() - Check for entry in table
 *====================================*/
BOOLEAN in_table (tab, key)
TABLE tab;
STRING key;
{
	return fndentry(tab, key) != NULL;
}
/*===============================
 * valueof -- Find value of entry
 *=============================*/
WORD valueof (tab, key)
TABLE tab;
STRING key;
{
	ENTRY entry;
	if (!key) return NULL;
	if (entry = fndentry(tab, key))
		return entry->evalue;
	else
		return NULL;
}
/*===================================
 * valueofbool -- Find value of entry
 *=================================*/
WORD valueofbool (tab, key, there)
TABLE tab;
STRING key;
BOOLEAN *there;
{
	ENTRY entry;
	*there = FALSE;
	if (!key) return NULL;
	if (entry = fndentry(tab, key)) {
		*there = TRUE;
		return entry->evalue;
	}
	return NULL;
}
/*=============================
 * remove_table -- Remove table
 *===========================*/
remove_table (tab, rcode)
TABLE tab;
INT rcode;
{
	INT i;
	ENTRY ent, nxt;
	if (!tab) return;
	for (i = 0; i < MAXHASH; i++) {
		nxt = tab[i];
		while (ent = nxt) {
			nxt = ent->enext;
			switch (rcode) {
			case FREEBOTH:
				stdfree(ent->evalue);
			case FREEKEY:
				stdfree(ent->ekey);
				break;
			case FREEVALUE:
				stdfree(ent->evalue);
				break;
			}
			stdfree(ent);
		}
	}
	stdfree(tab);
}
/*=================================================
 * traverse_table -- Traverse table doing something
 *===============================================*/
traverse_table (tab, tproc)
TABLE tab;
INT (*tproc)();
{
	INT i;
	ENTRY ent, nxt;
	if (!tab || !tproc) return;
	for (i = 0; i < MAXHASH; i++) {
		nxt = tab[i];
		while (ent = nxt) {
			nxt = ent->enext;
			(*tproc)(ent);
		}
	}
}
