/*==============================================================
 * screen.h -- Header file for curses-based screen I/O
 * Copyright (c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 20 Aug 93
 *   3.0.0 - 26 Jul 94    3.0.2 - 16 Dec 94
 *============================================================*/

#undef TRUE
#undef FALSE

#include <curses.h>

#ifndef TRUE
#	define TRUE 1
#	define FALSE 0
#endif

#define MAIN_SCREEN    1
#define ONE_PER_SCREEN 2
#define ONE_FAM_SCREEN 3
#define TWO_PER_SCREEN 4
#define TWO_FAM_SCREEN 5
#define PED_SCREEN     6
#define LIST_SCREEN    7
#define AUX_SCREEN     8

#ifndef ACS_TTEE
#	define ACS_TTEE '+'
#	define ACS_RTEE '+'
#	define ACS_LTEE '+'
#	define ACS_BTEE '+'
#	define ACS_VLINE '|'
#	define ACS_HLINE '-'
#endif

#ifdef BSD
#	undef ACS_TTEE
#	undef ACS_RTEE
#	undef ACS_LTEE
#	undef ACS_BTEE
#	undef ACS_VLINE
#	undef ACS_HLINE

#	define ACS_TTEE ' '
#	define ACS_RTEE ' '
#	define ACS_LTEE ' '
#	define ACS_BTEE ' '
#	define ACS_VLINE ' '
#	define ACS_HLINE '-'
#endif

/*=========================================
 * WINDOWs -- Main screen, menus and popups
 *=======================================*/
extern INT cur_screen;
extern WINDOW *main_win;
extern WINDOW *ask_win;
extern WINDOW *ask_msg_win;
extern WINDOW *choose_from_list_win;
extern WINDOW *start_menu_win;
extern WINDOW *add_menu_win;
extern WINDOW *del_menu_win;
extern WINDOW *utils_menu_win;
