/*==============================================================
 * interface.c -- Interface between LifeLines and BTREE database
 * Copyright(c) 1992-4 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 18 Aug 93
 *   3.0.0 - 20 Aug 94    3.0.2 - 09 Nov 94
 *============================================================*/

#include "standard.h"
#include "btree.h"

extern BTREE BTR;

/*=================================================
 * retrieve_record -- Retrieve record from database
 *===============================================*/
STRING retrieve_record (key, plen)
STRING key;
INT *plen;
{
	return (STRING) getrecord(BTR, str2rkey(key), plen);
}
/*=========================================
 * store_record -- Store record in database
 *=======================================*/
BOOLEAN store_record (key, rec, len)
STRING key, rec;
INT len;
{
	return addrecord (BTR, str2rkey(key), rec, len);
}
/*=========================================
 * retrieve_file -- Retrieve record to file
 *=======================================*/
BOOLEAN retrieve_file (key, file)
STRING key, file;
{
	return getfile(BTR, str2rkey(key), file);
}
/*=====================================
 * store_file -- Store record from file
 *===================================*/
BOOLEAN store_file (key, file)
STRING key, file;
{
	return addfile(BTR, str2rkey(key), file);
}
