/*=============================================================
 * editvtab.c -- Handle value tables in LifeLines
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   3.0.0 - 12 Sep 94    3.0.2 - 22 Dec 94
 *===========================================================*/

#include <sys/types.h>
#include <sys/stat.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"

extern STRING aredit;

/*==============================================
 * edit_valtab -- Edit value table from database
 *============================================*/
BOOLEAN edit_valtab (key, ptab, sep, ermsg)
STRING key;	/* value table key */
TABLE *ptab;	/* hash table for values */
INT sep;	/* separator char */
STRING ermsg;	/* error message */
{
	char scratch[50];
	TABLE tmptab = NULL;
	STRING msg;
	endwin();
	sprintf(scratch, "rm -f %s", editfile);
	system(scratch);
	retrieve_file(key, editfile);
	do_edit();
	while (TRUE) {
		tmptab = create_table();
		if (init_valtab_from_file(editfile, tmptab, sep, &msg)) {
			if (*ptab) remove_table(*ptab, DONTFREE);
			*ptab = tmptab;
			store_file(key, editfile);
			return TRUE;
		}
		if (ask_yes_or_no_msg(ermsg, aredit))
			do_edit();
		else {
			remove_table(tmptab, DONTFREE);
			return FALSE;
		}
		remove_table(tmptab, DONTFREE);
	}
}
