/*=============================================================
 * block.c -- Low level BTREE code dealing with BLOCKs
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    3.0.0 - 24 Sep 94
 *===========================================================*/

#include "standard.h"
#include "btree.h"

/*========================================
 * allocblock -- Allocate memory for BLOCK
 *======================================*/
BLOCK allocblock ()
{
	BLOCK block = (BLOCK) stdalloc(BUFLEN);
	itype(block) = BTBLOCKTYPE;
	iself(block) = 0;
	iparent(block) = 0;
	nkeys(block) = 0;
	return block;
}
/*=======================================
 * crtblock -- Create new BLOCK for BTREE
 *=====================================*/
BLOCK crtblock (btree)
BTREE btree;  /*btree handle*/
{
	BLOCK block;
	ASSERT(bwrite(btree));
	block = allocblock();
	iself(block) = btree->b_kfile.k_fkey;
	nextfkey(btree);
	rewind(bkfp(btree));
	if (fwrite(&bkfile(btree), sizeof(KEYFILE), 1, bkfp(btree)) != 1)
		FATAL();
	return block;
}
