/*=============================================================
 * miscutils.c -- Miscellaneous utility commands
 * Copyright(c) 1992-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 15 Aug 93
 *   2.3.6 - 12 Oct 93    3.0.0 - 05 May 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"

extern STRING btreepath;

/*======================================
 * key_util -- Return person's key value
 *====================================*/
key_util ()
{
	NODE indi = ask_for_indi("Whose key value do you want?", FALSE, FALSE);
	if (!indi) return;
	mprintf("%s - %s", rmvat(nxref(indi)), indi_to_name(indi, 70));
}
/*===================================================
 * who_is_he_she -- Find who person is from key value
 *=================================================*/
who_is_he_she ()
{
	STRING key, str, rec, ask_for_string();
	NODE indi;
	INT len;
	char nkey[100];

	key = ask_for_string("Please enter person's internal key value.",
	    "enter key:");
	if (!key || *key == 0) return;
	nkey[0] = 'I';
	if (*key == 'I')
		strcpy(nkey, key);
	else
		strcpy(&nkey[1], key);
	if (!(rec = retrieve_record(nkey, &len))) {
		mprintf("No one in database has key value %s.", key);
		return;
	}
	if (!(indi = string_to_node(rec))) {
		mprintf("No one in database has key value %s.", key);
		stdfree(rec);
		return;
	}
	if (!(str = indi_to_name(indi, 60)) || *str == 0) {
		mprintf("No one in database has key value %s.", key);
		stdfree(rec);
		return;
	}
	mprintf("%s - %s", key, str);
}
/*===========================================
 * show_database_stats -- Show database stats
 *=========================================*/
show_database_stats ()
{
	mprintf("Database `%s' contains (%dP, %dF, %dS, %dE, %dX) records.",
	    btreepath, num_indis(), num_fams(), num_sours(),
	    num_evens(), num_othrs());
}
