/*=============================================================
 * functab.c -- Table of builtin functions
 * Copyright(c) 1993-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 26 Sep 93
 *   2.3.6 - 01 Jan 94    3.0.0 - 11 Oct 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "interp.h"

extern WORD _add();
extern WORD _addnode();
extern WORD _addtoset();
extern WORD _alpha();
extern WORD _ancestorset();
extern WORD _and();
extern WORD _bapt();
extern WORD _birt();
extern WORD _buri();
extern WORD _capitalize();
extern WORD _card();
extern WORD _child();
extern WORD _childset();
extern WORD _choosechild();
extern WORD _choosefam();
extern WORD _chooseindi();
extern WORD _choosespouse();
extern WORD _choosesubset();
extern WORD _col();
extern WORD _concat();
extern WORD _copyfile();
extern WORD _createnode();
extern WORD _d();
extern WORD _database();
extern WORD _date();
extern WORD _dateformat();
extern WORD _dayformat();
extern WORD _deat();
extern WORD _decr();
extern WORD _deletefromset();
extern WORD _deletenode();
extern WORD _dequeue();
extern WORD _descendentset();
extern WORD _difference();
extern WORD _div();
extern WORD _empty();
extern WORD _eq();
extern WORD _exp();
extern WORD _extractdate();
extern WORD _extractnames();
extern WORD _extractplaces();
extern WORD _extracttokens();
extern WORD _fam();
extern WORD _fath();
extern WORD _female();
extern WORD _firstchild();
extern WORD _firstfam();
extern WORD _firstindi();
extern WORD _fnode();
extern WORD _fullname();
extern WORD _ge();
extern WORD _gengedcom();
extern WORD _getel();
extern WORD _getfam();
extern WORD _getindi();
extern WORD _getindiset();
extern WORD _getint();
extern WORD _getrecord();
extern WORD _getstr();
extern WORD _gettoday();
extern WORD _givens();
extern WORD _gt();
extern WORD _husband();
extern WORD _incr();
extern WORD _index();
extern WORD _indi();
extern WORD _indiset();
extern WORD _inode();
extern WORD _insert();
extern WORD _intersect();
extern WORD _key();
extern WORD _keysort();
extern WORD _lastchild();
extern WORD _le();
extern WORD _length();
extern WORD _lengthset();
extern WORD _linemode();
extern WORD _list();
extern WORD _lock();
extern WORD _long();
extern WORD _lookup();
extern WORD _lower();
extern WORD _lt();
extern WORD _male();
extern WORD _marr();
extern WORD _menuchoose();
extern WORD _mod();
extern WORD _monthformat();
extern WORD _moth();
extern WORD _mul();
extern WORD _name();
extern WORD _namesort();
extern WORD _nchildren();
extern WORD _ne();
extern WORD _neg();
extern WORD _newfile();
extern WORD _nextfam();
extern WORD _nextindi();
extern WORD _nextsib();
extern WORD _nfamilies();
extern WORD _nl();
extern WORD _not();
extern WORD _nspouses();
extern WORD _or();
extern WORD _ord();
extern WORD _outfile();
extern WORD _pagemode();
extern WORD _pageout();
extern WORD _parent();
extern WORD _parents();
extern WORD _parentset();
extern WORD _place();
extern WORD _pn();
extern WORD _pop();
extern WORD _pos();
extern WORD _prevfam();
extern WORD _previndi();
extern WORD _prevsib();
extern WORD _print();
extern WORD _push();
extern WORD _qt();
extern WORD _reference();
extern WORD _requeue();
extern WORD _rjustify();
extern WORD _roman();
extern WORD _row();
extern WORD _save();
extern WORD _savenode();
extern WORD _set();
extern WORD _setel();
extern WORD _sex();
extern WORD _short();
extern WORD _sibling();
extern WORD _siblingset();
extern WORD _soundex();
extern WORD _space();
extern WORD _spouseset();
extern WORD _stddate();
extern WORD _strcmp();
extern WORD _strlen();
extern WORD _strsoundex();
extern WORD _strtoint();
extern WORD _sub();
extern WORD _substring();
extern WORD _surname();
extern WORD _system();
extern WORD _table();
extern WORD _tag();
extern WORD _titl();
extern WORD _trim();
extern WORD _trimname();
extern WORD _union();
extern WORD _uniqueset();
extern WORD _unlock();
extern WORD _upper();
extern WORD _value();
extern WORD _valuesort();
extern WORD _wife();
extern WORD _xref();
extern WORD _year();

BUILTINS builtins[] = {
	"add",		2,	32,	_add,
	"addnode",	3,	3,	_addnode,
	"addtoset",	3,	3,	_addtoset,
	"alpha",	1,	1,	_alpha,
	"ancestorset",	1,	1,	_ancestorset,
	"and",		2,	32,	_and,
	"atoi",		1,	1,	_strtoint,
	"baptism",	1,	1,	_bapt,
	"birth",	1,	1,	_birt,
	"burial",	1,	1,	_buri,
	"capitalize",	1,	1,	_capitalize,
	"card",		1,	1,	_card,
	"child",	1,	1,	_child,
	"childset",	1,	1,	_childset,
	"choosechild",	1,	1,	_choosechild,
	"choosefam",	1,	1,	_choosefam,
	"chooseindi",	1,	1,	_chooseindi,
	"choosespouse",	1,	1,	_choosespouse,
	"choosesubset",	1,	1,	_choosesubset,
	"col",		1,	1,	_col,
	"concat",	2,	32,	_concat,
	"copyfile",	1,	1,	_copyfile,
	"createnode",	2,	2,	_createnode,
	"d",		1,	1,	_d,
	"database",	0,	0,	_database,
	"date",		1,	1,	_date,
	"dateformat",	1,	1,	_dateformat,
	"dayformat",	1,	1,	_dayformat,
	"death",	1,	1,	_deat,
	"decr",		1,	1,	_decr,
	"deletefromset",3,	3,	_deletefromset,
	"deletenode",	1,	1,	_deletenode,
	"dequeue",	1,	1,	_dequeue,
	"dereference",	1,	1,	_getrecord,
	"descendantset",1,	1,	_descendentset,
	"descendentset",1,	1,	_descendentset,
	"difference",	2,	2,	_difference,
	"div",		2,	2,	_div,
	"empty",	1,	1,	_empty,
	"enqueue",	2,	2,	_push,
	"eq",		2,	2,	_eq,
	"exp",		2,	2,	_exp,
	"extractdate",	4,	4,	_extractdate,
	"extractnames",	4,	4,	_extractnames,
	"extractplaces",3,	3,	_extractplaces,
	"extracttokens",4,	4,	_extracttokens,
	"fam",		1,	1,	_fam,
	"father",	1,	1,	_fath,
	"female",	1,	1,	_female,
	"firstchild",	1,	1,	_firstchild,
	"firstfam",	1,	1,	_firstfam,
	"firstindi",	1,	1,	_firstindi,
	"fnode",	1,	1,	_fnode,
	"fullname",	4,	4,	_fullname,
	"ge",		2,	2,	_ge,
	"gengedcom",	1,	1,	_gengedcom,
	"getel",	2,	2,	_getel,
	"getfam",	1,	1,	_getfam,
	"getindi",	1,	2,	_getindi,
	"getindimsg",	2,	2,	_getindi,
	"getindiset",	1,	2,	_getindiset,
	"getint",	1,	2,	_getint,
	"getintmsg",	2,	2,	_getint,
	"getrecord",	1,	1,	_getrecord,
	"getstr",	1,	2,	_getstr,
	"getstrmsg",	2,	2,	_getstr,
	"gettoday",	0,	0,	_gettoday,
	"givens",	1,	1,	_givens,
	"gt",		2,	2,	_gt,
	"husband",	1,	1,	_husband,
	"incr",		1,	1,	_incr,
	"index",	3,	3,	_index,
	"indi",		1,	1,	_indi,
	"indiset",	1,	1,	_indiset,
	"inode",	1,	1,	_inode,
	"insert",	3,	3,	_insert,
	"intersect",	2,	2,	_intersect,
	"key",		1,	2,	_key,
	"keysort",	1,	1,	_keysort,
	"lastchild",	1,	1,	_lastchild,
	"le",		2,	2,	_le,
	"length",	1,	1,	_length,
	"lengthset",	1,	1,	_lengthset,
	"linemode",	0,	0,	_linemode,
	"list",		1,	1,	_list,
	"lock",		1,	1,	_lock,
	"long",		1,	1,	_long,
	"lookup",	2,	2,	_lookup,
	"lower",	1,	1,	_lower,
	"lt",		2,	2,	_lt,
	"male",		1,	1,	_male,
	"marriage",	1,	1,	_marr,
	"menuchoose",	1,	2,	_menuchoose,
	"mod",		2,	2,	_mod,
	"monthformat",	1,	1,	_monthformat,
	"mother",	1,	1,	_moth,
	"mul",		2,	32,	_mul,
	"name",		1,	1,	_name,
	"namesort",	1,	1,	_namesort,
	"nchildren",	1,	1,	_nchildren,
	"ne",		2,	2,	_ne,
	"neg",		1,	1,	_neg,
	"newfile",	2,	2,	_newfile,
	"nextfam",	1,	1,	_nextfam,
	"nextindi",	1,	1,	_nextindi,
	"nextsib",	1,	1,	_nextsib,
	"nfamilies",	1,	1,	_nfamilies,
	"nl",		0,	0,	_nl,
	"not",		1,	1,	_not,
	"nspouses",	1,	1,	_nspouses,
	"or",		2,	32,	_or,
	"ord",		1,	1,	_ord,
	"outfile",	0,	0,	_outfile,
	"pagemode",	2,	2,	_pagemode,
	"pageout",	0,	0,	_pageout,
	"parent",	1,	1,	_parent,
	"parents",	1,	1,	_parents,
	"parentset",	1,	1,	_parentset,
	"place",	1,	1,	_place,
	"pn",		2,	2,	_pn,
	"pop",		1,	1,	_pop,
	"pos",		2,	2,	_pos,
	"prevfam",	1,	1,	_prevfam,
	"previndi",	1,	1,	_previndi,
	"prevsib",	1,	1,	_prevsib,
	"print",	1,	32,	_print,
	"push",		2,	2,	_push,
	"qt",		0,	0,	_qt,
	"reference",	1,	1,	_reference,
	"requeue",	2,	2,	_requeue,
	"rjustify",	2,	2,	_rjustify,
	"roman",	1,	1,	_roman,
	"row",		1,	1,	_row,
	"save",		1,	1,	_save,
	"savenode",	1,	1,	_savenode,
	"set",		2,	2,	_set,
	"setel",	3,	3,	_setel,
	"sex",		1,	1,	_sex,
	"short",	1,	1,	_short,
	"sibling",	1,	1,	_sibling,
	"siblingset",	1,	1,	_siblingset,
	"soundex",	1,	1,	_soundex,
	"sp",		0,	0,	_space,
	"spouseset",	1,	1,	_spouseset,
	"stddate",	1,	1,	_stddate,
	"strcmp",	2,	2,	_strcmp,
	"strconcat",	2,	32,	_concat,
	"strlen",	1,	1,	_strlen,
	"strsave",	1,	1,	_save,
	"strsoundex",	1,	1,	_strsoundex,
	"strtoint",	1,	1,	_strtoint,
	"sub",		2,	2,	_sub,
	"substring",	3,	3,	_substring,
	"surname",	1,	1,	_surname,
	"system",	1,	1,	_system,
	"table",	1,	1,	_table,
	"tag",		1,	1,	_tag,
	"title",	1,	1,	_titl,
	"trim",		2,	2,	_trim,
	"trimname",	2,	2,	_trimname,
	"union",	2,	2,	_union,
	"uniqueset",	1,	1,	_uniqueset,
	"unlock",	1,	1,	_unlock,
	"upper",	1,	1,	_upper,
	"value",	1,	1,	_value,
	"valuesort",	1,	1,	_valuesort,
	"wife",		1,	1,	_wife,
	"xref",		1,	1,	_xref,
	"year",		1,	1,	_year,
};
INT nobuiltins = 169;
#if 0
	"addnode",	3,	3,	_addnode,
	"alpha",	1,	1,	_alpha,
	"atoi",		1,	1,	_strtoint,
	"baptism",	1,	1,	_bapt,
	"birth",	1,	1,	_birt,
	"burial",	1,	1,	_buri,
	"capitalize",	1,	1,	_capitalize,
	"card",		1,	1,	_card,
	"choosechild",	1,	1,	_choosechild,
	"choosefam",	1,	1,	_choosefam,
	"chooseindi",	1,	1,	_chooseindi,
	"choosespouse",	1,	1,	_choosespouse,
	"choosesubset",	1,	1,	_choosesubset,
	"col",		1,	1,	_col,
	"concat",	2,	32,	_concat,
	"copyfile",	1,	1,	_copyfile,
	"createnode",	2,	2,	_createnode,
	"d",		1,	1,	_d,
	"database",	0,	0,	_database,
	"date",		1,	1,	_date,
	"dateformat",	1,	1,	_dateformat,
	"dayformat",	1,	1,	_dayformat,
	"death",	1,	1,	_deat,
	"decr",		1,	1,	_decr,
	"deletenode",	1,	1,	_deletenode,
	"dereference",	1,	1,	_getrecord,
	"empty",	1,	1,	_empty,
	"exp",		2,	2,	_exp,
	"extractdate",	4,	4,	_extractdate,
	"extractnames",	4,	4,	_extractnames,
	"extractplaces",3,	3,	_extractplaces,
	"extracttokens",4,	4,	_extracttokens,
	"fam",		1,	1,	_fam,
	"father",	1,	1,	_fath,
	"female",	1,	1,	_female,
	"firstchild",	1,	1,	_firstchild,
	"firstfam",	1,	1,	_firstfam,
	"firstindi",	1,	1,	_firstindi,
	"fnode",	1,	1,	_fnode,
	"fullname",	4,	4,	_fullname,
	"gengedcom",	1,	1,	_gengedcom,
	"getfam",	1,	1,	_getfam,
	"getindi",	1,	2,	_getindi,
	"getindimsg",	2,	2,	_getindi,
	"getindiset",	1,	2,	_getindiset,
	"getint",	1,	2,	_getint,
	"getintmsg",	2,	2,	_getint,
	"getrecord",	1,	1,	_getrecord,
	"getstr",	1,	2,	_getstr,
	"getstrmsg",	2,	2,	_getstr,
	"gettoday",	0,	0,	_gettoday,
	"givens",	1,	1,	_givens,
	"husband",	1,	1,	_husband,
	"incr",		1,	1,	_incr,
	"index",	3,	3,	_index,
	"indi",		1,	1,	_indi,
	"inode",	1,	1,	_inode,
	"key",		1,	2,	_key,
	"keysort",	1,	1,	_keysort,
	"lastchild",	1,	1,	_lastchild,
	"length",	1,	1,	_length,
	"linemode",	0,	0,	_linemode,
	"lock",		1,	1,	_lock,
	"long",		1,	1,	_long,
	"lower",	1,	1,	_lower,
	"male",		1,	1,	_male,
	"marriage",	1,	1,	_marr,
	"menuchoose",	1,	2,	_menuchoose,
	"monthformat",	1,	1,	_monthformat,
	"mother",	1,	1,	_moth,
	"name",		1,	1,	_name,
	"namesort",	1,	1,	_namesort,
	"nchildren",	1,	1,	_nchildren,
	"newfile",	2,	2,	_newfile,
	"nextfam",	1,	1,	_nextfam,
	"nextindi",	1,	1,	_nextindi,
	"nextsib",	1,	1,	_nextsib,
	"nfamilies",	1,	1,	_nfamilies,
	"nl",		0,	0,	_nl,
	"nspouses",	1,	1,	_nspouses,
	"ord",		1,	1,	_ord,
	"outfile",	0,	0,	_outfile,
	"pagemode",	2,	2,	_pagemode,
	"pageout",	0,	0,	_pageout,
	"parents",	1,	1,	_parents,
	"place",	1,	1,	_place,
	"pn",		2,	2,	_pn,
	"pos",		2,	2,	_pos,
	"prevfam",	1,	1,	_prevfam,
	"previndi",	1,	1,	_previndi,
	"prevsib",	1,	1,	_prevsib,
	"print",	1,	32,	_print,
	"qt",		0,	0,	_qt,
	"reference",	1,	1,	_reference,
	"rjustify",	2,	2,	_rjustify,
	"roman",	1,	1,	_roman,
	"row",		1,	1,	_row,
	"save",		1,	1,	_save,
	"savenode",	1,	1,	_savenode,
	"set",		2,	2,	_set,
	"sex",		1,	1,	_sex,
	"short",	1,	1,	_short,
	"soundex",	1,	1,	_soundex,
	"sp",		0,	0,	_space,
	"stddate",	1,	1,	_stddate,
	"strcmp",	2,	2,	_strcmp,
	"strconcat",	2,	32,	_concat,
	"strlen",	1,	1,	_strlen,
	"strsave",	1,	1,	_save,
	"strsoundex",	1,	1,	_strsoundex,
	"strtoint",	1,	1,	_strtoint,
	"substring",	3,	3,	_substring,
	"surname",	1,	1,	_surname,
	"system",	1,	1,	_system,
	"title",	1,	1,	_titl,
	"trim",		2,	2,	_trim,
	"trimname",	2,	2,	_trimname,
	"uniqueset",	1,	1,	_uniqueset,
	"unlock",	1,	1,	_unlock,
	"upper",	1,	1,	_upper,
	"valuesort",	1,	1,	_valuesort,
	"wife",		1,	1,	_wife,
	"year",		1,	1,	_year,

Arithmetic, Relational and Logical:
	add:2-32  sub:2  mul:2-32  div:2  mod:2  neg:1
	eq:2  ne:2  lt:2  le:2  gt:2  ge:2
	and:2-32  or:2-32  not:1
GEDCOM line accessors
	tag:1  value:1  xref:1  child:1  parent:1  sibling:1
Table data type
	table:1  insert:3  lookup:2
List/Array data type
	list:1  getel:2  setel:3  push:2  pop:1  enqueue:2*
	dequeue:1  requeue:2
	*enqueue==push
Person set data type
	indiset:1  addtoset:3  parentset:1  childset:1  spouseset:1
	siblingset:1  ancestorset:1  descendantset:1  descendentset:1
	union:2  intersect:2  difference:2  deletefromset:3  lengthset:3
#endif
