/*=============================================================
 * spltjoin.c -- Splits and joins persons and families
 * Copyright(c) 1993-94 by T.T. Wetmore IV; all rights reserved
 *   3.0.0 - 16 May 94
 *===========================================================*/

#include "standard.h"
#include "table.h"
#include "gedcom.h"

/*======================================
 * split_indi -- Split person into parts
 *====================================*/
split_indi (indi, pname, psex, pbody, pfamc, pfams)
NODE indi, *pname, *psex, *pbody, *pfamc, *pfams;
{
	NODE name, lnam, sex, body, famc, fams, last;
	NODE lfmc, lfms, prev, node;
	ASSERT(eqstr("INDI", ntag(indi)));
	name = sex = body = famc = fams = last = lfms = lfmc = lnam = NULL;
	node = nchild(indi);
	nchild(indi) = NULL;
	while (node) {
		STRING tag = ntag(node);
		if (eqstr("NAME", tag)) {
			if (!name)
				name = lnam = node;
			else
				lnam = nsibling(lnam) = node;
		} else if (!sex && eqstr("SEX", tag)) {
			sex = node;
		} else if (eqstr("FAMC", tag)) {
			if (!famc)
				famc = lfmc = node;
			else
				lfmc = nsibling(lfmc) = node;
 		} else if (eqstr("FAMS", tag)) {
			if (!fams)
				fams = lfms = node;
			else
				lfms = nsibling(lfms) = node;
		} else {
			if (!body)
				body = last = node;
			else
				last = nsibling(last) = node;
		}
		prev = node;
		node = nsibling(node);
		nsibling(prev) = NULL;
	}
	*pname = name;
	*psex = sex;
	*pbody = body;
	*pfamc = famc;
	*pfams = fams;
}
/*====================================
 * join_indi -- Join person from parts
 *==================================*/
join_indi (indi, name, sex, body, famc, fams)
NODE indi, name, sex, body, famc, fams;
{
	NODE node;
	ASSERT(indi && eqstr("INDI", ntag(indi)));
	ASSERT(name && eqstr("NAME", ntag(name)));
	nchild(indi) = node = name;
	while (nsibling(node))
		node = nsibling(node);
	if (sex) node = nsibling(node) = sex;
	if (body) {
		node = nsibling(node) = body;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (famc) {
		node = nsibling(node) = famc;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (fams) nsibling(node) = fams;
}
/*=======================================
 * split_fam -- Split a family into parts
 *=====================================*/
split_fam (fam, phusb, pwife, pchil, prest)
NODE fam, *phusb, *pwife, *pchil, *prest;
{
	NODE node, rest, last, husb, lhsb;
	NODE wife, lwfe, chil, lchl, prev;
	STRING tag;

	rest = last = husb = wife = chil = lchl = lhsb = lwfe = NULL;
	prev = NULL;
	node = nchild(fam);
	nchild(fam) = NULL;
	while (node) {
		tag = ntag(node);
		if (eqstr("HUSB", tag))
			if (husb)
				lhsb = nsibling(lhsb) = node;
			else
				husb = lhsb = node;
		else if (eqstr("WIFE", tag))
			if (wife)
				lwfe = nsibling(lwfe) = node;
			else
				wife = lwfe = node;
		else if (eqstr("CHIL", tag)) {
			if (chil)
				lchl = nsibling(lchl) = node;
			else
				chil = lchl = node;
		} else if (rest)
			last = nsibling(last) = node;
		else
			last = rest = node;
		prev = node;
		node = nsibling(node);
		nsibling(prev) = NULL;
	}
	*phusb = husb;
	*pwife = wife;
	*pchil = chil;
	*prest = rest;
}
/*===================================
 * join_fam -- Join family from parts
 *=================================*/
join_fam (fam, husb, wife, chil, rest)
NODE fam, husb, wife, chil, rest;
{
	NODE node = NULL;
	nchild(fam) = NULL;
	if (husb) {
		nchild(fam) = node = husb;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (wife) {
		if (node)
			node = nsibling(node) = wife;
		else
			nchild(fam) = node = wife;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (rest) {
		if (node)
			node = nsibling(node) = rest;
		else
			nchild(fam) = node = rest;
		while (nsibling(node))
			node = nsibling(node);
	}
	if (chil) {
		if (node)
			nsibling(node) = chil;
		else
			nchild(fam) = chil;
	}
}
