/*=============================================================
 * utils.c - Low level BTREE utilities
 * Copyright(c) 1991-94 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    3.0.0 - 04 Oct 94
 *===========================================================*/

#include "standard.h"
#include "btree.h"

INT bterrno = 0;

/*=========================================
 * rkey2str -- Convert record key to STRING
 *=======================================*/
STRING rkey2str (rkey)
RKEY rkey;
{
	static char rbuf[9];
	SHORT i;
	for (i = 0; i < 8; i++)
		rbuf[i] = rkey.r_rkey[i];
	rbuf[8] = 0;
	for (i = 0; rbuf[i] == ' '; i++)
		;
	return &rbuf[i];
}
/*=========================================
 * str2rkey -- Convert STRING to record key
 *=======================================*/
RKEY str2rkey (str)
STRING str;
{
	RKEY rkey;
	SHORT i = 0, n = strlen(str);
	ASSERT(n > 0);
	n = 8 - n;
	i = 0;
	if (n > 0)
		for (; i < n; i++)
			rkey.r_rkey[i] = ' ';
	for (; i < 8; i++) 
		rkey.r_rkey[i] = *str++;
	return rkey;
}
/*======================================
 * path2fkey -- Convert path to file key
 *====================================*/
FKEY path2fkey (path)
STRING path;
{
	SHORT hi = (path[0] -'a')*26 + path[1] - 'a';
	SHORT lo = (path[3] -'a')*26 + path[4] - 'a';
	return (hi<<16) + lo;
}
/*======================================
 * fkey2path -- Convert file key to path
 *====================================*/
STRING fkey2path (fkey)
FKEY fkey;
{
	static char path[6];
	SHORT hi = (fkey & 0xffff0000) >> 16;
	SHORT lo = fkey & 0xffff;
	path[0] = hi/26 + 'a';
	path[1] = hi%26 + 'a';
	path[2] = '/';
	path[3] = lo/26 + 'a';
	path[4] = lo%26 + 'a';
	path[5] = 0;
	return path;
}
/*==============================================
 * nextfkey -- Increment next file key for BTREE
 *============================================*/
nextfkey (btree)
BTREE btree;
{
	FKEY fkey = btree->b_kfile.k_fkey;
	SHORT hi = (fkey & 0xffff0000) >> 16;
	SHORT lo = fkey & 0xffff;
	char scratch[200];
	if (lo == hi)
		fkey = lo;
	else if (hi > lo)
		++fkey;
	else if (hi < lo-1)
		fkey += 0x10000;
	else {
		fkey += 0x20000;
		fkey &= 0xffff0000;
		sprintf(scratch, "%s/%s", btree->b_basedir, fkey2path(fkey));
		if (!mkalldirs(scratch))
			FATAL();
	}
	btree->b_kfile.k_fkey = fkey;
}
/*==========================================
 * newmaster -- Change master index of BTREE
 *========================================*/
newmaster (btree, master)
BTREE btree;  /*btree handle*/
INDEX master;
{
	btree->b_kfile.k_mkey = iself(master);
	rewind(btree->b_kfp);
	if (fwrite(&btree->b_kfile, sizeof(KEYFILE), 1, btree->b_kfp) != 1) {
		bterrno = BTERRKFILE;
		return FALSE;
	}
	btree->b_master = master;
	return TRUE;
}
