/*==================================================================
 * btedit.c -- Command that allows individual BTREE records to be
 *   edited directly.  Can only be used on records that are in pure
 *   ASCII format.
 * Copyright(c) 1991 by Thomas Trask Wetmore IV; all rights reserved
 *==================================================================
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "standard.h"
#include "btree.h"

/*==============================================
 * main -- Main procedure of the btedit command.
 *=============================================*/
main (argc, argv)
INT argc;
STRING *argv;
{
	BTREE btree;

	if (argc != 3) {
		printf("usage: btedit <btree> <rkey>\n");
		exit(1);
	}
	if (!(btree = openbtree("", argv[1], FALSE))) {
		printf("could not open btree: %s\n", argv[1]);
		exit(1);
	}
	if (!getfile(btree, str2rkey(argv[2]), "tmp")) {
		printf("there is no record with that key\n");
		exit(0);
	}
	system("vi tmp");
	addfile(btree, str2rkey(argv[2]), "tmp");
	system("rm -f tmp");
}
/*==========================================================
 * __allocate -- Allocates memory - called by sdtalloc macro.
 *==========================================================*/
char *__allocate (len, file, line, str)
int len;    /* number of bytes to allocate */
char *file; /* name of C file requesting memory */
int line;   /* line number in file */
char *str;  /* string to be written to log file */
{
	char *p;
	if ((p = malloc(len)) == NULL)  FATAL();
	return p;
}

/*==========================================================
 * __deallocate - Returns memory - called by sdtfree macro.
 *==========================================================*/
__deallocate (ptr, file, line, str)
char *ptr;  /* address of memory being returned */
char *file; /* name of C file returning memory */
int line;   /* line number in file */
char *str;  /* string to be written to log file */
{
	free(ptr);
}
#if 0
/*==================================================================
 * strsave -- Saves a copy of a string.
 *==================================================================*/
STRING strsave (str)
STRING str;
{
	STRING strcpy();
	return strcpy(malloc(strlen(str) + 1), str);
}
/*==================================================================
 * type -- Returns the type of a character.
 *==================================================================*/
INT type (ch)
INT ch;
{
	if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r')
		return WHITE;
	if (ch >= 'a' && ch <= 'z') return LETTER;
	if (ch >= 'A' && ch <= 'Z') return LETTER;
	if (ch >= '0' && ch <= '9') return DIGIT;
	return ch;
}
/*===================================================================
 * assert -- Asserts that a condition MUST be true.
 *===================================================================*/
assert (cond)
int cond;
{
	if (!cond)  FATAL();
}
#endif
/*==============================
 * fatal -- Fatal error routine.
 *=============================*/
__fatal (file, line)
STRING file;
int line;
{
	printf("FATAL ERROR: %s: line %d\n", file, line);
	exit(1);
}
