/*================================================================
 * show.c -- ETI version of the show functions.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 24 Aug 93 - modified
 *================================================================
 */
#include "standard.h"
#include "screen.h"
#include "btree.h"
#include "table.h"
#include "gedcom.h"
#include "indiseq.h"

STRING parent_display();
STRING spouse_display();

/*===============================
 * show_person -- Display person.
 *=============================*/
show_person (person, win, row)
NODE person;
WINDOW *win;
int row;
{
	STRING s, e = NULL, evt = NULL;
	NODE fth, mth, sps = NULL, fams = NULL, child = NULL;
	INT num, nsp, i;

	fth = indi_to_fath(person);
	mth = indi_to_moth(person);
	num = 0;
	for (i = 0; i < 6; i++) {
		wmove(win, row+i, 1);
		wclrtoeol(win);
		mvwaddch(win, row+i, 78, ACS_VLINE);
	}
	nsp = 0;
	FORFAMILIES(person, fam, sp, num)
		if (sp && !sps) {
			sps = sp;
			fams = fam;
		} else if (!sps && !fams)
			fams = fam;
		if (sp)
			nsp++;
	ENDFAMILIES
	s = indi_to_name(person, 70);
	mvwprintw(win, row, 2, "%s (%s)", s, rmvat(nxref(person))+1);
	s = indi_to_event(person, "BIRT", "born: ", 74, FALSE);
	if (!s) s = indi_to_event(person, "CHR", "bapt: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+1, 4, s);
	else
		mvwaddstr(win, row+1, 4, "born:");
	s = indi_to_event(person, "DEAT", "died: ", 74, FALSE);
	if (!s) s = indi_to_event(person, "BURI", "buri: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+2, 4, s);
	else
		mvwaddstr(win, row+2, 4, "died:");
	mvwaddstr(win, row+3, 4, "father: ");
	if (fth) waddstr(win, parent_display(fth));
	mvwaddstr(win, row+4, 4, "mother: ");
	if (mth) waddstr(win, parent_display(mth));
	if (sps) {
		mvwaddstr(win, row+5, 4, "spouse: ");
		waddstr(win, spouse_display(sps, nsp, fams));
	} else if (fams) {
		evt = fam_to_event(fams, "MARR", "m. ", 35, TRUE);
		if (evt) {
			mvwaddstr(win, row+5, 4, "married: ");
			waddstr(win, evt);
		} else if (child = (NODE) fam_to_first_chil(fams)) {
			mvwaddstr(win, row+5, 4, "child: ");
			waddstr(win, parent_display(child));
		} else
			mvwaddstr(win, row+5, 4, "spouse: ");
	} else
		mvwaddstr(win, row+5, 4, "spouse: ");
}
/*======================================
 * show_long_family -- Display a family.
 *====================================*/
show_long_family (family, win, row)
NODE family;
WINDOW *win;
INT row;
{
	NODE husb, wife;
	STRING s;
	INT num, i;

	husb = fam_to_husb(family);
	wife = fam_to_wife(family);
	num = node_list_length(CHIL(family));

	for (i = 0; i < 8; i++) {
		wmove(win, row+i, 1);
		wclrtoeol(win);
		mvwaddch(win, row+i, 78, ACS_VLINE);
	}
	mvwaddstr(win, row, 2, "husband: ");
	if (husb) {
		wprintw(win, "%s", indi_to_name(husb, 51));
		wprintw(win, " (%s)", rmvat(nxref(husb))+1);
		wprintw(win, " (%s)", rmvat(nxref(family))+1);
	} else
		wprintw(win, "(%s)", rmvat(nxref(family))+1);
	s = indi_to_event(husb, "BIRT", "born: ", 74, FALSE);
	if (!s) s = indi_to_event(husb, "CHR", "bapt: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+1, 4, s);
	else
		mvwaddstr(win, row+1, 4, "born:");
	s = indi_to_event(husb, "DEAT", "died: ", 74, FALSE);
	if (!s) s = indi_to_event(husb, "BURI", "buri: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+2, 4, s);
	else
		mvwaddstr(win, row+2, 4, "died:");
	mvwaddstr(win, row+3, 2, "wife: ");
	if (wife) {
		wprintw(win, "%s", indi_to_name(wife, 62));
		wprintw(win, " (%s)", rmvat(nxref(wife))+1);
	}
	s = indi_to_event(wife, "BIRT", "born: ", 74, FALSE);
	if (!s) s = indi_to_event(wife, "CHR", "bapt: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+4, 4, s);
	else
		mvwaddstr(win, row+4, 4, "born:");
	s = indi_to_event(wife, "DEAT", "died: ", 74, FALSE);
	if (!s) s = indi_to_event(wife, "BURI", "buri: ", 74, FALSE);
	if (s)
		mvwaddstr(win, row+5, 4, s);
	else
		mvwaddstr(win, row+5, 4, "died:");
	s = indi_to_event(family, "MARR", "married: ", 76, FALSE);
	if (s)
		mvwaddstr(win, row+6, 2, s);
	else
		mvwaddstr(win, row+6, 2, "married:");
	mvwprintw(win, row+7, 2, "children: %d", num);
}
/*=======================================
 * show_short_family -- Display a family.
 *=====================================*/
show_short_family (family, win, row)
NODE family;
WINDOW *win;
INT row;
{
	NODE husb, wife;
	STRING s;
	INT num, i;

	husb = fam_to_husb(family);
	wife = fam_to_wife(family);
	num = node_list_length(CHIL(family));
	for (i = 0; i < 6; i++) {
		wmove(win, row+i, 1);
		wclrtoeol(win);
		mvwaddch(win, row+i, 78, ACS_VLINE);
	}
	mvwaddstr(win, row, 2, "husband: ");
	if (husb) {
		wprintw(win, "%s", indi_to_name(husb, 65));
		wprintw(win, " (%s)", rmvat(nxref(husb))+1);
		wprintw(win, " (%s)", rmvat(nxref(family))+1);
	} else
		wprintw(win, "(%s)", rmvat(nxref(family))+1);
	s = indi_to_event(husb, "BIRT", "born: ", 74, FALSE);
	if (!s) s = indi_to_event(husb, "DEAT", "died: ", 74, FALSE);
	if (!s) s = indi_to_event(husb, "CHR", "bapt: ", 74, FALSE);
	if (!s) s = indi_to_event(husb, "BURI", "buri: ", 74, FALSE);
	if (s)  mvwaddstr(win, row+1, 4, s);
	else    mvwaddstr(win, row+1, 4, "born:");
	mvwaddstr(win, row+2, 2, "wife: ");
	if (wife) {
		wprintw(win, "%s", indi_to_name(wife, 76));
		wprintw(win, " (%s)", rmvat(nxref(wife))+1);
	}
	s = indi_to_event(wife, "BIRT", "born: ", 74, FALSE);
	if (!s) s = indi_to_event(wife, "DEAT", "died: ", 74, FALSE);
	if (!s) s = indi_to_event(wife, "CHR", "bapt: ", 74, FALSE);
	if (!s) s = indi_to_event(wife, "BURI", "buri: ", 74, FALSE);
	if (s) mvwaddstr(win, row+3, 4, s);
	else   mvwaddstr(win, row+3, 4, "born:");
	s = indi_to_event(family, "MARR", "married: ", 76, FALSE);
	if (s) mvwaddstr(win, row+4, 2, s);
	else   mvwaddstr(win, row+4, 2, "married:");
	mvwprintw(win, row+5, 2, "children: %d", num);
}
/*========================================================
 * show_pedigree -- Show an individual in pedigree format.
 *======================================================*/
show_pedigree (indi)
NODE indi;
{
	NODE f, m, ff, fm, mf, mm;
	NODE fff, ffm, fmf, fmm, mff, mfm, mmf, mmm;
	STRING indi_to_ped_fix();
	WINDOW *w = pedigree_window;
	INT i;

	f = indi_to_fath(indi);	/* First generation back */
	m = indi_to_moth(indi);

	ff = indi_to_fath(f);	/* Second generation back */
	fm = indi_to_moth(f);
	mf = indi_to_fath(m);
	mm = indi_to_moth(m);

	fff = indi_to_fath(ff);	/* Third generation back */
	ffm = indi_to_moth(ff);
	fmf = indi_to_fath(fm);
	fmm = indi_to_moth(fm);
	mff = indi_to_fath(mf);
	mfm = indi_to_moth(mf);
	mmf = indi_to_fath(mm);
	mmm = indi_to_moth(mm);

	for (i = 1; i <= 15; i++) {
		wmove(w, i, 1);
		wclrtoeol(w);
		mvwaddch(w, i, 78, ACS_VLINE);
	}
	mvwprintw(w, 1, 2, "                  %s", indi_to_ped_fix(fff, 52));
	mvwprintw(w, 2, 2, "            %s", indi_to_ped_fix(ff, 60));
	mvwprintw(w, 3, 2, "                  %s", indi_to_ped_fix(ffm, 52));
	mvwprintw(w, 4, 2, "      %s", indi_to_ped_fix(f, 68));
	mvwprintw(w, 5, 2, "                  %s", indi_to_ped_fix(fmf, 52));
	mvwprintw(w, 6, 2, "            %s", indi_to_ped_fix(fm, 60));
	mvwprintw(w, 7, 2, "                  %s", indi_to_ped_fix(fmm, 52));
 	mvwprintw(w, 8, 2, "%s",indi_to_ped_fix(indi, 68));
	mvwprintw(w, 9, 2, "                  %s", indi_to_ped_fix(mff, 52));
	mvwprintw(w, 10, 2, "            %s", indi_to_ped_fix(mf, 60));
	mvwprintw(w, 11, 2, "                  %s", indi_to_ped_fix(mfm, 52));
	mvwprintw(w, 12, 2, "      %s", indi_to_ped_fix(m, 68));
	mvwprintw(w, 13, 2, "                  %s", indi_to_ped_fix(mmf, 52));
	mvwprintw(w, 14, 2, "            %s", indi_to_ped_fix(mm, 60));
	mvwprintw(w, 15, 2, "                  %s", indi_to_ped_fix(mmm, 52));
}
/*=====================================================================
 * indi_to_ped_fix -- Construct a person STRING for the pedigree panel.
 *===================================================================*/
STRING indi_to_ped_fix (indi, len)
NODE indi;
INT len;
{
	STRING bevt, devt;
	static char scratch[100];
	STRING name, key;

	if (!indi) return "------------";
	bevt = event_to_date(BIRT(indi), TRUE);
	if (!bevt) bevt = event_to_date(BAPT(indi), TRUE);
	if (!bevt) bevt = "";
	devt = event_to_date(DEAT(indi), TRUE);
	if (!devt) devt = event_to_date(BURI(indi), TRUE);
	if (!devt) devt = "";
	name = indi_to_name(indi, len);
	if (keyflag) key = rmvat(nxref(indi)) + 1;
	if (keyflag)
		sprintf(scratch, "%s [%s-%s] (%s)", name, bevt, devt, key);
	else
		sprintf(scratch, "%s (%s-%s)", name, bevt, devt);
	return scratch;
}
/*===============================================================
 * parent_display -- Create parent display line for person panel.
 *=============================================================*/
STRING parent_display (indi)
NODE indi;
{
	STRING evt = NULL;
	static char scratch[100];
	char *p = scratch;

	if (!indi) return NULL;
	strcpy(p, indi_to_name(indi, 40));
	p += strlen(p);
	evt = indi_to_event(indi, "BIRT", "b. ", 20, TRUE);
	if (!evt) evt = indi_to_event(indi, "CHR", "bap. ", 20, TRUE);
	if (evt) {
		sprintf(p, ", %s", evt);
		p += strlen(p);
	}
	evt = indi_to_event(indi, "DEAT", "d. ", 20, TRUE);
	if (!evt) evt = indi_to_event(indi, "BURI", "bur. ", 20, TRUE);
	if (evt) {
		sprintf(p, ", %s", evt);
		p += strlen(p);
	}
	sprintf(p, " (%s)", rmvat(nxref(indi)) + 1);
	scratch[66] = 0;
	return scratch;
}
/*===============================================================
 * spouse_display -- Create spouse display line for person panel.
 *=============================================================*/
STRING spouse_display (sps, nsp, fams)
NODE sps, fams;
INT nsp;
{
	static char scratch[100];
	STRING p = scratch, evt, nam;
	NODE child;

	nam = indi_to_name(sps, 40);
	strcpy(p, nam);
	p += strlen(p);
	evt = fam_to_event(fams, "MARR", "m. ", 35, TRUE);
	if (!evt) {
		child = (NODE) fam_to_first_chil(fams);
		if (child) {
			evt = indi_to_event(child, "BIRT", "cb. ", 35, TRUE);
			if (!evt)
				evt = indi_to_event(child, "CHR", "cb. ",
				    35, TRUE);
		}
	}
	if (!evt) evt = indi_to_event(sps, "BIRT", "b. ", 35, TRUE);
	if (!evt) evt = indi_to_event(sps, "CHR", "bap. ", 35, TRUE);
	if (!evt) evt = indi_to_event(sps, "DEAT", "d. ", 35, TRUE);
	if (!evt) evt = indi_to_event(sps, "BURI", "bur. ", 35, TRUE);
	if (evt) {
		sprintf(p, ", %s", evt);
		p += strlen(p);
	}
	sprintf(p, " (%s)", rmvat(nxref(sps))+1);
	p += strlen(p);
	--nsp;
	if (nsp > 1) sprintf(p, " (%d others)", nsp);
	p += strlen(p);
	if (nsp == 1) sprintf(p, " (1 other)");
	scratch[66] = 0;
	return scratch;
}
static STRING empstr = "                                                 ";
/*====================================================
 * show_list
 *===================================================*/
#define VIEWABLE 12
show_list (seq, top, cur, mark)
INDISEQ seq;
INT top, cur, mark;
{
	WINDOW *win = list_window;
	INT i, j, row, len = length_indiseq(seq);
	STRING key, name;
	NODE indi;
	char scratch[200], *p;

	for (i = 8; i <= 19; i++)
		mvwaddstr(win, i, 1, empstr);
	row = 8;
	for (i = top, j = 0; j < VIEWABLE && i < len; i++, j++) {
		element_indiseq(seq, i, &key, &name);
		indi = key_to_indi(key);
		if (i == mark) mvwaddch(win, row, 2, 'x');
		if (i == cur) {
			mvwaddch(win, row, 3, '>');
			show_person(indi, win, 1);
		}
		name = manip_name(name, TRUE, TRUE, 40);
		strcpy(scratch, name);
		p = scratch + strlen(scratch);
		*p++ = ' ';
		sprintf(p, "(%s)", &key[1]);
		mvwaddstr(win, row, 4, scratch);
		row++;
	}
}
