/*================================================================
 * abbrev.c -- This file contains the routines that implement the
 *   LifeLines abbreviation features.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 14 Aug 93 - modified
 *=================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"

extern STRING abverr, aredit;

/*==================================================================
 * init_abbvtab_from_rec -- Initialize an abbrevtable from an abbrev
 *   table in the database.
 *=================================================================*/
BOOLEAN init_abbvtab_from_rec (key, tab)
STRING key;	/* key of abbrv table */
TABLE tab;	/* hash table to hold abbrevs */
{
	INT len;
	STRING rec;
	BOOLEAN rc;

	if (tab) {
		remove_table(tab, NULL);
		tab = create_table();
	}
	if (!(rec = retrieve_record(key, &len))) return FALSE;
	rc = init_abbvtab_from_string(rec, tab);
	stdfree(rec);
	return rc;
}
/*==========================================================
 * init_abbvtab_from_file -- Init an abbrev table from file.
 *========================================================*/
BOOLEAN init_abbvtab_from_file (fname, tab)
STRING fname;	/* file that contains abbrv table */
TABLE tab;	/* hash table to hold abbrvs */
{
	FILE *fp;
	char abv[20], val[100];
	INT c;
	STRING p;
	BOOLEAN rc = TRUE;

	if (!(fp = fopen(fname, "r"))) return FALSE;
	while (TRUE) {
		p = abv;
		while ((c = *p++ = getc(fp)) != EOF && c != '@' && c != '\n')
			;
		if (c == EOF)  {
			fclose(fp);
			return rc ? (p - 1 == abv) : FALSE;
		}
		if (c == '\n') {
			rc = FALSE;
			continue;
		}
		*(p - 1) = 0;
		p = val;
		while ((c = *p++ = getc(fp)) != EOF && c != '\n')
			;
		*(p - 1) = 0;
		insert_table(tab, strsave(val), strsave(abv));
		if (c == EOF) break;
	}
	fclose(fp);
	return rc;
}
/*==============================================================
 * init_abbvtab_from_string -- Init an abbrev table from string.
 *============================================================*/
BOOLEAN init_abbvtab_from_string (str, tab)
STRING str;
TABLE tab;
{
	STRING abv, val, p = str;
	INT c;
	BOOLEAN rc = TRUE;

	while (TRUE) {
		abv = p;
		while ((c = *p++) && c != '@' && c != '\n')
			;
		if (c == 0) return FALSE;
		if (c == '\n') {
			rc = FALSE;
			continue;
		}
		*(p - 1) = 0;
		val = p;
		while ((c = *p++) && c != '\n')
			;
		*(p - 1) = 0;
		insert_table(tab, strsave(val), strsave(abv));
		if (c == 0) break;
	}
	return rc;
}
/*=======================================================
 * edit_abbv_table -- Edit an abbrev table from database.
 *=====================================================*/
BOOLEAN edit_abbv_table (key, ptab)
STRING key;	/* key of abbrv table */
TABLE *ptab;	/* hash table to hold abbrvs */
{
	TABLE tmptab = NULL;
	char scratch[50];

	endwin();
	sprintf(scratch, "rm -f %s", editfile);
	system(scratch);
	retrieve_file(key, editfile);
	system(editstr);
	while (TRUE) {
		tmptab = create_table();
		if (init_abbvtab_from_file(editfile, tmptab)) {
			if (*ptab) remove_table(*ptab, NULL);
			*ptab = tmptab;
			store_file(key, editfile);
			return TRUE;
		}
		if (ask_yes_or_no_msg(abverr, aredit)) {
			endwin();
			system(editstr);
		} else {
			remove_table(tmptab, NULL);
			return FALSE;
		}
		remove_table(tmptab, NULL);
	}
}
/*======================================================
 * edit_plac_abbvs -- Edit the place name abbrvs record.
 *====================================================*/
edit_plac_abbvs()
{
	edit_abbv_table ("VPLAC", &placabbvs);
}
